/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.dashboard.renderer.client;

import javax.enterprise.event.Event;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.renderer.client.metric.MetricDisplayer;
import org.dashbuilder.renderer.client.table.TableDisplayer;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.dashboard.renderer.client.AbstractDashboardTest;
import org.jbpm.dashboard.renderer.client.ProcessDashboardData;
import org.jbpm.dashboard.renderer.client.panel.AbstractDashboard;
import org.jbpm.dashboard.renderer.client.panel.ProcessDashboard;
import org.jbpm.dashboard.renderer.client.panel.widgets.ProcessBreadCrumb;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.CallerMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessDashboardTest
extends AbstractDashboardTest {
    @Mock
    ProcessDashboard.View view;
    @Mock
    ProcessBreadCrumb processBreadCrumb;
    @Mock
    Event<ProcessInstanceSelectionEvent> instanceSelectionEvent;
    @Mock
    DisplayerListener totalMetricListener;
    @Mock
    PerspectiveManager perspectiveManagerMock;
    @Mock
    UberfireBreadcrumbs uberfireBreadcrumbsMock;
    @Mock
    ContainerSpec containerSpecMock;
    @Mock
    ServerTemplate serverTemplateMock;
    @Mock
    Event<NotificationEvent> notificationEvent;
    @Mock
    SpecManagementService specManagementService;
    Caller<SpecManagementService> specManagementServiceCaller;
    ProcessDashboard presenter;
    DataSet dataSet;

    @Override
    public void registerDataset() throws Exception {
        this.dataSet = ProcessDashboardData.INSTANCE.toDataSet();
        this.dataSet.setUUID("processesMonitoring");
        this.clientDataSetManager.registerDataSet(this.dataSet);
    }

    @Override
    protected AbstractDashboard.View getView() {
        return this.view;
    }

    @Override
    protected AbstractDashboard getPresenter() {
        return this.presenter;
    }

    @Override
    public AbstractDisplayer createNewDisplayer(DisplayerSettings settings) {
        AbstractDisplayer displayer = super.createNewDisplayer(settings);
        if ("totalProcessesMetric".equals(settings.getUUID())) {
            displayer.addListener(new DisplayerListener[]{this.totalMetricListener});
        }
        return displayer;
    }

    @Override
    @Before
    public void init() throws Exception {
        super.init();
        this.specManagementServiceCaller = new CallerMock((Object)this.specManagementService);
        this.presenter = new ProcessDashboard(this.view, this.processBreadCrumb, this.clientServices, this.displayerLocator, this.displayerCoordinator, this.placeManager, this.instanceSelectionEvent, this.serverTemplateSelectorMenuBuilder);
        this.presenter.setSpecManagementService(this.specManagementServiceCaller);
        this.presenter.setNotificationEvent(this.notificationEvent);
        Mockito.when((Object)this.perspectiveManagerMock.getCurrentPerspective()).thenReturn(Mockito.mock(PerspectiveActivity.class));
        Mockito.when((Object)this.specManagementService.getServerTemplate(Mockito.anyString())).thenReturn((Object)this.serverTemplateMock);
        Mockito.when((Object)this.serverTemplateMock.getContainerSpec(Mockito.anyString())).thenReturn((Object)this.containerSpecMock);
        this.presenter.setPerspectiveManager(this.perspectiveManagerMock);
        this.presenter.setUberfireBreadcrumbs(this.uberfireBreadcrumbsMock);
        this.presenter.init();
    }

    @Test
    public void testDrawAll() {
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).init(this.presenter, (Displayer)this.presenter.getTotalMetric(), (Displayer)this.presenter.getActiveMetric(), (Displayer)this.presenter.getPendingMetric(), (Displayer)this.presenter.getSuspendedMetric(), (Displayer)this.presenter.getAbortedMetric(), (Displayer)this.presenter.getCompletedMetric(), (Displayer)this.presenter.getProcessesByType(), (Displayer)this.presenter.getProcessesByUser(), (Displayer)this.presenter.getProcessesByStartDate(), (Displayer)this.presenter.getProcessesByEndDate(), (Displayer)this.presenter.getProcessesByRunningTime(), (Displayer)this.presenter.getProcessesByVersion(), (Displayer)this.presenter.getProcessesTable());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showLoading();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getTotalMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getActiveMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getPendingMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getSuspendedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getAbortedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getCompletedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByType());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByUser());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByStartDate());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByEndDate());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByRunningTime());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesByVersion());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onDraw((Displayer)this.presenter.getProcessesTable());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).hideLoading();
    }

    @Test
    public void test_JBPM_4851_Fix() {
        Assert.assertEquals((Object)this.presenter.getTotalMetric().isFilterOn(), (Object)true);
    }

    @Test
    public void test_JBPM_5834_Fix() {
        Assert.assertEquals((Object)this.presenter.getTotalMetric().isFilterOn(), (Object)true);
        ((DisplayerListener)Mockito.verify((Object)this.totalMetricListener, (VerificationMode)Mockito.never())).onFilterEnabled((Displayer)Mockito.any(), (DataSetFilter)Mockito.any(DataSetFilter.class));
    }

    @Test
    public void testShowInstances() {
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.showTable();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showInstances();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getProcessesTable());
    }

    @Test
    public void testShowDashboard() {
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.showDashboard();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showDashboard();
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onRedraw((Displayer)this.presenter.getProcessesTable());
    }

    @Test
    public void testTotalMetric() {
        MetricDisplayer displayer = this.presenter.getTotalMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)4.0);
    }

    @Test
    public void testActiveMetric() {
        MetricDisplayer displayer = this.presenter.getActiveMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)3.0);
    }

    @Test
    public void testCompletedMetric() {
        MetricDisplayer displayer = this.presenter.getCompletedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)1.0);
    }

    @Test
    public void testAbortedTotalMetric() {
        MetricDisplayer displayer = this.presenter.getAbortedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)0.0);
    }

    @Test
    public void testPendingMetric() {
        MetricDisplayer displayer = this.presenter.getPendingMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)0.0);
    }

    @Test
    public void testSuspendedMetric() {
        MetricDisplayer displayer = this.presenter.getSuspendedMetric();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((Object)dataSet.getValueAt(0, 0), (Object)0.0);
    }

    @Test
    public void testProcessesByEndDate() {
        AbstractDisplayer displayer = this.presenter.getProcessesByEndDate();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"2019-01-02", "1.00"}}, (int)0);
    }

    @Test
    public void testProcessesByStartDate() {
        AbstractDisplayer displayer = this.presenter.getProcessesByStartDate();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"2019-01-01", "4.00"}}, (int)0);
    }

    @Test
    public void testProcessesByRunningTime() {
        AbstractDisplayer displayer = this.presenter.getProcessesByRunningTime();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"Process B", "1.00", "100,000.00", "Process B", "1.00"}}, (int)0);
    }

    @Test
    public void testProcessesByType() {
        AbstractDisplayer displayer = this.presenter.getProcessesByType();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"Process A", "2.00"}, {"Process B", "2.00"}}, (int)0);
    }

    @Test
    public void testProcessesByUser() {
        AbstractDisplayer displayer = this.presenter.getProcessesByUser();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"user1", "2.00"}, {"user2", "2.00"}}, (int)0);
    }

    @Test
    public void testProcessesByVersion() {
        AbstractDisplayer displayer = this.presenter.getProcessesByVersion();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1", "4.00"}}, (int)0);
    }

    @Test
    public void testProcessesTable() {
        TableDisplayer displayer = this.presenter.getProcessesTable();
        DataSet dataSet = displayer.getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "org.jbpm.test", "1", "Process A", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"2.00", "org.jbpm.test", "1", "Process A", "user2", "1.00", "1", "01/01/19 12:00", "", ""}, {"3.00", "org.jbpm.test", "1", "Process B", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"4.00", "org.jbpm.test", "1", "Process B", "user2", "2.00", "1", "01/01/19 12:00", "01/02/19 10:00", "100,000.00"}}, (int)0);
    }

    @Test
    public void testSelectProcess() {
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        this.presenter.getProcessesByType().filterUpdate("processName", 1);
        String process = "Process B";
        Assert.assertEquals((Object)this.presenter.getSelectedProcess(), (Object)"Process B");
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).showBreadCrumb("Process B");
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.selectedProcessStatusHeader("", "Process B"));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)12))).onRedraw((Displayer)Mockito.any(Displayer.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onError((Displayer)Mockito.any(Displayer.class), (ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
    }

    @Test
    public void testRedrawSelectedMetric() {
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        activeMetric.filterApply();
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        Mockito.reset((Object[])new MetricDisplayer.View[]{this.presenter.getTotalMetric().getView()});
        Mockito.reset((Object[])new MetricDisplayer.View[]{this.presenter.getActiveMetric().getView()});
        Mockito.reset((Object[])new MetricDisplayer.View[]{this.presenter.getSuspendedMetric().getView()});
        Mockito.reset((Object[])new MetricDisplayer.View[]{this.presenter.getCompletedMetric().getView()});
        Mockito.reset((Object[])new MetricDisplayer.View[]{this.presenter.getPendingMetric().getView()});
        this.presenter.getProcessesByType().filterUpdate("processName", 1);
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getTotalMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getActiveMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getSuspendedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getCompletedMetric());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onRedraw((Displayer)this.presenter.getPendingMetric());
        ((MetricDisplayer.View)Mockito.verify((Object)this.presenter.getTotalMetric().getView())).setHtml(Mockito.anyString());
        ((MetricDisplayer.View)Mockito.verify((Object)this.presenter.getActiveMetric().getView())).setHtml(Mockito.anyString());
        ((MetricDisplayer.View)Mockito.verify((Object)this.presenter.getSuspendedMetric().getView())).setHtml(Mockito.anyString());
        ((MetricDisplayer.View)Mockito.verify((Object)this.presenter.getCompletedMetric().getView())).setHtml(Mockito.anyString());
        ((MetricDisplayer.View)Mockito.verify((Object)this.presenter.getPendingMetric().getView())).setHtml(Mockito.anyString());
    }

    @Test
    public void testResetProcess() {
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        this.presenter.resetCurrentProcess();
        Assert.assertNull((Object)this.presenter.getSelectedProcess());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).hideBreadCrumb();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.allProcesses());
    }

    @Test
    public void testSelectMetric() {
        this.presenter.resetCurrentMetric();
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        Mockito.reset((Object[])new DisplayerListener[]{this.displayerListener});
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        activeMetric.filterApply();
        Assert.assertEquals((Object)this.presenter.getSelectedMetric(), (Object)activeMetric);
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.activeProcesses());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterEnabled((Displayer)Mockito.eq((Object)activeMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)1))).onFilterEnabled((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.never())).onFilterReset((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getProcessesTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "org.jbpm.test", "1", "Process A", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"2.00", "org.jbpm.test", "1", "Process A", "user2", "1.00", "1", "01/01/19 12:00", "", ""}, {"3.00", "org.jbpm.test", "1", "Process B", "user1", "1.00", "1", "01/01/19 12:00", "", ""}}, (int)0);
    }

    @Test
    public void testResetMetric() {
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        activeMetric.filterApply();
        Mockito.reset((Object[])new Object[]{this.displayerListener, this.view});
        activeMetric.filterReset();
        Assert.assertNull((Object)this.presenter.getSelectedMetric());
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.allProcesses());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterReset((Displayer)Mockito.eq((Object)activeMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener, (VerificationMode)Mockito.times((int)1))).onFilterReset((Displayer)Mockito.any(Displayer.class), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getProcessesTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"1.00", "org.jbpm.test", "1", "Process A", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"2.00", "org.jbpm.test", "1", "Process A", "user2", "1.00", "1", "01/01/19 12:00", "", ""}, {"3.00", "org.jbpm.test", "1", "Process B", "user1", "1.00", "1", "01/01/19 12:00", "", ""}, {"4.00", "org.jbpm.test", "1", "Process B", "user2", "2.00", "1", "01/01/19 12:00", "01/02/19 10:00", "100,000.00"}}, (int)0);
    }

    @Test
    public void testSwitchMetric() {
        MetricDisplayer activeMetric = this.presenter.getActiveMetric();
        MetricDisplayer completedMetric = this.presenter.getCompletedMetric();
        activeMetric.filterApply();
        Mockito.reset((Object[])new Object[]{this.displayerListener, this.view, activeMetric.getView()});
        completedMetric.filterApply();
        Assert.assertEquals((Object)this.presenter.getSelectedMetric(), (Object)completedMetric);
        ((MetricDisplayer.View)Mockito.verify((Object)activeMetric.getView())).setHtml(Mockito.anyString());
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterReset((Displayer)Mockito.eq((Object)activeMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        ((DisplayerListener)Mockito.verify((Object)this.displayerListener)).onFilterEnabled((Displayer)Mockito.eq((Object)completedMetric), (DataSetFilter)Mockito.any(DataSetFilter.class));
        DataSet dataSet = this.presenter.getProcessesTable().getDataSetHandler().getLastDataSet();
        Assertions.assertDataSetValues((DataSet)dataSet, (String[][])new String[][]{{"4.00", "org.jbpm.test", "1", "Process B", "user2", "2.00", "1", "01/01/19 12:00", "01/02/19 10:00", "100,000.00"}}, (int)0);
    }

    @Test
    public void testOpenInstanceDetailsWhenContainerStarted() {
        Mockito.when((Object)this.placeManager.getStatus("ProcessInstanceDetailsScreen")).thenReturn((Object)PlaceStatus.CLOSE);
        Mockito.when((Object)this.containerSpecMock.getStatus()).thenReturn((Object)KieContainerStatus.STARTED);
        this.presenter.tableCellSelected("processInstanceId", 3);
        ((Event)Mockito.verify(this.instanceSelectionEvent)).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("ProcessInstanceDetailsScreen");
    }

    @Test
    public void testOpenInstanceDetailsWhenContainerStopped() {
        Mockito.when((Object)this.placeManager.getStatus("ProcessInstanceDetailsScreen")).thenReturn((Object)PlaceStatus.CLOSE);
        Mockito.when((Object)this.containerSpecMock.getStatus()).thenReturn((Object)KieContainerStatus.STOPPED);
        this.presenter.tableCellSelected("processInstanceId", 3);
        ((Event)Mockito.verify(this.instanceSelectionEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(ProcessInstanceSelectionEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.never())).goTo("ProcessInstanceDetailsScreen");
        ((Event)Mockito.verify(this.notificationEvent)).fire(Mockito.any(NotificationEvent.class));
    }

    @Test
    public void testHeaderText() {
        String process = "Process Test";
        this.verifyMetricHeaderText("Process Test", this.presenter.getTotalMetric(), this.i18n.selectedProcessStatusHeader("", "Process Test"));
        this.verifyMetricHeaderText("Process Test", this.presenter.getActiveMetric(), this.i18n.selectedProcessStatusHeader(this.i18n.processStatusActive(), "Process Test"));
        this.verifyMetricHeaderText("Process Test", this.presenter.getPendingMetric(), this.i18n.selectedProcessStatusHeader(this.i18n.processStatusPending(), "Process Test"));
        this.verifyMetricHeaderText("Process Test", this.presenter.getSuspendedMetric(), this.i18n.selectedProcessStatusHeader(this.i18n.processStatusSuspended(), "Process Test"));
        this.verifyMetricHeaderText("Process Test", this.presenter.getAbortedMetric(), this.i18n.selectedProcessStatusHeader(this.i18n.processStatusAborted(), "Process Test"));
        this.verifyMetricHeaderText("Process Test", this.presenter.getCompletedMetric(), this.i18n.selectedProcessStatusHeader(this.i18n.processStatusCompleted(), "Process Test"));
        Mockito.reset((Object[])new ProcessDashboard.View[]{this.view});
        this.presenter.resetCurrentProcess();
        this.presenter.resetCurrentMetric();
        ((ProcessDashboard.View)Mockito.verify((Object)this.view)).setHeaderText(this.i18n.allProcesses());
    }
}

