/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.model;

import java.util.Date;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.es.util.ExecutionErrorType;

@Bindable
@Portable
public class ExecutionErrorSummary
extends GenericSummary<String> {
    private String errorId;
    private ExecutionErrorType type;
    private String deploymentId;
    private Long processInstanceId;
    private String processId;
    private Long activityId;
    private String activityName;
    private Long jobId;
    private String errorMessage;
    private String error;
    private Boolean acknowledged;
    private String acknowledgedBy;
    private Date acknowledgedAt;
    private Date errorDate;

    public ExecutionErrorSummary() {
    }

    public ExecutionErrorSummary(String errorId, String type, String deploymentId, Long processInstanceId, String processId, Long activityId, String activityName, Long jobId, String errorMessage, Short acknowledged, String acknowledgedBy, Date acknowledgedAt, Date errorDate) {
        this.id = errorId;
        this.name = errorId;
        this.errorId = errorId;
        this.type = ExecutionErrorType.fromType(type);
        this.deploymentId = deploymentId;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.activityId = activityId;
        this.activityName = activityName;
        this.jobId = jobId;
        this.errorMessage = errorMessage;
        this.acknowledged = acknowledged != null && acknowledged > 0;
        this.acknowledgedBy = acknowledgedBy;
        this.acknowledgedAt = acknowledgedAt;
        this.errorDate = errorDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getErrorId() {
        return this.errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = errorId;
    }

    public ExecutionErrorType getType() {
        return this.type;
    }

    public void setType(ExecutionErrorType type) {
        this.type = type;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean isAcknowledged() {
        if (this.acknowledged != null) {
            return this.acknowledged;
        }
        return false;
    }

    public void setAcknowledged(Boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public String getAcknowledgedBy() {
        return this.acknowledgedBy;
    }

    public void setAcknowledgedBy(String acknowledgedBy) {
        this.acknowledgedBy = acknowledgedBy;
    }

    public Date getAcknowledgedAt() {
        return this.acknowledgedAt;
    }

    public void setAcknowledgedAt(Date acknowledgedAt) {
        this.acknowledgedAt = acknowledgedAt;
    }

    public Date getErrorDate() {
        return this.errorDate;
    }

    public void setErrorDate(Date errorDate) {
        this.errorDate = errorDate;
    }

    public String toString() {
        return "ExecutionErrorSummary{errorId='" + this.errorId + '\'' + ", type=" + (Object)((Object)this.type) + ", deploymentId='" + this.deploymentId + '\'' + ", processInstanceId=" + this.processInstanceId + ", processId='" + this.processId + '\'' + ", activityId=" + this.activityId + ", activityName='" + this.activityName + '\'' + ", jobId=" + this.jobId + ", errorMessage='" + this.errorMessage + '\'' + ", error='" + this.error + '\'' + ", acknowledged=" + this.acknowledged + ", acknowledgedBy='" + this.acknowledgedBy + '\'' + ", acknowledgedAt=" + this.acknowledgedAt + ", errorDate=" + this.errorDate + "} " + super.toString();
    }

    public static class Builder {
        private ExecutionErrorSummary error = new ExecutionErrorSummary();

        public ExecutionErrorSummary build() {
            return this.error;
        }

        public Builder errorId(String errorId) {
            this.error.setErrorId(errorId);
            this.error.setId(errorId);
            return this;
        }

        public Builder type(ExecutionErrorType type) {
            this.error.setType(type);
            return this;
        }

        public Builder deploymentId(String deploymentId) {
            this.error.setDeploymentId(deploymentId);
            return this;
        }

        public Builder message(String message) {
            this.error.setErrorMessage(message);
            return this;
        }

        public Builder error(String errorStr) {
            this.error.setError(errorStr);
            return this;
        }

        public Builder acknowledgedBy(String user) {
            this.error.setAcknowledgedBy(user);
            return this;
        }

        public Builder processInstanceId(Long piId) {
            this.error.setProcessInstanceId(piId);
            return this;
        }

        public Builder activityId(Long activityId) {
            this.error.setActivityId(activityId);
            return this;
        }

        public Builder acknowledged(boolean acknowledged) {
            this.error.setAcknowledged(acknowledged);
            return this;
        }

        public Builder acknowledgedAt(Date acknowledgedAt) {
            this.error.setAcknowledgedAt(acknowledgedAt);
            return this;
        }

        public Builder processId(String processId) {
            this.error.setProcessId(processId);
            return this;
        }

        public Builder activityName(String activityName) {
            this.error.setActivityName(activityName);
            return this;
        }

        public Builder errorDate(Date errorDate) {
            this.error.setErrorDate(errorDate);
            return this;
        }

        public Builder jobId(Long jobId) {
            this.error.setJobId(jobId);
            return this;
        }
    }
}

