/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.backend.server;

import java.util.Collections;
import java.util.Date;
import org.jbpm.workbench.es.backend.server.ErrorSummaryMapperTest;
import org.jbpm.workbench.es.backend.server.RequestSummaryMapper;
import org.jbpm.workbench.es.model.RequestSummary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.instance.ErrorInfoInstanceList;
import org.kie.server.api.model.instance.RequestInfoInstance;

public class RequestSummaryMapperTest {
    public static void assertRequestSummary(RequestInfoInstance request, RequestSummary rs) {
        Assert.assertNotNull((Object)rs);
        Assert.assertEquals((Object)request.getId(), (Object)rs.getJobId());
        Assert.assertEquals((Object)request.getId(), (Object)rs.getId());
        Assert.assertEquals((Object)request.getStatus(), (Object)rs.getStatus());
        Assert.assertEquals((Object)request.getCommandName(), (Object)rs.getCommandName());
        Assert.assertEquals((Object)request.getBusinessKey(), (Object)rs.getKey());
        Assert.assertEquals((Object)request.getRetries(), (Object)rs.getRetries());
        Assert.assertEquals((Object)request.getScheduledDate(), (Object)rs.getTime());
        Assert.assertEquals((Object)request.getMessage(), (Object)rs.getMessage());
    }

    public static RequestInfoInstance newRequestInfoInstance() {
        return RequestInfoInstance.builder().id(Long.valueOf(1L)).businessKey("businessKey").command("commandName").data(Collections.singletonMap("key", "data")).errors(new ErrorInfoInstanceList(Collections.singletonList(ErrorSummaryMapperTest.newErrorInfoInstance()))).executions(Integer.valueOf(10)).message("message").retries(Integer.valueOf(2)).scheduledDate(new Date()).status("status").responseData(Collections.singletonMap("responseKey", "responseData")).build();
    }

    @Test
    public void testRequestSummaryMapper() {
        RequestInfoInstance request = RequestSummaryMapperTest.newRequestInfoInstance();
        RequestSummary rs = new RequestSummaryMapper().apply(request);
        RequestSummaryMapperTest.assertRequestSummary(request, rs);
    }

    @Test
    public void testRequestSummaryMapperNull() {
        Assert.assertNull((Object)new RequestSummaryMapper().apply(null));
    }
}

