/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.backend.server;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.es.backend.server.RequestDetailsMapper;
import org.jbpm.workbench.es.model.RequestDetails;
import org.jbpm.workbench.es.service.ExecutorService;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.kie.server.api.model.instance.JobRequestInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.client.JobServicesClient;

@Service
@ApplicationScoped
public class RemoteExecutorServiceImpl
extends AbstractKieServerService
implements ExecutorService {
    public RequestDetails getRequestDetails(String serverTemplateId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        Optional<RequestInfoInstance> request = Optional.ofNullable(jobClient.getRequestById(requestId, true, true));
        return request.map(new RequestDetailsMapper()).orElse(null);
    }

    public Long scheduleRequest(String serverTemplateId, String commandName, Date date, Map<String, String> ctx) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        HashMap<Object, Object> data = new HashMap();
        if (ctx != null && !ctx.isEmpty()) {
            data = new HashMap<String, String>(ctx);
        }
        JobRequestInstance jobRequest = JobRequestInstance.builder().command(commandName).data(data).scheduledDate(date).build();
        return jobClient.scheduleRequest(jobRequest);
    }

    public void cancelRequest(String serverTemplateId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        jobClient.cancelRequest(requestId.longValue());
    }

    public void requeueRequest(String serverTemplateId, Long requestId) {
        JobServicesClient jobClient = (JobServicesClient)this.getClient(serverTemplateId, JobServicesClient.class);
        jobClient.requeueRequest(requestId.longValue());
    }
}

