/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.backend.server;

import java.util.Date;
import org.jbpm.workbench.es.backend.server.ErrorSummaryMapper;
import org.jbpm.workbench.es.backend.server.ExecutionErrorSummaryMapper;
import org.jbpm.workbench.es.model.ExecutionErrorSummary;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.admin.ExecutionErrorInstance;

public class ExecutionErrorSummaryMapperTest {
    public static void assertExecutionErrorSummary(ExecutionErrorInstance error, ExecutionErrorSummary es) {
        Assert.assertNotNull((Object)es);
        Assert.assertEquals((Object)error.getErrorMessage(), (Object)es.getErrorMessage());
        Assert.assertEquals((Object)error.getError(), (Object)es.getError());
        Assert.assertEquals((Object)error.getType(), (Object)es.getType().getType());
        Assert.assertEquals((Object)error.getErrorMessage(), (Object)es.getErrorMessage());
        Assert.assertEquals((Object)error.getAcknowledgedAt(), (Object)es.getAcknowledgedAt());
        Assert.assertEquals((Object)error.getAcknowledgedBy(), (Object)es.getAcknowledgedBy());
        Assert.assertEquals((Object)error.isAcknowledged(), (Object)es.isAcknowledged());
        Assert.assertEquals((Object)error.getActivityId(), (Object)es.getActivityId());
        Assert.assertEquals((Object)error.getActivityName(), (Object)es.getActivityName());
        Assert.assertEquals((Object)error.getContainerId(), (Object)es.getDeploymentId());
        Assert.assertEquals((Object)error.getErrorId(), (Object)es.getErrorId());
        Assert.assertEquals((Object)error.getProcessId(), (Object)es.getProcessId());
        Assert.assertEquals((Object)error.getProcessInstanceId(), (Object)es.getProcessInstanceId());
        Assert.assertEquals((Object)error.getJobId(), (Object)es.getJobId());
    }

    public static ExecutionErrorInstance createTestError(String id) {
        return ExecutionErrorInstance.builder().errorId(id + "").error(id + "_stackTrace").acknowledged(false).acknowledgedAt(new Date()).acknowledgedBy("testUser").activityId(Long.valueOf(id + 20)).activityName(id + "_Act_name").errorDate(new Date()).type("Task").containerId(id + "_deployment").processInstanceId(Long.valueOf(id)).processId(id + "_processId").jobId(Long.valueOf(id)).message(id + "_message").build();
    }

    @Test
    public void testErrorSummaryMapper() {
        ExecutionErrorInstance error = ExecutionErrorSummaryMapperTest.createTestError("1");
        ExecutionErrorSummary ees = new ExecutionErrorSummaryMapper().apply(error);
        ExecutionErrorSummaryMapperTest.assertExecutionErrorSummary(error, ees);
    }

    @Test
    public void testErrorSummaryMapperNull() {
        Assert.assertNull((Object)new ErrorSummaryMapper().apply(null));
    }
}

