/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.service.providing.RenderingSettings;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.slf4j.Logger;

public abstract class KieWorkbenchFormsValuesProcessor<T extends RenderingSettings> {
    public static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    public static final String SETTINGS_ATRA_NAME = "_rendering_settings";
    protected FormDefinitionSerializer formSerializer;
    protected BackendFormRenderingContextManager contextManager;
    protected DynamicBPMNFormGenerator dynamicBPMNFormGenerator;

    public KieWorkbenchFormsValuesProcessor(FormDefinitionSerializer formSerializer, BackendFormRenderingContextManager contextManager, DynamicBPMNFormGenerator dynamicBPMNFormGenerator) {
        this.formSerializer = formSerializer;
        this.contextManager = contextManager;
        this.dynamicBPMNFormGenerator = dynamicBPMNFormGenerator;
    }

    public KieWorkbenchFormRenderingSettings generateRenderingContext(T settings) {
        return this.generateRenderingContext(settings, false);
    }

    public KieWorkbenchFormRenderingSettings generateRenderingContext(T settings, boolean generateDefaultForms) {
        if (generateDefaultForms || !StringUtils.isEmpty((CharSequence)settings.getFormContent())) {
            try {
                ContextForms forms;
                ContextForms contextForms = forms = generateDefaultForms ? this.generateDefaultForms(settings) : this.parseForms(settings);
                if (forms.getRootForm() == null || !this.isValid(forms.getRootForm())) {
                    return null;
                }
                Map<String, Object> rawData = this.generateRawFormData(settings, forms.getRootForm());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put(SERVER_TEMPLATE_ID, settings.getServerTemplateId());
                BackendFormRenderingContext context = this.contextManager.registerContext(forms.getRootForm(), rawData, settings.getMarshallerContext().getClassloader(), params, forms.getNestedForms().toArray(new FormDefinition[forms.getNestedForms().size()]));
                this.prepareContext(settings, context);
                context.getAttributes().put(SETTINGS_ATRA_NAME, settings);
                return new KieWorkbenchFormRenderingSettings(context.getTimestamp(), context.getRenderingContext());
            }
            catch (Exception ex) {
                this.getLogger().debug("Unable to generate render form: ", (Throwable)ex);
            }
        }
        return null;
    }

    public Map<String, Object> generateRuntimeValuesMap(long timestamp, Map<String, Object> formValues) {
        FormDefinition form;
        BackendFormRenderingContext context = this.contextManager.getContext(Long.valueOf(timestamp));
        if (context != null && this.isValid(form = context.getRenderingContext().getRootForm())) {
            Map formData = this.contextManager.updateContextData(timestamp, formValues).getFormData();
            return this.getOutputValues(formData, form, (RenderingSettings)context.getAttributes().get(SETTINGS_ATRA_NAME));
        }
        return Collections.emptyMap();
    }

    protected ContextForms parseForms(T settings) {
        ContextForms result = new ContextForms();
        JsonParser parser = new JsonParser();
        Gson gson = new Gson();
        JsonElement element = parser.parse(settings.getFormContent());
        JsonArray forms = element.getAsJsonArray();
        forms.forEach(jsonForm -> {
            FormDefinition formDefinition;
            String content = gson.toJson(jsonForm);
            if (!StringUtils.isEmpty((CharSequence)content) && (formDefinition = this.formSerializer.deserialize(content)) != null) {
                if (formDefinition.getName().startsWith(this.getFormName(settings) + "-taskform")) {
                    result.setRootForm(formDefinition);
                } else {
                    result.getNestedForms().add(formDefinition);
                }
            }
        });
        return result;
    }

    protected ContextForms generateDefaultForms(T settings) {
        ContextForms result = new ContextForms();
        Collection<FormDefinition> contextForms = this.generateDefaultFormsForContext(settings);
        if (contextForms == null) {
            throw new IllegalArgumentException("Unable to create forms for context");
        }
        contextForms.forEach(form -> {
            if (form.getName().equals(this.getFormName(settings) + "-taskform")) {
                result.setRootForm((FormDefinition)form);
            } else {
                result.getNestedForms().add((FormDefinition)form);
            }
        });
        return result;
    }

    protected abstract Collection<FormDefinition> generateDefaultFormsForContext(T var1);

    protected abstract Map<String, Object> getOutputValues(Map<String, Object> var1, FormDefinition var2, T var3);

    protected abstract boolean isValid(FormDefinition var1);

    protected abstract String getFormName(T var1);

    protected abstract void prepareContext(T var1, BackendFormRenderingContext var2);

    protected Map<String, Object> generateRawFormData(T settings, FormDefinition form) {
        return new HashMap<String, Object>();
    }

    protected abstract Logger getLogger();

    protected class ContextForms {
        private FormDefinition rootForm;
        private List<FormDefinition> nestedForms = new ArrayList<FormDefinition>();

        protected ContextForms() {
        }

        public FormDefinition getRootForm() {
            return this.rootForm;
        }

        public void setRootForm(FormDefinition rootForm) {
            this.rootForm = rootForm;
        }

        public List<FormDefinition> getNestedForms() {
            return this.nestedForms;
        }
    }
}

