/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.document.Document;
import org.jbpm.workbench.forms.display.FormRenderingSettings;
import org.jbpm.workbench.forms.service.providing.DefaultFormProvider;
import org.jbpm.workbench.forms.service.providing.FormProvider;
import org.jbpm.workbench.forms.service.providing.ProcessRenderingSettings;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;
import org.jbpm.workbench.forms.service.providing.model.ProcessDefinition;
import org.jbpm.workbench.forms.service.providing.model.TaskDefinition;
import org.jbpm.workbench.forms.service.shared.FormServiceEntryPoint;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@ApplicationScoped
public class FormServiceEntryPointImpl
extends AbstractKieServerService
implements FormServiceEntryPoint {
    private static final Logger logger = LoggerFactory.getLogger(FormServiceEntryPointImpl.class);
    private final FormProvider<? extends FormRenderingSettings> defaultFormProvider;
    private Set<FormProvider<? extends FormRenderingSettings>> providers = new TreeSet<FormProvider<? extends FormRenderingSettings>>((o1, o2) -> o1.getPriority() - o2.getPriority());

    @Inject
    public FormServiceEntryPointImpl(Instance<FormProvider<? extends FormRenderingSettings>> providersInjected, @DefaultFormProvider FormProvider<? extends FormRenderingSettings> defaultFormProvider) {
        for (FormProvider provider : providersInjected) {
            this.providers.add((FormProvider<? extends FormRenderingSettings>)provider);
        }
        this.defaultFormProvider = defaultFormProvider;
    }

    public FormRenderingSettings getFormDisplayTask(String serverTemplateId, String domainId, long taskId) {
        String registrationKey = serverTemplateId + "@" + domainId + "@" + System.currentTimeMillis();
        DocumentServicesClient documentClient = (DocumentServicesClient)this.getClient(serverTemplateId, domainId, DocumentServicesClient.class);
        UIServicesClient uiServicesClient = (UIServicesClient)this.getClient(serverTemplateId, domainId, UIServicesClient.class);
        UserTaskServicesClient taskClient = (UserTaskServicesClient)this.getClient(serverTemplateId, domainId, UserTaskServicesClient.class);
        TaskInstance task = taskClient.getTaskInstance(domainId, Long.valueOf(taskId), true, true, false);
        if (task == null) {
            throw new RuntimeException("No task found for id " + taskId);
        }
        ProcessServicesClient processService = (ProcessServicesClient)this.getClient(serverTemplateId, domainId, ProcessServicesClient.class);
        TaskDefinition taskInstance = new TaskDefinition();
        taskInstance.setId(task.getId());
        taskInstance.setName(task.getName());
        taskInstance.setDescription(task.getDescription());
        taskInstance.setFormName(task.getFormName());
        taskInstance.setDeploymentId(registrationKey);
        taskInstance.setProcessId(task.getProcessId());
        taskInstance.setStatus(task.getStatus());
        TaskInputsDefinition inputDefinitions = processService.getUserTaskInputDefinitions(domainId, task.getProcessId(), task.getName());
        taskInstance.setTaskInputDefinitions(inputDefinitions.getTaskInputs());
        TaskOutputsDefinition outputDefinitions = processService.getUserTaskOutputDefinitions(domainId, task.getProcessId(), task.getName());
        taskInstance.setTaskOutputDefinitions(outputDefinitions.getTaskOutputs());
        Map<String, Object> inputs = this.processData(documentClient, task.getInputData());
        Map<String, Object> outputs = this.processData(documentClient, task.getOutputData());
        if (outputs != null && !outputs.isEmpty()) {
            taskInstance.setOutputIncluded(true);
        }
        KieServicesClient kieServicesClient = this.getKieServicesClient(serverTemplateId, domainId);
        try {
            String formContent = uiServicesClient.getTaskRawForm(domainId, Long.valueOf(taskId));
            TaskRenderingSettings settings = new TaskRenderingSettings(taskInstance, inputs, outputs, serverTemplateId, formContent, new ContentMarshallerContext(null, kieServicesClient.getClassLoader()));
            for (FormProvider<? extends FormRenderingSettings> provider : this.providers) {
                FormRenderingSettings template = provider.render(settings);
                if (template == null) continue;
                return template;
            }
        }
        catch (KieServicesException e) {
            logger.debug("Unable to find task form in remote server due to {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.debug("Unable to render task form due to {}", (Object)e.getMessage());
        }
        return this.renderDefaultTaskForm(serverTemplateId, taskInstance, inputs, outputs, kieServicesClient);
    }

    private FormRenderingSettings renderDefaultTaskForm(String serverTemplateId, TaskDefinition taskInstance, Map<String, Object> inputs, Map<String, Object> outputs, KieServicesClient kieServicesClient) {
        try {
            return this.defaultFormProvider.render(new TaskRenderingSettings(taskInstance, inputs, outputs, serverTemplateId, "", new ContentMarshallerContext(null, kieServicesClient.getClassLoader())));
        }
        catch (Exception ex) {
            logger.warn("Unable to generate default form for task '" + taskInstance.getName() + "': {}", (Object)ex.getMessage());
            return null;
        }
    }

    public FormRenderingSettings getFormDisplayProcess(String serverTemplateId, String domainId, String processId) {
        ProcessServicesClient processClient = (ProcessServicesClient)this.getClient(serverTemplateId, domainId, ProcessServicesClient.class);
        org.kie.server.api.model.definition.ProcessDefinition processDefinition = processClient.getProcessDefinition(domainId, processId);
        ProcessDefinition processDesc = new ProcessDefinition();
        processDesc.setId(processDefinition.getId());
        processDesc.setName(processDefinition.getName());
        processDesc.setPackageName(processDefinition.getPackageName());
        processDesc.setDeploymentId(serverTemplateId + "@" + processDefinition.getContainerId() + "@" + System.currentTimeMillis());
        HashMap<String, String> processData = processDefinition.getProcessVariables();
        if (processData == null) {
            processData = new HashMap<String, String>();
        }
        UIServicesClient uiServicesClient = (UIServicesClient)this.getClient(serverTemplateId, domainId, UIServicesClient.class);
        KieServicesClient kieServicesClient = this.getKieServicesClient(serverTemplateId, domainId);
        try {
            String formContent = uiServicesClient.getProcessRawForm(domainId, processId);
            ProcessRenderingSettings settings = new ProcessRenderingSettings(processDesc, processData, serverTemplateId, formContent, new ContentMarshallerContext(null, kieServicesClient.getClassLoader()));
            for (FormProvider<? extends FormRenderingSettings> provider : this.providers) {
                FormRenderingSettings renderingSettings = provider.render(settings);
                if (renderingSettings == null) continue;
                return renderingSettings;
            }
        }
        catch (KieServicesException e) {
            logger.debug("Unable to find process form in remote server due to {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.debug("Unable to render process form due to {}", (Object)e.getMessage());
        }
        return this.renderDefaultProcessForm(serverTemplateId, processDesc, processData, kieServicesClient);
    }

    private FormRenderingSettings renderDefaultProcessForm(String serverTemplateId, ProcessDefinition processDesc, Map<String, String> processData, KieServicesClient kieServicesClient) {
        try {
            return this.defaultFormProvider.render(new ProcessRenderingSettings(processDesc, processData, serverTemplateId, "", new ContentMarshallerContext(null, kieServicesClient.getClassLoader())));
        }
        catch (Exception ex) {
            logger.warn("Unable to generate default form for process '" + processDesc.getName() + "': {}", (Object)ex.getMessage());
            return null;
        }
    }

    protected Map<String, Object> processData(DocumentServicesClient documentClient, Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return data;
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!(entry.getValue() instanceof Document)) continue;
            Document document = (Document)entry.getValue();
            document.setLink(documentClient.getDocumentLink(document.getIdentifier()));
        }
        return data;
    }
}

