/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jbpm.workbench.forms.display.backend.provider.AbstractFormsValuesProcessorTest;
import org.jbpm.workbench.forms.display.backend.provider.TaskFormValuesProcessor;
import org.jbpm.workbench.forms.display.backend.provider.model.Client;
import org.jbpm.workbench.forms.display.backend.provider.model.Invoice;
import org.jbpm.workbench.forms.display.backend.provider.model.InvoiceLine;
import org.jbpm.workbench.forms.display.backend.provider.util.FormContentReader;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;
import org.jbpm.workbench.forms.service.providing.model.TaskDefinition;
import org.junit.runner.RunWith;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskFormValuesProcessorTest
extends AbstractFormsValuesProcessorTest<TaskFormValuesProcessor, TaskRenderingSettings> {
    @Mock
    protected TaskDefinition task;

    @Override
    public void init() {
        super.init();
        Mockito.when((Object)this.task.getFormName()).thenReturn((Object)"modify");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("invoice", Invoice.class.getName());
        Mockito.when((Object)this.task.getTaskInputDefinitions()).thenReturn(variables);
        Mockito.when((Object)this.task.getTaskOutputDefinitions()).thenReturn(variables);
    }

    @Override
    TaskRenderingSettings getFullRenderingSettings() {
        return this.getRenderingSettings(FormContentReader.getTaskForms());
    }

    @Override
    TaskRenderingSettings getRenderingSettingsWithoutForms() {
        return this.getRenderingSettings(null);
    }

    private TaskRenderingSettings getRenderingSettings(String formContent) {
        Invoice invoice = new Invoice();
        invoice.setClient(new Client(new Long(1234L), "Dad Smurf", "Mushroom #1"));
        invoice.setDate(new Date());
        invoice.setComments("It could be better...");
        invoice.setTotal(300.5);
        ArrayList<InvoiceLine> lines = new ArrayList<InvoiceLine>();
        lines.add(new InvoiceLine("Magical book", 1, 100.5, 200.0));
        lines.add(new InvoiceLine("Nice red hat", 1, 50.0, 150.0));
        invoice.setLines(lines);
        HashMap<String, Invoice> inputs = new HashMap<String, Invoice>();
        inputs.put("invoice", invoice);
        return new TaskRenderingSettings(this.task, inputs, new HashMap(), "serverTemplateId", formContent, this.marshallerContext);
    }

    @Override
    TaskFormValuesProcessor getProcessorInstance(FormDefinitionSerializer serializer, BackendFormRenderingContextManager backendFormRenderingContextManager, DynamicBPMNFormGenerator dynamicBPMNFormGenerator) {
        return new TaskFormValuesProcessor(serializer, backendFormRenderingContextManager, dynamicBPMNFormGenerator);
    }
}

