/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.conversion;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jbpm.workbench.forms.display.backend.conversion.TaskDataConverterUtil;
import org.junit.Test;

public class TaskDataConverterUtilTest {
    private static final String STRING = "string";
    private static final String OBJECT = "object";
    private static final String DOUBLE = "double";
    private static final String FLOAT = "float";
    private static final String INTEGER = "integer";
    private static final String BOOLEAN = "boolean";
    private static final String DATE = "date";
    private static final String LIST = "list";

    @Test
    public void testSupportedConstantValues() {
        this.testSupportedConstantValues(false);
    }

    @Test
    public void testSupportedConstantValuesWithTypeAlias() {
        this.testSupportedConstantValues(true);
    }

    @Test
    public void testSupportedConstantValuesWithParsingErrors() {
        HashMap<String, String> definitions = new HashMap<String, String>();
        definitions.put(DOUBLE, Double.class.getName());
        definitions.put(FLOAT, Float.class.getName());
        definitions.put(INTEGER, Integer.class.getName());
        definitions.put(BOOLEAN, Boolean.class.getName());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(DOUBLE, "a wrong double constant");
        values.put(FLOAT, "a wrong float constant");
        values.put(INTEGER, "a wrong integer constant");
        values.put(BOOLEAN, "a wrong boolean constant");
        TaskDataConverterUtil.convert(definitions, values);
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(values).containsEntry((Object)DOUBLE, null)).containsEntry((Object)FLOAT, null)).containsEntry((Object)INTEGER, null)).containsEntry((Object)BOOLEAN, (Object)false);
    }

    @Test
    public void testWithoutConstantValues() {
        this.testWithoutConstantValues(false);
    }

    @Test
    public void testWithoutConstantValuesWithTypeAlias() {
        this.testWithoutConstantValues(true);
    }

    @Test
    public void testUnsupportedConstants() {
        HashMap<String, String> definitions = new HashMap<String, String>();
        definitions.put(DATE, Date.class.getName());
        definitions.put(LIST, List.class.getName());
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(DATE, "a date constant");
        values.put(LIST, "a list constant");
        TaskDataConverterUtil.convert(definitions, values);
        ((MapAssert)Assertions.assertThat(values).containsEntry((Object)DATE, null)).containsEntry((Object)LIST, null);
    }

    private void testWithoutConstantValues(boolean useTypeAlias) {
        HashMap<String, String> definitions = new HashMap<String, String>();
        definitions.put(STRING, this.resolveType(String.class, useTypeAlias));
        definitions.put(OBJECT, this.resolveType(Object.class, useTypeAlias));
        definitions.put(DOUBLE, this.resolveType(Double.class, useTypeAlias));
        definitions.put(FLOAT, this.resolveType(Float.class, useTypeAlias));
        definitions.put(INTEGER, this.resolveType(Integer.class, useTypeAlias));
        definitions.put(BOOLEAN, this.resolveType(Boolean.class, useTypeAlias));
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(STRING, STRING);
        values.put(OBJECT, OBJECT);
        values.put(DOUBLE, 1.5);
        values.put(FLOAT, Float.valueOf(1.5f));
        values.put(INTEGER, 1000);
        values.put(BOOLEAN, true);
        TaskDataConverterUtil.convert(definitions, values);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(values).containsEntry((Object)STRING, (Object)STRING)).containsEntry((Object)OBJECT, (Object)OBJECT)).containsEntry((Object)DOUBLE, (Object)1.5)).containsEntry((Object)FLOAT, (Object)Float.valueOf(1.5f))).containsEntry((Object)INTEGER, (Object)1000)).containsEntry((Object)BOOLEAN, (Object)true);
    }

    private void testSupportedConstantValues(boolean useTypeAlias) {
        HashMap<String, String> definitions = new HashMap<String, String>();
        definitions.put(STRING, this.resolveType(String.class, useTypeAlias));
        definitions.put(OBJECT, this.resolveType(Object.class, useTypeAlias));
        definitions.put(DOUBLE, this.resolveType(Double.class, useTypeAlias));
        definitions.put(FLOAT, this.resolveType(Float.class, useTypeAlias));
        definitions.put(INTEGER, this.resolveType(Integer.class, useTypeAlias));
        definitions.put(BOOLEAN, this.resolveType(Boolean.class, useTypeAlias));
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(STRING, STRING);
        values.put(OBJECT, OBJECT);
        values.put(DOUBLE, "1.5");
        values.put(FLOAT, "1.5");
        values.put(INTEGER, "1000");
        values.put(BOOLEAN, "false");
        TaskDataConverterUtil.convert(definitions, values);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(values).containsEntry((Object)STRING, (Object)STRING)).containsEntry((Object)OBJECT, (Object)OBJECT)).containsEntry((Object)DOUBLE, (Object)1.5)).containsEntry((Object)FLOAT, (Object)Float.valueOf(1.5f))).containsEntry((Object)INTEGER, (Object)1000)).containsEntry((Object)BOOLEAN, (Object)false);
    }

    private String resolveType(Class type, boolean useTypeAlias) {
        return useTypeAlias ? type.getSimpleName() : type.getName();
    }
}

