/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.workbench.forms.display.backend.FormRendererProxyServlet;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.process.CorrelationKey;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.impl.KieServicesClientImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FormRendererProxyServletTest {
    @Mock
    KieServerIntegration kieServerIntegration;
    @InjectMocks
    FormRendererProxyServlet servlet;

    @Test
    public void testStartProcessWithKieServerFormRenderer() throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        String correlationKey = "test-correlationKey";
        Mockito.when((Object)request.getParameter((String)ArgumentMatchers.eq((Object)"templateid"))).thenReturn((Object)"test-templateid");
        Mockito.when((Object)request.getParameter((String)ArgumentMatchers.eq((Object)"correlationKey"))).thenReturn((Object)correlationKey);
        Mockito.when((Object)request.getPathInfo()).thenReturn((Object)"/containers/1/processes/2");
        BufferedReader reader = (BufferedReader)Mockito.mock(BufferedReader.class);
        Stream stream = (Stream)Mockito.mock(Stream.class);
        Mockito.when((Object)request.getReader()).thenReturn((Object)reader);
        Mockito.when(reader.lines()).thenReturn((Object)stream);
        Mockito.when(stream.collect((Collector)ArgumentMatchers.any())).thenReturn((Object)"{\"name\" : \"value\"}");
        KieServicesClientImpl client = (KieServicesClientImpl)Mockito.mock(KieServicesClientImpl.class);
        Mockito.when((Object)this.kieServerIntegration.getServerClient((String)ArgumentMatchers.any())).thenReturn((Object)client);
        ProcessServicesClient processServicesClient = (ProcessServicesClient)Mockito.mock(ProcessServicesClient.class);
        Mockito.when((Object)client.getServicesClient((Class)ArgumentMatchers.any())).thenReturn((Object)processServicesClient);
        ServletOutputStream servletOutputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        Mockito.when((Object)response.getOutputStream()).thenReturn((Object)servletOutputStream);
        ((ServletOutputStream)Mockito.doNothing().when((Object)servletOutputStream)).write((byte[])ArgumentMatchers.any());
        this.servlet.doPost(request, response);
        ((ProcessServicesClient)Mockito.verify((Object)processServicesClient)).startProcess((String)ArgumentMatchers.eq((Object)"1"), (String)ArgumentMatchers.eq((Object)"2"), (CorrelationKey)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)request.getParameter((String)ArgumentMatchers.eq((Object)"correlationKey"))).thenReturn(null);
        this.servlet.doPost(request, response);
        ((ProcessServicesClient)Mockito.verify((Object)processServicesClient)).startProcess((String)ArgumentMatchers.eq((Object)"1"), (String)ArgumentMatchers.eq((Object)"2"), ArgumentMatchers.anyMap());
    }
}

