/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.display.backend.provider.AbstractKieWorkbenchFormsProvider;
import org.jbpm.workbench.forms.display.backend.provider.KieWorkbenchFormsValuesProcessor;
import org.jbpm.workbench.forms.service.providing.RenderingSettings;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.BackendFormRenderingContextManagerImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.FormValuesProcessorImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.fieldProcessors.MultipleSubFormFieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.fieldProcessors.SubFormFieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.ContextModelConstraintsExtractor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.impl.ContextModelConstraintsExtractorImpl;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FormValuesProcessor;
import org.kie.workbench.common.forms.fields.test.TestFieldManager;
import org.kie.workbench.common.forms.fields.test.TestMetaDataEntryManager;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime.BPMNRuntimeFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.impl.DynamicBPMNFormGeneratorImpl;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractFormProvidingEngineTest<SETTINGS extends RenderingSettings, PROCESSOR extends KieWorkbenchFormsValuesProcessor<SETTINGS>, PROVIDER extends AbstractKieWorkbenchFormsProvider> {
    protected static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    @Mock
    protected ContentMarshallerContext marshallerContext;
    protected FormDefinitionSerializer formSerializer;
    protected BackendFormRenderingContextManagerImpl contextManager;
    protected FormValuesProcessor formValuesProcessor;
    protected DynamicBPMNFormGenerator dynamicBPMNFormGenerator;
    protected PROCESSOR processor;
    protected SETTINGS settings;
    protected PROVIDER workbenchFormsProvider;

    @Before
    public void initTest() {
        Mockito.when((Object)this.marshallerContext.getClassloader()).thenReturn((Object)AbstractFormProvidingEngineTest.class.getClassLoader());
        this.formSerializer = new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer(), (MetaDataEntryManager)new TestMetaDataEntryManager());
        List<FieldValueProcessor> processors = Arrays.asList(new SubFormFieldValueProcessor(), new MultipleSubFormFieldValueProcessor());
        Instance fieldValueProcessors = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)fieldValueProcessors.iterator()).then(proc -> processors.iterator());
        this.formValuesProcessor = new FormValuesProcessorImpl(fieldValueProcessors);
        this.dynamicBPMNFormGenerator = new DynamicBPMNFormGeneratorImpl((BPMNFormGeneratorService)new BPMNRuntimeFormGeneratorService((FieldManager)new TestFieldManager(), (MVELEvaluator)new RawMVELEvaluator()));
        this.contextManager = new BackendFormRenderingContextManagerImpl(this.formValuesProcessor, (ContextModelConstraintsExtractor)new ContextModelConstraintsExtractorImpl());
        this.settings = this.generateSettings();
        this.processor = this.getProcessorInstance(this.formSerializer, (BackendFormRenderingContextManager)this.contextManager, this.dynamicBPMNFormGenerator);
        this.initFormsProvider();
    }

    protected abstract void initFormsProvider();

    protected abstract SETTINGS generateSettings();

    protected abstract PROCESSOR getProcessorInstance(FormDefinitionSerializer var1, BackendFormRenderingContextManager var2, DynamicBPMNFormGenerator var3);

    protected abstract Map<String, Object> getFormValues();

    protected abstract void checkRuntimeValues(Map<String, Object> var1);

    @Test
    public void testGenerateRenderingContext() {
        this.generateRenderingSettings();
    }

    protected KieWorkbenchFormRenderingSettings generateRenderingSettings() {
        KieWorkbenchFormRenderingSettings settings = this.processor.generateRenderingContext(this.settings);
        this.checkRenderingSettings(settings);
        return settings;
    }

    protected void checkRenderingSettings(KieWorkbenchFormRenderingSettings settings) {
        TestCase.assertNotNull((String)"Settings cannot be null", (Object)settings);
        BackendFormRenderingContext context = this.contextManager.getContext(settings.getTimestamp());
        TestCase.assertNotNull((String)"There should be a backend context", (Object)context);
        TestCase.assertFalse((boolean)context.getAttributes().isEmpty());
        Assert.assertEquals((int)2, (int)context.getAttributes().size());
        TestCase.assertNotNull(context.getAttributes().get("_rendering_settings"));
        TestCase.assertNotNull(context.getAttributes().get(SERVER_TEMPLATE_ID));
        TestCase.assertFalse((String)"There should exist some forms...", (boolean)settings.getRenderingContext().getAvailableForms().isEmpty());
        TestCase.assertNotNull((String)"A root form should exist", (Object)settings.getRenderingContext().getRootForm());
    }

    @Test
    public void testGenerateRuntimeValuesMap() {
        KieWorkbenchFormRenderingSettings settings = this.generateRenderingSettings();
        Map result = this.processor.generateRuntimeValuesMap(settings.getTimestamp().longValue(), this.getFormValues());
        TestCase.assertNotNull((String)"Result values cannot be null", (Object)result);
        TestCase.assertFalse((String)"Result cannot be empty", (boolean)result.isEmpty());
        this.checkRuntimeValues(result);
    }
}

