/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.display.backend.provider.KieWorkbenchFormsValuesProcessor;
import org.jbpm.workbench.forms.display.backend.provider.model.Invoice;
import org.jbpm.workbench.forms.display.backend.provider.model.InvoiceLine;
import org.jbpm.workbench.forms.service.providing.RenderingSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.BackendFormRenderingContextManagerImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.FormValuesProcessorImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.fieldProcessors.MultipleSubFormFieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.fieldProcessors.SubFormFieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.ContextModelConstraintsExtractor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.impl.ContextModelConstraintsExtractorImpl;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FieldValueProcessor;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.FormValuesProcessor;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.MapModelRenderingContext;
import org.kie.workbench.common.forms.fields.test.TestFieldManager;
import org.kie.workbench.common.forms.fields.test.TestMetaDataEntryManager;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime.BPMNRuntimeFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.impl.DynamicBPMNFormGeneratorImpl;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractFormsValuesProcessorTest<PROCESSOR extends KieWorkbenchFormsValuesProcessor<SETTINGS>, SETTINGS extends RenderingSettings> {
    protected static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String ADDRESS = "address";
    protected static final String PRODUCT = "product";
    protected static final String QUANTITY = "quantity";
    protected static final String PRICE = "price";
    protected static final String TOTAL = "total";
    protected static final String CLIENT = "client";
    protected static final String LINES = "lines";
    protected static final String COMMENTS = "comments";
    protected static final String DATE = "date";
    protected static final String INVOICE = "invoice";
    protected static final int EXPECTED_MODEL_VALIDATIONS = 3;
    protected static final int EXPECTED_FORMS = 4;
    @Mock
    ContentMarshallerContext marshallerContext;
    FormValuesProcessor formValuesProcessor;
    DynamicBPMNFormGenerator dynamicBPMNFormGenerator;
    BackendFormRenderingContextManagerImpl backendFormRenderingContextManager;
    BPMNRuntimeFormGeneratorService runtimeFormGeneratorService;
    KieWorkbenchFormRenderingSettings kieWorkbenchFormRenderingSettings;
    SETTINGS renderingSettings;
    PROCESSOR processor;

    @Before
    public void init() {
        List<FieldValueProcessor> processors = Arrays.asList(new SubFormFieldValueProcessor(), new MultipleSubFormFieldValueProcessor());
        Instance fieldValueProcessors = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)fieldValueProcessors.iterator()).then(proc -> processors.iterator());
        this.formValuesProcessor = new FormValuesProcessorImpl(fieldValueProcessors);
        this.backendFormRenderingContextManager = new BackendFormRenderingContextManagerImpl(this.formValuesProcessor, (ContextModelConstraintsExtractor)new ContextModelConstraintsExtractorImpl());
        this.runtimeFormGeneratorService = new BPMNRuntimeFormGeneratorService((FieldManager)new TestFieldManager(), (MVELEvaluator)new RawMVELEvaluator());
        this.dynamicBPMNFormGenerator = new DynamicBPMNFormGeneratorImpl((BPMNFormGeneratorService)this.runtimeFormGeneratorService);
        this.processor = this.getProcessorInstance((FormDefinitionSerializer)new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer(), (MetaDataEntryManager)new TestMetaDataEntryManager()), (BackendFormRenderingContextManager)this.backendFormRenderingContextManager, this.dynamicBPMNFormGenerator);
        Mockito.when((Object)this.marshallerContext.getClassloader()).thenReturn((Object)this.getClass().getClassLoader());
    }

    @Test
    public void testGenerateRenderingContextWithExistingForms() {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put(INVOICE, Invoice.class.getName());
        this.renderingSettings = this.getFullRenderingSettings();
        this.kieWorkbenchFormRenderingSettings = this.processor.generateRenderingContext(this.renderingSettings);
        this.checkGeneratedContext();
    }

    @Test
    public void testGenerateRenderingContextWithoutForms() {
        this.renderingSettings = this.getRenderingSettingsWithoutForms();
        this.kieWorkbenchFormRenderingSettings = this.processor.generateRenderingContext(this.renderingSettings, true);
        this.checkGeneratedContext();
    }

    protected void checkGeneratedContext() {
        Assert.assertNotNull((Object)this.kieWorkbenchFormRenderingSettings);
        MapModelRenderingContext formRenderingContext = this.kieWorkbenchFormRenderingSettings.getRenderingContext();
        Assert.assertNotNull((Object)formRenderingContext);
        Assert.assertFalse((boolean)formRenderingContext.getModelConstraints().isEmpty());
        Assert.assertEquals((long)3L, (long)formRenderingContext.getModelConstraints().size());
        Assert.assertFalse((boolean)formRenderingContext.getAvailableForms().isEmpty());
        Assert.assertEquals((long)4L, (long)formRenderingContext.getAvailableForms().size());
    }

    @Test
    public void testProcessFormValues() {
        this.testGenerateRenderingContextWithExistingForms();
        Map<String, Object> formValues = this.getFormValues();
        Map outputValues = this.processor.generateRuntimeValuesMap(this.kieWorkbenchFormRenderingSettings.getTimestamp().longValue(), formValues);
        Assert.assertNotNull((Object)outputValues);
        Assert.assertFalse((boolean)outputValues.isEmpty());
        Assert.assertNotNull(outputValues.get(INVOICE));
        Assert.assertTrue((boolean)(outputValues.get(INVOICE) instanceof Invoice));
        Invoice invoice = (Invoice)outputValues.get(INVOICE);
        Map invoiceMap = (Map)formValues.get(INVOICE);
        Map clientMap = (Map)invoiceMap.get(CLIENT);
        Assert.assertNotNull((Object)invoice.getClient());
        Assert.assertEquals(clientMap.get(ID), (Object)invoice.getClient().getId());
        Assert.assertEquals(clientMap.get(NAME), (Object)invoice.getClient().getName());
        Assert.assertEquals(clientMap.get(ADDRESS), (Object)invoice.getClient().getAddress());
        List linesMap = (List)invoiceMap.get(LINES);
        Assert.assertNotNull(invoice.getLines());
        Assert.assertEquals((long)linesMap.size(), (long)invoice.getLines().size());
        Map lineMap = (Map)linesMap.get(0);
        InvoiceLine line = invoice.getLines().get(0);
        Assert.assertEquals(lineMap.get(PRODUCT), (Object)line.getProduct());
        Assert.assertEquals(lineMap.get(QUANTITY), (Object)line.getQuantity());
        Assert.assertEquals(lineMap.get(PRICE), (Object)line.getPrice());
        Assert.assertEquals(lineMap.get(TOTAL), (Object)line.getTotal());
        Assert.assertEquals(invoiceMap.get(COMMENTS), (Object)invoice.getComments());
        Assert.assertEquals(invoiceMap.get(TOTAL), (Object)invoice.getTotal());
        Assert.assertEquals(invoiceMap.get(DATE), (Object)invoice.getDate());
    }

    protected Map<String, Object> getFormValues() {
        HashMap<String, Object> formValues = new HashMap<String, Object>();
        HashMap<String, Object> clientMap = new HashMap<String, Object>();
        clientMap.put(ID, new Long(1234L));
        clientMap.put(NAME, "John Snow");
        clientMap.put(ADDRESS, "Winterfell");
        ArrayList linesMap = new ArrayList();
        HashMap<String, Object> lineMap = new HashMap<String, Object>();
        lineMap.put(PRODUCT, "Really Dangerous Sword");
        lineMap.put(QUANTITY, 1);
        lineMap.put(PRICE, 100.5);
        lineMap.put(TOTAL, 100.5);
        linesMap.add(lineMap);
        HashMap<String, Object> invoiceMap = new HashMap<String, Object>();
        invoiceMap.put(CLIENT, clientMap);
        invoiceMap.put(LINES, linesMap);
        invoiceMap.put(TOTAL, 100.5);
        invoiceMap.put(COMMENTS, "Everything was perfect");
        invoiceMap.put(DATE, new Date());
        formValues.put(INVOICE, invoiceMap);
        return formValues;
    }

    abstract SETTINGS getFullRenderingSettings();

    abstract SETTINGS getRenderingSettingsWithoutForms();

    abstract PROCESSOR getProcessorInstance(FormDefinitionSerializer var1, BackendFormRenderingContextManager var2, DynamicBPMNFormGenerator var3);
}

