/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.providers;

import com.google.gwt.core.client.GWT;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayProvider;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayer;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.i18n.Constants;
import org.jbpm.workbench.forms.display.FormRenderingSettings;
import org.jbpm.workbench.forms.display.api.HumanTaskDisplayerConfig;
import org.jbpm.workbench.forms.service.shared.FormServiceEntryPoint;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class HumanTaskFormDisplayProviderImpl
implements HumanTaskFormDisplayProvider {
    protected Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private Caller<FormServiceEntryPoint> formServices;
    @Inject
    protected SyncBeanManager iocManager;
    private Map<Class<? extends FormRenderingSettings>, HumanTaskFormDisplayer> taskDisplayers = new HashMap<Class<? extends FormRenderingSettings>, HumanTaskFormDisplayer>();

    @PostConstruct
    public void init() {
        this.taskDisplayers.clear();
        Collection taskDisplayersBeans = this.iocManager.lookupBeans(HumanTaskFormDisplayer.class);
        if (taskDisplayersBeans != null) {
            for (SyncBeanDef displayerDef : taskDisplayersBeans) {
                HumanTaskFormDisplayer displayer = (HumanTaskFormDisplayer)displayerDef.getInstance();
                this.taskDisplayers.put(displayer.getSupportedRenderingSettings(), displayer);
            }
        }
    }

    @Override
    public void setup(HumanTaskDisplayerConfig config, FormDisplayerView view) {
        this.display(config, view);
    }

    protected void display(final HumanTaskDisplayerConfig config, final FormDisplayerView view) {
        if (this.taskDisplayers != null) {
            ((FormServiceEntryPoint)this.formServices.call((RemoteCallback)new RemoteCallback<FormRenderingSettings>(){

                public void callback(FormRenderingSettings settings) {
                    if (settings == null) {
                        ErrorPopup.showMessage((String)HumanTaskFormDisplayProviderImpl.this.constants.UnableToFindFormForTask(config.getKey().getTaskId()));
                    } else {
                        HumanTaskFormDisplayer displayer = (HumanTaskFormDisplayer)HumanTaskFormDisplayProviderImpl.this.taskDisplayers.get(settings.getClass());
                        if (displayer != null) {
                            config.setRenderingSettings(settings);
                            displayer.init(config, view.getOnCloseCommand(), new Command(){

                                public void execute() {
                                    HumanTaskFormDisplayProviderImpl.this.display(config, view);
                                }
                            }, view.getResizeListener());
                            view.display(displayer);
                        }
                    }
                }
            })).getFormDisplayTask(config.getKey().getServerTemplateId(), config.getKey().getDeploymentId(), config.getKey().getTaskId().longValue());
        }
    }
}

