/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.HideEvent;
import org.gwtbootstrap3.client.shared.event.HideHandler;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.Panel;
import org.gwtbootstrap3.client.ui.PanelBody;
import org.gwtbootstrap3.client.ui.PanelCollapse;
import org.gwtbootstrap3.client.ui.PanelGroup;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.forms.client.display.api.StartProcessFormDisplayer;
import org.jbpm.workbench.forms.client.i18n.Constants;
import org.jbpm.workbench.forms.display.FormDisplayerConfig;
import org.jbpm.workbench.forms.display.FormRenderingSettings;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractStartProcessFormDisplayer<S extends FormRenderingSettings>
implements StartProcessFormDisplayer<S> {
    public static final String ACTION_START_PROCESS = "startProcess";
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected FormPanel container = (FormPanel)GWT.create(FormPanel.class);
    protected FlowPanel formContainer = (FlowPanel)GWT.create(FlowPanel.class);
    protected FlowPanel footerButtons = (FlowPanel)GWT.create(FlowPanel.class);
    protected TextBox correlationKey = (TextBox)GWT.create(TextBox.class);
    protected S renderingSettings;
    protected String serverTemplateId;
    protected String deploymentId;
    protected String processDefId;
    protected String processName;
    protected Long parentProcessInstanceId;
    @Inject
    protected ErrorPopupPresenter errorPopup;
    @Inject
    protected Event<NewProcessInstanceEvent> newProcessInstanceEvent;
    protected Caller<ProcessService> processService;
    @Inject
    protected Event<NotificationEvent> notificationEvent;
    protected FormDisplayerConfig<ProcessDefinitionKey, S> config;
    private Command onClose;
    private Command onRefresh;

    @PostConstruct
    protected void init() {
        this.container.getElement().setId("form-data");
    }

    @Override
    public void init(FormDisplayerConfig<ProcessDefinitionKey, S> config, Command onClose, Command onRefreshCommand) {
        this.config = config;
        this.serverTemplateId = ((ProcessDefinitionKey)config.getKey()).getServerTemplateId();
        this.deploymentId = ((ProcessDefinitionKey)config.getKey()).getDeploymentId();
        this.processDefId = ((ProcessDefinitionKey)config.getKey()).getProcessId();
        this.renderingSettings = config.getRenderingSettings();
        this.onClose = onClose;
        this.onRefresh = onRefreshCommand;
        this.container.clear();
        this.formContainer.clear();
        this.footerButtons.clear();
        this.container.add((Widget)this.formContainer);
        this.correlationKey = new TextBox();
        Button startButton = new Button(this.constants.Submit(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                AbstractStartProcessFormDisplayer.this.startProcessFromDisplayer();
            }
        });
        startButton.setType(ButtonType.PRIMARY);
        this.footerButtons.add((Widget)startButton);
        this.processName = ((ProcessDefinitionKey)config.getKey()).getProcessDefName();
        FocusPanel wrapperFlowPanel = new FocusPanel();
        wrapperFlowPanel.setStyleName("wrapper form-actions");
        this.initDisplayer();
        final PanelGroup accordion = new PanelGroup();
        accordion.setId(DOM.createUniqueId());
        accordion.add((Widget)new Panel(){
            {
                final PanelCollapse collapse = new PanelCollapse(){
                    {
                        this.setIn(false);
                        this.addHideHandler(new HideHandler(){

                            public void onHide(HideEvent hideEvent) {
                                hideEvent.stopPropagation();
                            }
                        });
                        this.add((Widget)new PanelBody(){
                            {
                                this.add((Widget)AbstractStartProcessFormDisplayer.this.correlationKey);
                            }
                        });
                    }
                };
                this.add((Widget)new PanelHeader(){
                    {
                        this.add((Widget)new Heading(HeadingSize.H4){
                            {
                                this.add((Widget)new Anchor(){
                                    {
                                        this.setText(AbstractStartProcessFormDisplayer.this.constants.Correlation_Key());
                                        this.setDataToggle(Toggle.COLLAPSE);
                                        this.setDataParent(accordion.getId());
                                        this.setDataTargetWidget((Widget)collapse);
                                    }
                                });
                            }
                        });
                    }
                });
                this.add((Widget)collapse);
            }
        });
        accordion.add((Widget)new Panel(){
            {
                final PanelCollapse collapse = new PanelCollapse(){
                    {
                        this.setIn(true);
                        this.addHideHandler(new HideHandler(){

                            public void onHide(HideEvent hideEvent) {
                                hideEvent.stopPropagation();
                            }
                        });
                        this.add((Widget)new PanelBody(){
                            {
                                this.add(AbstractStartProcessFormDisplayer.this.getFormWidget());
                            }
                        });
                    }
                };
                this.add((Widget)new PanelHeader(){
                    {
                        this.add((Widget)new Heading(HeadingSize.H4){
                            {
                                this.add((Widget)new Anchor(){
                                    {
                                        this.setText(AbstractStartProcessFormDisplayer.this.constants.Form());
                                        this.setDataToggle(Toggle.COLLAPSE);
                                        this.setDataParent(accordion.getId());
                                        this.setDataTargetWidget((Widget)collapse);
                                    }
                                });
                            }
                        });
                    }
                });
                this.add((Widget)collapse);
            }
        });
        this.formContainer.add((Widget)accordion);
    }

    protected abstract void initDisplayer();

    protected ErrorCallback<Message> getUnexpectedErrorCallback() {
        return new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                String notification = Constants.INSTANCE.UnexpectedError(throwable.getMessage());
                AbstractStartProcessFormDisplayer.this.errorPopup.showMessage(notification);
                return true;
            }
        };
    }

    @Override
    public com.google.gwt.user.client.ui.Panel getContainer() {
        return this.container;
    }

    @Override
    public IsWidget getFooter() {
        return this.footerButtons;
    }

    @Override
    public void startProcess(Map<String, Object> params) {
        ((ProcessService)this.processService.call(this.getStartProcessRemoteCallback(), this.getUnexpectedErrorCallback())).startProcess(this.serverTemplateId, this.deploymentId, this.processDefId, this.correlationKey.getValue(), params);
    }

    protected RemoteCallback<Long> getStartProcessRemoteCallback() {
        return new RemoteCallback<Long>(){

            public void callback(Long processInstanceId) {
                AbstractStartProcessFormDisplayer.this.newProcessInstanceEvent.fire((Object)new NewProcessInstanceEvent(AbstractStartProcessFormDisplayer.this.serverTemplateId, AbstractStartProcessFormDisplayer.this.deploymentId, processInstanceId, AbstractStartProcessFormDisplayer.this.processDefId, AbstractStartProcessFormDisplayer.this.processName, Integer.valueOf(1)));
                String message = Constants.INSTANCE.ProcessStarted(processInstanceId);
                AbstractStartProcessFormDisplayer.this.notificationEvent.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.SUCCESS));
                AbstractStartProcessFormDisplayer.this.close();
            }
        };
    }

    @Override
    public void addOnCloseCallback(Command callback) {
        this.onClose = callback;
    }

    @Override
    public void addOnRefreshCallback(Command callback) {
        this.onRefresh = callback;
    }

    public void refresh() {
        if (this.onRefresh != null) {
            this.onRefresh.execute();
        }
    }

    @Override
    public void close() {
        if (this.onClose != null) {
            this.onClose.execute();
        }
        this.clearStatus();
    }

    protected void clearStatus() {
        this.renderingSettings = null;
        this.deploymentId = null;
        this.processDefId = null;
        this.processName = null;
        this.container.clear();
        this.formContainer.clear();
        this.footerButtons.clear();
        this.onClose = null;
        this.onRefresh = null;
    }

    protected String getCorrelationKey() {
        return this.correlationKey.getText();
    }

    public Long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(Long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }
}

