/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.standalone;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.workbench.forms.client.display.api.StartProcessFormDisplayProvider;
import org.jbpm.workbench.forms.client.display.standalone.StandaloneProcessFormDisplayScreen;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.display.EmbeddedFormDisplayer;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class StandaloneProcessFormDisplayScreenTest {
    private static final String SERVER_TEMPLATE_ID = "test-kie-server";
    private static final String DOMAIN_ID = "test_1.0.0";
    private static final String PROCESS_ID = "test.test";
    @Mock
    private PlaceManager placeManager;
    @Mock
    private EmbeddedFormDisplayer displayer;
    @Mock
    private StartProcessFormDisplayProvider processFormDisplayProvider;
    private StandaloneProcessFormDisplayScreen screen;

    @Before
    public void init() {
        this.screen = new StandaloneProcessFormDisplayScreen(this.placeManager, this.displayer, this.processFormDisplayProvider);
    }

    @Test
    public void testBasicFunctions() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.screen.getTitle()).isNotNull()).isEmpty();
        ((ObjectAssert)Assertions.assertThat((Object)this.screen.getView()).isNotNull()).isEqualTo((Object)this.displayer);
    }

    @Test
    public void testOnOpen() {
        DefaultPlaceRequest place = new DefaultPlaceRequest();
        place.addParameter("serverTemplateId", SERVER_TEMPLATE_ID);
        place.addParameter("domainId", DOMAIN_ID);
        place.addParameter("processId", PROCESS_ID);
        this.screen.onStartup((PlaceRequest)place);
        this.screen.onOpen();
        ArgumentCaptor configArgumentCaptor = ArgumentCaptor.forClass(ProcessDisplayerConfig.class);
        ((StartProcessFormDisplayProvider)Mockito.verify((Object)this.processFormDisplayProvider)).setup((ProcessDisplayerConfig)configArgumentCaptor.capture(), (FormDisplayerView)Matchers.any());
        ProcessDisplayerConfig config = (ProcessDisplayerConfig)configArgumentCaptor.getValue();
        Assertions.assertThat((Object)config).isNotNull();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config.getKey()).isNotNull()).hasFieldOrPropertyWithValue("serverTemplateId", (Object)SERVER_TEMPLATE_ID)).hasFieldOrPropertyWithValue("deploymentId", (Object)DOMAIN_ID)).hasFieldOrPropertyWithValue("processId", (Object)PROCESS_ID);
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((EmbeddedFormDisplayer)Mockito.verify((Object)this.displayer)).setOnCloseCommand((Command)commandArgumentCaptor.capture());
        Command command = (Command)commandArgumentCaptor.getValue();
        Assertions.assertThat((Object)command).isNotNull();
        command.execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((PlaceRequest)place);
    }
}

