/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.process;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.extras.select.client.ui.OptGroup;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.forms.client.display.GenericFormDisplayer;
import org.jbpm.workbench.forms.client.display.process.AbstractStartProcessFormDisplayer;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.i18n.Constants;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class QuickNewProcessInstancePopup
extends BaseModal
implements FormDisplayerView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    public FlowPanel processForm;
    @UiField
    public FlowPanel basicForm;
    @UiField
    public HelpBlock errorMessages;
    @UiField
    public FormGroup errorMessagesGroup;
    @UiField
    public FormGroup processDefinitionsControlGroup;
    @UiField
    public Select processDefinitionsListBox;
    @UiField
    public HelpBlock processDefinitionsHelpLabel;
    @UiField
    public FlowPanel body;
    @Inject
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    User identity;
    GenericModalFooter footer = (GenericModalFooter)GWT.create(GenericModalFooter.class);
    @Inject
    private Event<NotificationEvent> notification;
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;
    private Long parentProcessInstanceId = -1L;
    private Command onCloseCommand;
    private boolean initialized = false;
    private GenericFormDisplayer currentDisplayer;
    private String serverTemplateId;
    private String deploymentId;
    private String processId;

    public QuickNewProcessInstancePopup() {
        this.setTitle(Constants.INSTANCE.Start_process_instance());
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.setSize(ModalSize.LARGE);
    }

    public void show(Long parentProcessInstanceId) {
        this.show();
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public void show(String serverTemplateId) {
        this.init();
        this.loadFormValues(serverTemplateId);
        this.processForm.setVisible(false);
        this.basicForm.setVisible(true);
        super.show();
    }

    private void okButton() {
        if (this.validateForm()) {
            this.createNewProcessInstance();
        }
    }

    protected void loadFormValues(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
        this.processDefinitionsListBox.clear();
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call(processSummaries -> {
            Map<String, List<ProcessSummary>> defs = processSummaries.stream().filter(p -> !p.isDynamic()).collect(Collectors.groupingBy(ProcessSummary::getDeploymentId));
            defs.keySet().stream().sorted().forEach(deploymentId -> {
                OptGroup group = (OptGroup)GWT.create(OptGroup.class);
                group.setLabel(deploymentId);
                ((List)defs.get(deploymentId)).stream().sorted().forEach(p -> {
                    Option option = (Option)GWT.create(Option.class);
                    option.setText(p.getProcessDefId());
                    option.setValue(p.getProcessDefId());
                    group.add((Widget)option);
                });
                this.processDefinitionsListBox.add((Widget)group);
            });
            Scheduler.get().scheduleDeferred(() -> this.processDefinitionsListBox.refresh());
        })).getProcesses(serverTemplateId, Integer.valueOf(0), Integer.valueOf(1000), "", Boolean.valueOf(true));
    }

    protected boolean validateForm() {
        if (this.processDefinitionsListBox.getSelectedItem() == null) {
            this.errorMessages.setText(Constants.INSTANCE.Select_Process());
            this.errorMessagesGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.clearErrorMessages();
        return true;
    }

    public void displayNotification(String text) {
        this.notification.fire((Object)new NotificationEvent(text));
    }

    protected void createNewProcessInstance() {
        Option selectedItem = this.processDefinitionsListBox.getSelectedItem();
        this.deploymentId = ((OptGroup)selectedItem.getParent()).getLabel();
        this.processId = selectedItem.getValue();
        this.processForm.setVisible(true);
        this.basicForm.setVisible(false);
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.serverTemplateId, this.deploymentId, this.processId), this.processId);
        this.startProcessDisplayProvider.setup(config, this);
    }

    private void clearErrorMessages() {
        this.errorMessages.setText("");
    }

    protected void init() {
        this.removeFooter((ComplexPanel)this);
        this.footer = new GenericModalFooter();
        this.footer.addButton(Constants.INSTANCE.Start(), new Command(){

            public void execute() {
                QuickNewProcessInstancePopup.this.okButton();
            }
        }, IconType.PLUS, ButtonType.PRIMARY);
        this.add((Widget)this.footer);
        this.onCloseCommand = new Command(){

            public void execute() {
                QuickNewProcessInstancePopup.this.closePopup();
            }
        };
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (QuickNewProcessInstancePopup.this.initialized) {
                    QuickNewProcessInstancePopup.this.closePopup();
                }
            }
        });
    }

    public void display(GenericFormDisplayer displayer) {
        this.currentDisplayer = displayer;
        this.body.clear();
        this.body.add((Widget)displayer.getContainer());
        ((AbstractStartProcessFormDisplayer)displayer).setParentProcessInstanceId(this.parentProcessInstanceId);
        this.removeFooter((ComplexPanel)this);
        this.footer = new GenericModalFooter();
        if (displayer.getOpener() == null) {
            this.footer.add(displayer.getFooter());
        }
        this.add((Widget)this.footer);
        this.initialized = true;
    }

    public void closePopup() {
        this.initialized = false;
        this.hide();
        super.hide();
    }

    private void removeFooter(ComplexPanel panel) {
        for (Widget widget : panel) {
            if (widget instanceof ModalFooter) {
                widget.removeFromParent();
                break;
            }
            if (!(widget instanceof ComplexPanel)) continue;
            this.removeFooter((ComplexPanel)widget);
        }
    }

    @Override
    public Command getOnCloseCommand() {
        return this.onCloseCommand;
    }

    @Override
    public void setOnCloseCommand(Command onCloseCommand) {
        this.onCloseCommand = onCloseCommand;
    }

    @Override
    public GenericFormDisplayer getCurrentDisplayer() {
        return this.currentDisplayer;
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    static interface Binder
    extends UiBinder<Widget, QuickNewProcessInstancePopup> {
    }
}

