/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.process;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Arrays;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.html.Text;
import org.gwtbootstrap3.extras.select.client.ui.OptGroup;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jbpm.workbench.forms.client.display.process.QuickNewProcessInstancePopup;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.i18n.Constants;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class QuickNewProcessInstancePopupTest {
    @Mock
    public Select processDefinitionsListBox;
    @Mock
    public HelpBlock errorMessages;
    @Mock
    public FormGroup errorMessagesGroup;
    @Mock
    protected StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Mock
    private CallerMock<ProcessRuntimeDataService> processRuntimeDataService;
    @Mock
    private ProcessRuntimeDataService processRuntimeDataServiceMock;
    @Mock
    public FlowPanel body;
    @InjectMocks
    private QuickNewProcessInstancePopup quickNewProcessInstancePopup;

    @Before
    public void setupMocks() {
        this.processRuntimeDataService = new CallerMock((Object)this.processRuntimeDataServiceMock);
        this.quickNewProcessInstancePopup.setProcessRuntimeDataService(this.processRuntimeDataService);
    }

    @Test
    public void loadFormValuesTest() {
        String serverTemplateId = "serverTemplateId";
        String deploymentId = "def_deploymentId";
        String processDefinitionId = "def_Id";
        ProcessSummary processSummary = new ProcessSummary(processDefinitionId, "def_name", deploymentId, "1.0", false);
        Mockito.when((Object)this.processRuntimeDataServiceMock.getProcesses(serverTemplateId, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), "ProcessName", Boolean.valueOf(true))).thenReturn(Arrays.asList(processSummary));
        this.quickNewProcessInstancePopup.loadFormValues(serverTemplateId);
        ((Select)Mockito.verify((Object)this.processDefinitionsListBox)).clear();
        ((ProcessRuntimeDataService)Mockito.verify((Object)this.processRuntimeDataServiceMock)).getProcesses((String)Mockito.eq((Object)serverTemplateId), Integer.valueOf(Mockito.eq((int)0)), Integer.valueOf(Mockito.eq((int)Integer.MAX_VALUE)), (String)Mockito.eq((Object)"ProcessName"), Boolean.valueOf(Mockito.eq((boolean)true)));
        ArgumentCaptor captor = ArgumentCaptor.forClass(OptGroup.class);
        ((Select)Mockito.verify((Object)this.processDefinitionsListBox)).add((Widget)captor.capture());
        ((OptGroup)Mockito.verify((Object)((OptGroup)captor.getValue()))).setLabel(deploymentId);
        ArgumentCaptor captorOption = ArgumentCaptor.forClass(Option.class);
        ((OptGroup)Mockito.verify((Object)((OptGroup)captor.getValue()))).add((Widget)captorOption.capture());
        ((Option)Mockito.verify((Object)((Option)captorOption.getValue()))).setValue(processDefinitionId);
        ((Option)Mockito.verify((Object)((Option)captorOption.getValue()))).setText(processDefinitionId);
    }

    @Test
    public void validateFormTest() {
        Mockito.when((Object)this.processDefinitionsListBox.getSelectedItem()).thenReturn(null);
        boolean valid = this.quickNewProcessInstancePopup.validateForm();
        Assert.assertFalse((boolean)valid);
        ((HelpBlock)Mockito.verify((Object)this.errorMessages)).setText(Constants.INSTANCE.Select_Process());
        ((FormGroup)Mockito.verify((Object)this.errorMessagesGroup)).setValidationState(ValidationState.ERROR);
        Mockito.when((Object)this.processDefinitionsListBox.getSelectedItem()).thenReturn((Object)((Option)Mockito.mock(Option.class)));
        valid = this.quickNewProcessInstancePopup.validateForm();
        Assert.assertTrue((boolean)valid);
        ((HelpBlock)Mockito.verify((Object)this.errorMessages)).setText("");
    }

    @Test
    public void createNewProcessInstance() {
        String deploymentId = "def_deploymentId";
        String processDefinitionId = "def_Id";
        OptGroup group = (OptGroup)Mockito.mock(OptGroup.class);
        Option option = (Option)Mockito.mock(Option.class);
        Mockito.when((Object)option.getParent()).thenReturn((Object)group);
        Mockito.when((Object)group.getLabel()).thenReturn((Object)deploymentId);
        Mockito.when((Object)option.getValue()).thenReturn((Object)processDefinitionId);
        Mockito.when((Object)this.processDefinitionsListBox.getSelectedItem()).thenReturn((Object)option);
        this.quickNewProcessInstancePopup.createNewProcessInstance();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ProcessDisplayerConfig.class);
        ((StartProcessFormDisplayProviderImpl)Mockito.verify((Object)this.startProcessDisplayProvider)).setup((ProcessDisplayerConfig)captor.capture(), (FormDisplayerView)Mockito.eq((Object)this.quickNewProcessInstancePopup));
        Assert.assertEquals((Object)processDefinitionId, (Object)((ProcessDisplayerConfig)captor.getValue()).getKey().getProcessDefName());
        Assert.assertEquals((Object)deploymentId, (Object)((ProcessDisplayerConfig)captor.getValue()).getKey().getDeploymentId());
    }

    @Test
    public void testClosePopup() {
        this.quickNewProcessInstancePopup.setFlowPanelBody(this.body);
        this.quickNewProcessInstancePopup.closePopup();
        ((FlowPanel)Mockito.verify((Object)this.body)).clear();
    }
}

