/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.modeler.backend.server.provider;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.kie.services.FormRenderContentMarshallerManager;
import org.jbpm.workbench.forms.modeler.display.impl.FormModelerFormRenderingSettings;
import org.jbpm.workbench.forms.service.providing.FormProvider;
import org.jbpm.workbench.forms.service.providing.ProcessRenderingSettings;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;
import org.jbpm.workbench.forms.service.providing.model.ProcessDefinition;
import org.jbpm.workbench.forms.service.providing.model.TaskDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class FormModelerFormProvider
implements FormProvider<FormModelerFormRenderingSettings> {
    protected Logger log = LoggerFactory.getLogger(FormModelerFormProvider.class);
    private FormSerializationManager formSerializationManager;
    private FormRenderContextManager formRenderContextManager;
    private FormRenderContentMarshallerManager formRenderContentMarshaller;

    @Inject
    public FormModelerFormProvider(FormSerializationManager formSerializationManager, FormRenderContextManager formRenderContextManager, FormRenderContentMarshallerManager formRenderContentMarshaller) {
        this.formSerializationManager = formSerializationManager;
        this.formRenderContextManager = formRenderContextManager;
        this.formRenderContentMarshaller = formRenderContentMarshaller;
    }

    public FormModelerFormRenderingSettings render(ProcessRenderingSettings settings) {
        if (!StringUtils.isEmpty((CharSequence)settings.getFormContent())) {
            try {
                Form form = this.formSerializationManager.loadFormFromXML(settings.getFormContent());
                HashMap<String, ProcessDefinition> ctx = new HashMap<String, ProcessDefinition>();
                ctx.put("process", settings.getProcess());
                FormRenderContext context = this.formRenderContextManager.newContext(form, settings.getServerTemplateId(), ctx, new HashMap());
                this.formRenderContentMarshaller.addContentMarshaller(context.getUID(), settings.getMarshallerContext());
                return new FormModelerFormRenderingSettings(context.getUID());
            }
            catch (Exception e) {
                this.log.warn("Error rendering form: ", (Throwable)e);
            }
        }
        return null;
    }

    public FormModelerFormRenderingSettings render(TaskRenderingSettings settings) {
        if (!StringUtils.isEmpty((CharSequence)settings.getFormContent())) {
            try {
                TaskDefinition task = settings.getTask();
                Form form = this.formSerializationManager.loadFormFromXML(settings.getFormContent());
                HashMap<String, TaskDefinition> inputs = new HashMap<String, TaskDefinition>();
                HashMap outputs = !task.isOutputIncluded() ? new HashMap() : settings.getOutputs();
                Map m = settings.getInputs();
                if (m != null) {
                    inputs.putAll(m);
                }
                inputs.put("task", task);
                FormRenderContext context = this.formRenderContextManager.newContext(form, settings.getServerTemplateId(), inputs, outputs);
                this.formRenderContentMarshaller.addContentMarshaller(context.getUID(), settings.getMarshallerContext());
                String status = task.getStatus();
                boolean readonly = !"InProgress".equals(status);
                context.setReadonly(readonly);
                return new FormModelerFormRenderingSettings(context.getUID());
            }
            catch (Exception e) {
                this.log.warn("Error rendering form: ", (Throwable)e);
            }
        }
        return null;
    }

    public int getPriority() {
        return 2;
    }
}

