/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.ht.backend.server.TaskAssignmentSummaryMapper;
import org.jbpm.workbench.ht.backend.server.TaskSummaryMapper;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.ks.integration.AbstractKieServerService;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.model.definition.TaskField;
import org.kie.server.api.model.definition.TaskQueryFilterSpec;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.util.TaskQueryFilterSpecBuilder;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.UserTaskServicesClient;

@Service
@ApplicationScoped
public class RemoteTaskServiceImpl
extends AbstractKieServerService
implements TaskService {
    public static int NOT_FOUND_ERROR_CODE = 404;
    @Inject
    private IdentityProvider identityProvider;

    public TaskSummary getTask(String serverTemplateId, String containerId, Long taskId) {
        TaskQueryFilterSpec filterSpec;
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        QueryServicesClient queryServicesClient = (QueryServicesClient)this.getClient(serverTemplateId, QueryServicesClient.class);
        List tasks = queryServicesClient.findHumanTasksWithFilters("jbpmHumanTasks", filterSpec = new TaskQueryFilterSpecBuilder().equalsTo(TaskField.TASKID, new Comparable[]{taskId}).get(), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        if (tasks != null && tasks.size() == 1) {
            return new TaskSummaryMapper().apply((TaskInstance)tasks.get(0));
        }
        return null;
    }

    public void updateTask(String serverTemplateId, String containerId, Long taskId, Integer priority, String description, Date dueDate) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.setTaskDescription(containerId, taskId, description);
        client.setTaskPriority(containerId, taskId, priority.intValue());
        client.setTaskExpirationDate(containerId, taskId, dueDate);
    }

    public void claimTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.claimTask(containerId, taskId, this.identityProvider.getName());
    }

    public void releaseTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.releaseTask(containerId, taskId, this.identityProvider.getName());
    }

    public void startTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.startTask(containerId, taskId, this.identityProvider.getName());
    }

    public void completeTask(String serverTemplateId, String containerId, Long taskId, Map<String, Object> output) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.completeTask(containerId, taskId, this.identityProvider.getName(), output);
    }

    public void resumeTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.resumeTask(containerId, taskId, this.identityProvider.getName());
    }

    public void suspendTask(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.suspendTask(containerId, taskId, this.identityProvider.getName());
    }

    public void saveTaskContent(String serverTemplateId, String containerId, Long taskId, Map<String, Object> output) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.saveTaskContent(containerId, taskId, output);
    }

    public void addTaskComment(String serverTemplateId, String containerId, Long taskId, String text, Date addedOn) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.addTaskComment(containerId, taskId, text, this.identityProvider.getName(), addedOn);
    }

    public void deleteTaskComment(String serverTemplateId, String containerId, Long taskId, Long commentId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.deleteTaskComment(containerId, taskId, commentId);
    }

    public List<CommentSummary> getTaskComments(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        try {
            List comments = client.getTaskCommentsByTaskId(containerId, taskId);
            return comments.stream().map(c -> this.build((TaskComment)c)).collect(Collectors.toList());
        }
        catch (KieServicesHttpException kieException) {
            if (kieException.getHttpCode() == NOT_FOUND_ERROR_CODE) {
                return Collections.emptyList();
            }
            throw kieException;
        }
    }

    public List<TaskEventSummary> getTaskEvents(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return Collections.emptyList();
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        List events = client.findTaskEvents(containerId, taskId, Integer.valueOf(0), Integer.valueOf(1000));
        return events.stream().map(e -> this.build((TaskEventInstance)e)).collect(Collectors.toList());
    }

    public void delegate(String serverTemplateId, String containerId, Long taskId, String entity) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.delegateTask(containerId, taskId, this.identityProvider.getName(), entity);
    }

    public void forward(String serverTemplateId, String containerId, Long taskId, String entity) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        client.forwardTask(containerId, taskId, this.identityProvider.getName(), entity);
    }

    public TaskAssignmentSummary getTaskAssignmentDetails(String serverTemplateId, String containerId, Long taskId) {
        if (serverTemplateId == null || serverTemplateId.isEmpty()) {
            return null;
        }
        UserTaskServicesClient client = (UserTaskServicesClient)this.getClient(serverTemplateId, UserTaskServicesClient.class);
        try {
            TaskInstance task = client.getTaskInstance(containerId, taskId, false, false, true);
            return new TaskAssignmentSummaryMapper().apply(task, this.identityProvider);
        }
        catch (KieServicesHttpException kieException) {
            if (kieException.getHttpCode() == NOT_FOUND_ERROR_CODE) {
                return null;
            }
            throw kieException;
        }
    }

    public void executeReminderForTask(String serverTemplateId, String containerId, Long taskId, String fromUser) {
    }

    protected CommentSummary build(TaskComment comment) {
        CommentSummary summary = new CommentSummary(comment.getId().longValue(), comment.getText(), comment.getAddedBy(), comment.getAddedAt());
        return summary;
    }

    protected TaskEventSummary build(TaskEventInstance event) {
        TaskEventSummary summary = new TaskEventSummary(event.getId(), event.getTaskId(), event.getType(), event.getUserId(), event.getWorkItemId(), event.getLogTime(), event.getMessage());
        return summary;
    }
}

