/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ht.backend.server.RemoteTaskServiceImpl;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.ht.model.TaskKey;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class RemoteTaskServiceImplTest {
    private static final String CURRENT_USER = "Jan";
    @Mock
    IdentityProvider identityProvider;
    @Mock
    KieServerIntegration kieServerIntegration;
    @Mock
    KieServicesClient kieServicesClient;
    @Mock
    UserTaskServicesClient userTaskServicesClient;
    @Mock
    Event<TaskCompletedEvent> taskCompletedEvent;
    @InjectMocks
    RemoteTaskServiceImpl remoteTaskService;

    @Before
    public void initMocks() {
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)CURRENT_USER);
        Mockito.when((Object)this.kieServerIntegration.getServerClient(Mockito.anyString())).thenReturn((Object)this.kieServicesClient);
        Mockito.when((Object)this.kieServicesClient.getServicesClient(UserTaskServicesClient.class)).thenReturn((Object)this.userTaskServicesClient);
    }

    @Test
    public void testBuildTaskEventSummary() {
        TaskEventInstance event = TaskEventInstance.builder().id(Long.valueOf(1L)).taskId(Long.valueOf(2L)).type("UPDATED").user("admin").date(new Date()).workItemId(Long.valueOf(3L)).message("message").build();
        TaskEventSummary summary = this.remoteTaskService.build(event);
        Assert.assertNotNull((Object)summary);
        Assert.assertEquals((Object)event.getId(), (Object)summary.getEventId());
        Assert.assertEquals((Object)event.getTaskId(), (Object)summary.getTaskId());
        Assert.assertEquals((Object)event.getType(), (Object)summary.getType());
        Assert.assertEquals((Object)event.getUserId(), (Object)summary.getUserId());
        Assert.assertEquals((Object)event.getLogTime(), (Object)summary.getLogTime());
        Assert.assertEquals((Object)event.getWorkItemId(), (Object)summary.getWorkItemId());
        Assert.assertEquals((Object)event.getMessage(), (Object)summary.getMessage());
    }

    @Test
    public void testInvalidServerTemplate() throws Exception {
        Method[] methods;
        for (Method method : methods = TaskService.class.getMethods()) {
            Class<?> returnType = method.getReturnType();
            Object[] args = new Object[method.getParameterCount()];
            Object result = method.invoke((Object)this.remoteTaskService, args);
            this.assertMethodResult(method, returnType, result);
            args[0] = "";
            result = method.invoke((Object)this.remoteTaskService, args);
            this.assertMethodResult(method, returnType, result);
        }
    }

    private void assertMethodResult(Method method, Class<?> returnType, Object result) {
        if (Collection.class.isAssignableFrom(returnType)) {
            Assert.assertNotNull((String)String.format("Returned collection for method %s should not be null", method.getName()), (Object)result);
            Assert.assertTrue((String)String.format("Returned collection for method %s should be empty", method.getName()), (boolean)((Collection)result).isEmpty());
        } else {
            Assert.assertNull((String)String.format("Returned object for method %s should be null", method.getName()), (Object)result);
        }
    }

    @Test
    public void testForward() {
        String containerId = "containerId";
        long taskId = 1L;
        String userId = "user";
        String serverTemplateId = "serverTemplateId";
        this.remoteTaskService.forward("serverTemplateId", "containerId", Long.valueOf(1L), "user");
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).forwardTask("containerId", Long.valueOf(1L), CURRENT_USER, "user");
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration)).getServerClient("serverTemplateId");
    }

    @Test
    public void testDelegateTasksSuccessfully() {
        String userId = "user";
        String serverTemplateId = "serverTemplateId";
        Long taskId1 = 1L;
        String deploymentId1 = "deploymentId1";
        Long taskId2 = 2L;
        String deploymentId2 = "deploymentId2";
        Long taskId3 = 3L;
        String deploymentId3 = "deploymentId3";
        List<TaskKey> taskKeysToReassign = Arrays.asList(new TaskKey("serverTemplateId", deploymentId1, taskId1), new TaskKey("serverTemplateId", deploymentId2, taskId2), new TaskKey("serverTemplateId", deploymentId3, taskId3));
        String currentUser = this.identityProvider.getName();
        TaskInstance taskInstance = TaskInstance.builder().id(Long.valueOf(1L)).status("Ready").actualOwner(currentUser).build();
        Mockito.when((Object)this.userTaskServicesClient.getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.eq((boolean)false), Mockito.eq((boolean)false), Mockito.eq((boolean)true))).thenReturn((Object)taskInstance);
        this.remoteTaskService.delegateTasks("serverTemplateId", taskKeysToReassign, "user");
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(deploymentId1, taskId1, false, false, true);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(deploymentId2, taskId2, false, false, true);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(deploymentId3, taskId3, false, false, true);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).delegateTask(deploymentId1, taskId1, this.identityProvider.getName(), "user");
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).delegateTask(deploymentId2, taskId2, this.identityProvider.getName(), "user");
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).delegateTask(deploymentId3, taskId3, this.identityProvider.getName(), "user");
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)6))).getServerClient("serverTemplateId");
    }

    @Test
    public void testDelegateTasksFailingOnCompleteTasks() {
        String userId = "user";
        String serverTemplateId = "serverTemplateId";
        Long taskId1 = 1L;
        String deploymentId1 = "deploymentId1";
        Long taskId2 = 2L;
        String deploymentId2 = "deploymentId2";
        Long taskId3 = 3L;
        String deploymentId3 = "deploymentId3";
        List<TaskKey> taskKeysToReassign = Arrays.asList(new TaskKey("serverTemplateId", deploymentId1, taskId1), new TaskKey("serverTemplateId", deploymentId2, taskId2), new TaskKey("serverTemplateId", deploymentId3, taskId3));
        String currentUser = this.identityProvider.getName();
        TaskInstance taskInstance = TaskInstance.builder().id(Long.valueOf(1L)).status("Completed").actualOwner(currentUser).build();
        Mockito.when((Object)this.userTaskServicesClient.getTaskInstance(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.eq((boolean)false), Mockito.eq((boolean)false), Mockito.eq((boolean)true))).thenReturn((Object)taskInstance);
        this.remoteTaskService.delegateTasks("serverTemplateId", taskKeysToReassign, "user");
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(deploymentId1, taskId1, false, false, true);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(deploymentId2, taskId2, false, false, true);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).getTaskInstance(deploymentId3, taskId3, false, false, true);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient, (VerificationMode)Mockito.never())).delegateTask(Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Mockito.anyString(), Mockito.anyString());
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)3))).getServerClient("serverTemplateId");
    }

    @Test
    public void getTask_ReturnsSingleTaskTest() {
        String containerId = "containerId";
        long taskId = 1L;
        String taskName = "taskName";
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.userTaskServicesClient.findTaskById((Long)Mockito.any())).thenReturn((Object)TaskInstance.builder().id(Long.valueOf(1L)).name("taskName").build());
        TaskSummary taskSummary = this.remoteTaskService.getTask("serverTemplateId", "containerId", Long.valueOf(1L));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskById(Long.valueOf(1L));
        Assert.assertNotNull((Object)taskSummary);
        Assert.assertTrue((1L == (Long)taskSummary.getId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"taskName", (Object)taskSummary.getName());
    }

    @Test
    public void getTask_ReturnsNoneTasksTest() {
        long taskId = 1L;
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.userTaskServicesClient.findTaskById((Long)Mockito.any())).thenReturn(null);
        TaskSummary taskSummary = this.remoteTaskService.getTask("serverTemplateId", "containerId", Long.valueOf(1L));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskById(Long.valueOf(1L));
        Assert.assertNull((Object)taskSummary);
    }

    @Test
    public void getTaskWithSLA_ReturnsSingleTaskTest() {
        String containerId = "containerId";
        long taskId = 1L;
        Date slaDueDate = new Date();
        String taskName = "taskName";
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.userTaskServicesClient.findTaskById((Long)Mockito.any(), Mockito.eq((boolean)true))).thenReturn((Object)TaskInstance.builder().id(Long.valueOf(1L)).name("taskName").slaCompliance(Integer.valueOf(0)).slaDueDate(slaDueDate).build());
        TaskSummary taskSummary = this.remoteTaskService.getTaskWithSLA("serverTemplateId", "containerId", Long.valueOf(1L));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskById(Long.valueOf(1L), true);
        Assert.assertNotNull((Object)taskSummary);
        Assert.assertTrue((1L == (Long)taskSummary.getId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"taskName", (Object)taskSummary.getName());
        Assert.assertTrue((0 == taskSummary.getSlaCompliance() ? 1 : 0) != 0);
        Assert.assertEquals((Object)slaDueDate, (Object)taskSummary.getSlaDueDate());
    }

    @Test
    public void getTaskWithSLA_ReturnsNoneTasksTest() {
        long taskId = 1L;
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.userTaskServicesClient.findTaskById((Long)Mockito.any(), Mockito.eq((boolean)true))).thenReturn(null);
        TaskSummary taskSummary = this.remoteTaskService.getTaskWithSLA("serverTemplateId", "containerId", Long.valueOf(1L));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskById(Long.valueOf(1L), true);
        Assert.assertNull((Object)taskSummary);
    }

    @Test
    public void testTaskComplete() {
        String containerId = "containerId";
        Long taskId = 1L;
        String serverTemplateId = "serverTemplateId";
        Map output = Collections.emptyMap();
        this.remoteTaskService.completeTask("serverTemplateId", "containerId", taskId, output);
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).completeTask("containerId", taskId, CURRENT_USER, output);
        ArgumentCaptor captor = ArgumentCaptor.forClass(TaskCompletedEvent.class);
        ((Event)Mockito.verify(this.taskCompletedEvent)).fire(captor.capture());
        TaskCompletedEvent event = (TaskCompletedEvent)captor.getValue();
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)taskId, (Object)event.getTaskId());
        Assert.assertEquals((Object)"containerId", (Object)event.getContainerId());
        Assert.assertEquals((Object)"serverTemplateId", (Object)event.getServerTemplateId());
    }

    @Test
    public void getTaskByWorkItem_ReturnsSingleTaskTest() {
        String containerId = "containerId";
        long workItemId = 1L;
        String taskName = "taskName";
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId((Long)Mockito.any())).thenReturn((Object)TaskInstance.builder().id(Long.valueOf(1L)).name("taskName").build());
        TaskSummary taskSummary = this.remoteTaskService.getTaskByWorkItemId("serverTemplateId", "containerId", Long.valueOf(1L));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskByWorkItemId(Long.valueOf(1L));
        Assert.assertNotNull((Object)taskSummary);
        Assert.assertTrue((1L == (Long)taskSummary.getId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"taskName", (Object)taskSummary.getName());
    }

    @Test
    public void getTaskByWorkItemId_ReturnsNoneTasksTest() {
        long workItemId = 1L;
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.userTaskServicesClient.findTaskByWorkItemId((Long)Mockito.any())).thenReturn(null);
        TaskSummary taskSummary = this.remoteTaskService.getTaskByWorkItemId("serverTemplateId", "containerId", Long.valueOf(1L));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskByWorkItemId(Long.valueOf(1L));
        Assert.assertNull((Object)taskSummary);
    }

    @Test
    public void getTaskEventsTest() {
        long taskId = 1L;
        String containerId = "containerId";
        String serverTemplateId = "serverTemplateId";
        TaskEventInstance eventInstance = TaskEventInstance.builder().taskId(Long.valueOf(1L)).type("STARTED").user("wbadmin").workItemId(Long.valueOf(2L)).date(new Date()).message("").build();
        Mockito.when((Object)this.userTaskServicesClient.findTaskEvents("containerId", Long.valueOf(1L), Integer.valueOf(0), Integer.valueOf(5), "id", false)).thenReturn(Arrays.asList(eventInstance));
        List taskEventSummaries = this.remoteTaskService.getTaskEvents("serverTemplateId", "containerId", Long.valueOf(1L), Integer.valueOf(0), Integer.valueOf(5));
        ((UserTaskServicesClient)Mockito.verify((Object)this.userTaskServicesClient)).findTaskEvents("containerId", Long.valueOf(1L), Integer.valueOf(0), Integer.valueOf(5), "id", false);
        Assert.assertEquals((long)1L, (long)taskEventSummaries.size());
        Assert.assertEquals((Object)eventInstance.getId(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getEventId());
        Assert.assertEquals((Object)eventInstance.getTaskId(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getTaskId());
        Assert.assertEquals((Object)eventInstance.getType(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getType());
        Assert.assertEquals((Object)eventInstance.getUserId(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getUserId());
        Assert.assertEquals((Object)eventInstance.getWorkItemId(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getWorkItemId());
        Assert.assertEquals((Object)eventInstance.getLogTime(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getLogTime());
        Assert.assertEquals((Object)eventInstance.getMessage(), (Object)((TaskEventSummary)taskEventSummaries.get(0)).getMessage());
    }
}

