/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.util.List;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.workbench.ht.backend.server.DataSetDefsBootstrap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    DataSetDefRegistry dataSetDefRegistryMock;
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;

    @Test
    public void registerDataSetDefinitionsTest() {
        this.dataSetsBootstrap.registerDataSetDefinitions();
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistryMock, (VerificationMode)Mockito.times((int)4))).registerDataSetDef((DataSetDef)argument.capture());
        List dsList = argument.getAllValues();
        Assert.assertEquals((long)dsList.size(), (long)4L);
        Assert.assertEquals((Object)((DataSetDef)dsList.get(0)).getUUID(), (Object)"jbpmHumanTasks");
        Assert.assertEquals((Object)((DataSetDef)dsList.get(1)).getUUID(), (Object)"jbpmHumanTasksWithUser");
        Assert.assertEquals((Object)((DataSetDef)dsList.get(2)).getUUID(), (Object)"jbpmHumanTasksWithAdmin");
        Assert.assertEquals((Object)((DataSetDef)dsList.get(3)).getUUID(), (Object)"jbpmHumanTasksWithVariables");
    }

    @Test
    public void noOrderByPresentInDefinitionsSQLTest() {
        this.dataSetsBootstrap.registerDataSetDefinitions();
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistryMock, (VerificationMode)Mockito.times((int)4))).registerDataSetDef((DataSetDef)argument.capture());
        List dsList = argument.getAllValues();
        Assert.assertFalse((boolean)((SQLDataSetDef)dsList.get(0)).getDbSQL().contains("order by"));
        Assert.assertFalse((boolean)((SQLDataSetDef)dsList.get(1)).getDbSQL().contains("order by"));
        Assert.assertFalse((boolean)((SQLDataSetDef)dsList.get(2)).getDbSQL().contains("order by"));
        Assert.assertFalse((boolean)((SQLDataSetDef)dsList.get(3)).getDbSQL().contains("order by"));
    }

    @Test
    public void columnAliasNotPresentInHumanTaskWithUserDataSet() {
        String[] columnsStr;
        this.dataSetsBootstrap.registerDataSetDefinitions();
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistryMock, (VerificationMode)Mockito.times((int)4))).registerDataSetDef((DataSetDef)argument.capture());
        List dsList = argument.getAllValues();
        String strSQL = ((SQLDataSetDef)dsList.get(1)).getDbSQL();
        for (String columnStr : columnsStr = strSQL.substring(strSQL.indexOf("select") + 6, strSQL.indexOf("from")).split(",")) {
            String[] split = columnStr.trim().split(" ");
            Assert.assertEquals((long)1L, (long)split.length);
        }
    }

    @Test
    public void columnsAddedInHumanTaskWithAdminDataSet() {
        this.dataSetsBootstrap.registerDataSetDefinitions();
        ArgumentCaptor argument = ArgumentCaptor.forClass(DataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistryMock, (VerificationMode)Mockito.times((int)4))).registerDataSetDef((DataSetDef)argument.capture());
        List dsList = argument.getAllValues();
        DataSetDef humanTaskWithAdminDataSet = dsList.stream().filter(a -> a.getUUID().equals("jbpmHumanTasksWithAdmin")).findFirst().get();
        List dataSetColumns = humanTaskWithAdminDataSet.getColumns();
        Assert.assertEquals((long)21L, (long)dataSetColumns.size());
    }
}

