/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.console.ng.ht.forms.modeler.client.editors.taskform.displayers;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.console.ng.ga.forms.display.view.FormContentResizeListener;
import org.jbpm.console.ng.gc.forms.client.display.displayers.util.JSNIHelper;
import org.jbpm.console.ng.ht.forms.modeler.client.editors.taskform.displayers.test.TestFormModellerStartProcessDisplayerImpl;
import org.jbpm.console.ng.ht.forms.modeler.display.impl.FormModelerFormRenderingSettings;
import org.jbpm.console.ng.ht.forms.modeler.service.FormModelerProcessStarterEntryPoint;
import org.jbpm.console.ng.pr.events.NewProcessInstanceEvent;
import org.jbpm.formModeler.api.client.FormRenderContextTO;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.api.events.ResizeFormcontainerEvent;
import org.jbpm.formModeler.renderer.client.FormRendererWidget;
import org.jgroups.util.Util;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class FormModellerStartProcessDisplayerTest {
    @GwtMock
    private FormRendererWidget rendererWidget;
    @Mock
    private FormModelerProcessStarterEntryPoint service;
    @Mock
    private FormContentResizeListener resizeListener;
    @Mock
    private EventSourceMock<NewProcessInstanceEvent> newProcessInstanceEvent;
    @GwtMock
    protected JSNIHelper jsniHelper;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent;
    private CallerMock<FormModelerProcessStarterEntryPoint> serviceCaller;
    private TestFormModellerStartProcessDisplayerImpl displayer;
    private FormModelerFormRenderingSettings settings = new FormModelerFormRenderingSettings("ctxtID");

    @Before
    public void init() {
        this.serviceCaller = new CallerMock((Object)this.service);
        this.displayer = new TestFormModellerStartProcessDisplayerImpl(this.rendererWidget, (Caller<FormModelerProcessStarterEntryPoint>)this.serviceCaller);
        this.displayer.setNewProcessInstanceEvent((Event<NewProcessInstanceEvent>)this.newProcessInstanceEvent);
        this.displayer.setJSNIHelper(this.jsniHelper);
        this.displayer.setNotificationEvent((Event<NotificationEvent>)this.notificationEvent);
        this.displayer.setResizeListener(this.resizeListener);
        Util.assertEquals((Object)this.rendererWidget, (Object)this.displayer.getFormWidget());
    }

    @Test
    public void testDisplay() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.initDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).loadContext(this.settings.getContextId());
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).setVisible(true);
    }

    @Test
    public void testResizeEventWithSettings() {
        this.displayer.setRenderingSettings(this.settings);
        ResizeFormcontainerEvent resizeEvent = new ResizeFormcontainerEvent();
        resizeEvent.setContext(new FormRenderContextTO(this.settings.getContextId()));
        resizeEvent.setHeight(100);
        resizeEvent.setWidth(100);
        this.displayer.onFormResized(resizeEvent);
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).resize(100, 100);
        ((FormContentResizeListener)Mockito.verify((Object)this.resizeListener)).resize(100, 100);
    }

    @Test
    public void testResizeEventWithoutSettings() {
        ResizeFormcontainerEvent resizeEvent = new ResizeFormcontainerEvent();
        resizeEvent.setContext(new FormRenderContextTO(this.settings.getContextId()));
        resizeEvent.setHeight(100);
        resizeEvent.setWidth(100);
        this.displayer.onFormResized(resizeEvent);
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget, (VerificationMode)Mockito.never())).resize(100, 100);
        ((FormContentResizeListener)Mockito.verify((Object)this.resizeListener, (VerificationMode)Mockito.never())).resize(100, 100);
    }

    @Test
    public void testStartProcessWithSettings() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.startProcessFromDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).submitFormAndPersist();
        FormSubmittedEvent formSubmittedEvent = new FormSubmittedEvent(new FormRenderContextTO(this.settings.getContextId(), true, 0));
        this.displayer.onFormSubmitted(formSubmittedEvent);
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).startProcessFromRenderContext(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.newProcessInstanceEvent)).fire(Mockito.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper)).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Mockito.any());
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).clearContext(this.settings.getContextId());
    }

    @Test
    public void testStartProcessWithoutSettings() {
        this.displayer.startProcessFromDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).submitFormAndPersist();
        FormSubmittedEvent formSubmittedEvent = new FormSubmittedEvent(new FormRenderContextTO(this.settings.getContextId(), true, 0));
        this.displayer.onFormSubmitted(formSubmittedEvent);
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).startProcessFromRenderContext(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.newProcessInstanceEvent, (VerificationMode)Mockito.never())).fire(Mockito.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper, (VerificationMode)Mockito.never())).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
        ((EventSourceMock)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.never())).fire(Mockito.any());
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).clearContext(this.settings.getContextId());
    }
}

