/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.ala.build.maven.config.impl.MavenDependencyConfigImpl;
import org.guvnor.ala.build.maven.executor.MavenDependencyConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineFactory;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.registry.BuildRegistry;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.local.InMemoryBuildRegistry;
import org.guvnor.ala.registry.local.InMemoryRuntimeRegistry;
import org.guvnor.ala.wildfly.access.WildflyAccessInterface;
import org.guvnor.ala.wildfly.access.impl.WildflyAccessInterfaceImpl;
import org.guvnor.ala.wildfly.config.WildflyProviderConfig;
import org.guvnor.ala.wildfly.config.impl.ContextAwareWildflyRuntimeExecConfig;
import org.guvnor.ala.wildfly.executor.WildflyProviderConfigExecutor;
import org.guvnor.ala.wildfly.executor.WildflyRuntimeExecExecutor;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.wi.backend.server.casemgmt.service.CaseProvisioningExecutor;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningCompletedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningFailedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningStartedEvent;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningService;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningSettings;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@ApplicationScoped
@Startup(value=StartupType.BOOTSTRAP)
@Service
public class CaseProvisioningServiceImpl
implements CaseProvisioningService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseProvisioningServiceImpl.class);
    private static final String PIPELINE_NAME = "jBPM Case Management showcase pipeline";
    @Inject
    private CaseProvisioningSettings settings;
    @Inject
    private CaseProvisioningExecutor executor;
    private CaseProvisioningStatus status = CaseProvisioningStatus.DISABLED;
    private String caseAppContext;

    @PostConstruct
    public void init() {
        Pipeline pipeline;
        PipelineExecutor pipelineExecutor;
        if (!this.settings.isProvisioningEnabled()) {
            return;
        }
        LOGGER.info("jBPM Case Management Showcase deployment enabled");
        InMemoryRuntimeRegistry runtimeRegistry = new InMemoryRuntimeRegistry();
        WildflyAccessInterfaceImpl wildflyAccessInterface = new WildflyAccessInterfaceImpl();
        Stage runtimeExec = StageUtil.config((String)"Wildfly Runtime Exec", s -> new ContextAwareWildflyRuntimeExecConfig());
        Input input = new Input();
        input.put((Object)"wildfly-user", (Object)this.settings.getUsername());
        input.put((Object)"wildfly-password", (Object)this.settings.getPassword());
        input.put((Object)"host", (Object)this.settings.getHost());
        input.put((Object)"management-port", (Object)this.settings.getManagementPort());
        input.put((Object)"redeploy", (Object)"none");
        if (this.settings.isDeployFromLocalPath()) {
            Stage providerConfig = StageUtil.config((String)"Wildfly Provider Config", s -> new WildflyProviderConfig(){});
            pipelineExecutor = new PipelineExecutor(Arrays.asList(new WildflyProviderConfigExecutor((RuntimeRegistry)runtimeRegistry), new WildflyRuntimeExecExecutor((RuntimeRegistry)runtimeRegistry, (WildflyAccessInterface)wildflyAccessInterface)));
            pipeline = PipelineFactory.startFrom((Stage)providerConfig).andThen(runtimeExec).buildAs(PIPELINE_NAME);
            input.put((Object)"war-path", (Object)this.settings.getPath());
        } else {
            Stage mavenConfig = StageUtil.config((String)"Maven Artifact", s -> new MavenDependencyConfigImpl());
            Stage providerConfig = StageUtil.config((String)"Wildfly Provider Config", s -> new WildflyProviderConfig(){});
            InMemoryBuildRegistry buildRegistry = new InMemoryBuildRegistry();
            pipelineExecutor = new PipelineExecutor(Arrays.asList(new MavenDependencyConfigExecutor((BuildRegistry)buildRegistry), new WildflyProviderConfigExecutor((RuntimeRegistry)runtimeRegistry), new WildflyRuntimeExecExecutor((RuntimeRegistry)runtimeRegistry, (WildflyAccessInterface)wildflyAccessInterface)));
            pipeline = PipelineFactory.startFrom((Stage)mavenConfig).andThen(providerConfig).andThen(runtimeExec).buildAs(PIPELINE_NAME);
            input.put((Object)"artifact", (Object)this.settings.getGAV());
        }
        this.executor.execute(pipelineExecutor, pipeline, input);
    }

    public CaseProvisioningStatus getProvisioningStatus() {
        return this.status;
    }

    public void onCaseManagementProvisioningStartedEvent(@Observes CaseProvisioningStartedEvent event) {
        this.status = CaseProvisioningStatus.STARTED;
    }

    public void onCaseManagementProvisioningCompletedEvent(@Observes CaseProvisioningCompletedEvent event) {
        this.status = CaseProvisioningStatus.COMPLETED;
        this.caseAppContext = event.getAppContext();
    }

    public void onCaseManagementProvisioningFailedEvent(@Observes CaseProvisioningFailedEvent event) {
        this.status = CaseProvisioningStatus.FAILED;
    }

    public String getApplicationContext() {
        if (this.status == CaseProvisioningStatus.DISABLED) {
            return this.settings.getURL();
        }
        return this.caseAppContext;
    }
}

