/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.dd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.SourceVersion;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jbpm.workbench.wi.backend.server.dd.DDConfigUpdaterHelper;
import org.jbpm.workbench.wi.backend.server.dd.DeploymentDescriptorIO;
import org.jbpm.workbench.wi.backend.server.dd.DeploymentDescriptorImpl;
import org.jbpm.workbench.wi.backend.server.dd.DeploymentDescriptorManager;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.model.Parameter;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.jbpm.workbench.wi.dd.validation.DeploymentDescriptorValidationMessage;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.workbench.common.services.backend.service.KieService;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@Service
@ApplicationScoped
public class DDEditorServiceImpl
extends KieService<DeploymentDescriptorModel>
implements DDEditorService {
    public static final String I18N_KEY_MISSING_IDENTIFIER = "DDValidationMissingIdentifier";
    public static final String I18N_KEY_MISSING_RESOLVER = "DDValidationMissingResolver";
    public static final String I18N_KEY_NOT_VALID_RESOLVER = "DDValidationNotValidResolver";
    public static final String I18N_KEY_NOT_VALID_REFLECTION_IDENTIFIER = "DDValidationNotValidReflectionIdentifier";
    public static final String I18N_KEY_NOT_VALID_MVEL_IDENTIFIER = "DDValidationNotValidMvelIdentifier";
    public static final String I18N_KEY_MISSING_NAME = "DDValidationMissingName";
    public static final String I18N_KEY_UNEXPECTED_ERROR = "DDValidationUnexpectedError";
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private DDConfigUpdaterHelper configUpdaterHelper;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;

    public DeploymentDescriptorModel load(org.uberfire.backend.vfs.Path path) {
        return (DeploymentDescriptorModel)super.loadContent(path);
    }

    protected DeploymentDescriptorModel constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        InputStream input = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[0]);
        DeploymentDescriptor originDD = DeploymentDescriptorIO.fromXml(input);
        DeploymentDescriptorModel ddModel = this.marshal(originDD);
        ddModel.setOverview(overview);
        return ddModel;
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel content, Metadata metadata, String comment) {
        try {
            this.save(path, content, metadata, this.commentedOptionFactory.makeCommentedOption(comment));
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel content, Metadata metadata, CommentedOption commentedOption) {
        try {
            String deploymentContent = this.unmarshal(path, content).toXml();
            Metadata currentMetadata = this.metadataService.getMetadata(path);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), deploymentContent, this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{commentedOption});
            this.fireMetadataSocialEvents(path, currentMetadata, metadata);
            return path;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel content) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        try {
            DeploymentDescriptor dd = this.unmarshal(path, content);
            validationMessages.addAll(this.validateObjectModels(path, dd.getConfiguration()));
            validationMessages.addAll(this.validateObjectModels(path, dd.getEnvironmentEntries()));
            validationMessages.addAll(this.validateObjectModels(path, dd.getEventListeners()));
            validationMessages.addAll(this.validateObjectModels(path, dd.getGlobals()));
            validationMessages.addAll(this.validateObjectModels(path, dd.getMarshallingStrategies()));
            validationMessages.addAll(this.validateObjectModels(path, dd.getTaskEventListeners()));
            validationMessages.addAll(this.validateObjectModels(path, dd.getWorkItemHandlers()));
            dd.toXml();
        }
        catch (Exception e) {
            ValidationMessage msg = new ValidationMessage();
            msg.setPath(path);
            msg.setLevel(Level.ERROR);
            msg.setText(e.getMessage());
            validationMessages.add(msg);
        }
        return validationMessages;
    }

    public String toSource(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel model) {
        try {
            return this.unmarshal(path, model).toXml();
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected List<ValidationMessage> validateObjectModels(org.uberfire.backend.vfs.Path path, List<? extends ObjectModel> objectModels) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        objectModels.forEach(model -> {
            String name;
            String resolver;
            String identifier = model.getIdentifier();
            if (identifier == null || identifier.isEmpty()) {
                validationMessages.add(this.newMessage(path, "Identifier cannot be empty for " + model.getIdentifier(), Level.ERROR, I18N_KEY_MISSING_IDENTIFIER, model.getIdentifier()));
            }
            if ((resolver = model.getResolver()) == null) {
                validationMessages.add(this.newMessage(path, "No resolver selected for " + model.getIdentifier(), Level.ERROR, I18N_KEY_MISSING_RESOLVER, model.getIdentifier()));
            } else if (resolver.equalsIgnoreCase("mvel")) {
                try {
                    ParserContext parserContext = new ParserContext();
                    MVEL.compileExpression((String)identifier, (ParserContext)parserContext);
                }
                catch (CompileException e) {
                    StringBuilder text = new StringBuilder();
                    text.append("Could not compile mvel expression '" + model.getIdentifier() + "'.").append(" this can be due to invalid syntax of missing classes").append("-").append(e.getMessage());
                    validationMessages.add(this.newMessage(path, text.toString(), Level.WARNING, I18N_KEY_NOT_VALID_MVEL_IDENTIFIER, model.getIdentifier(), e.getMessage()));
                }
            } else if (resolver.equalsIgnoreCase("reflection")) {
                if (!SourceVersion.isName(identifier)) {
                    validationMessages.add(this.newMessage(path, "Identifier is not valid Java class which is required by reflection resolver " + model.getIdentifier(), Level.ERROR, I18N_KEY_NOT_VALID_REFLECTION_IDENTIFIER, model.getIdentifier()));
                }
            } else {
                validationMessages.add(this.newMessage(path, "Not valid resolver selected for " + model.getIdentifier(), Level.ERROR, I18N_KEY_NOT_VALID_RESOLVER, model.getIdentifier()));
            }
            if (model instanceof NamedObjectModel && ((name = ((NamedObjectModel)model).getName()) == null || name.isEmpty())) {
                validationMessages.add(this.newMessage(path, "Name cannot be empty for " + model.getIdentifier(), Level.ERROR, I18N_KEY_MISSING_NAME, model.getIdentifier()));
            }
        });
        return validationMessages;
    }

    protected ValidationMessage newMessage(org.uberfire.backend.vfs.Path path, String text, Level level, String key, Object ... args) {
        DeploymentDescriptorValidationMessage msg = new DeploymentDescriptorValidationMessage();
        msg.setPath(path);
        msg.setLevel(level);
        msg.setText(text);
        msg.setKey(key);
        msg.setArgs(args);
        return msg;
    }

    protected DeploymentDescriptorModel marshal(DeploymentDescriptor originDD) {
        DeploymentDescriptorModel ddModel = new DeploymentDescriptorModel();
        ddModel.setPersistenceUnitName(originDD.getPersistenceUnit());
        ddModel.setAuditPersistenceUnitName(originDD.getAuditPersistenceUnit());
        ddModel.setAuditMode(originDD.getAuditMode().toString());
        ddModel.setPersistenceMode(originDD.getPersistenceMode().toString());
        ddModel.setRuntimeStrategy(originDD.getRuntimeStrategy().toString());
        List marshallingStrategies = originDD.getMarshallingStrategies();
        ddModel.setMarshallingStrategies(this.processObjectModel(marshallingStrategies));
        List eventListeners = originDD.getEventListeners();
        ddModel.setEventListeners(this.processObjectModel(eventListeners));
        List globals = originDD.getGlobals();
        ddModel.setGlobals(this.processNamedObjectModel(globals));
        List workItemHandlers = originDD.getWorkItemHandlers();
        ddModel.setWorkItemHandlers(this.processNamedObjectModel(workItemHandlers));
        List taskEventListeners = originDD.getTaskEventListeners();
        ddModel.setTaskEventListeners(this.processObjectModel(taskEventListeners));
        List environmentEntries = originDD.getEnvironmentEntries();
        ddModel.setEnvironmentEntries(this.processNamedObjectModel(environmentEntries));
        List configuration = originDD.getConfiguration();
        ddModel.setConfiguration(this.processNamedObjectModel(configuration));
        ddModel.setRequiredRoles(originDD.getRequiredRoles());
        ddModel.setRemotableClasses(originDD.getClasses());
        ddModel.setLimitSerializationClasses(originDD.getLimitSerializationClasses());
        return ddModel;
    }

    protected DeploymentDescriptor unmarshal(org.uberfire.backend.vfs.Path path, DeploymentDescriptorModel model) {
        if (model == null) {
            return new DeploymentDescriptorManager().getDefaultDescriptor();
        }
        DeploymentDescriptorImpl updated = new DeploymentDescriptorImpl();
        updated.getBuilder().persistenceUnit(model.getPersistenceUnitName()).auditPersistenceUnit(model.getAuditPersistenceUnitName()).auditMode(AuditMode.valueOf((String)model.getAuditMode())).persistenceMode(PersistenceMode.valueOf((String)model.getPersistenceMode())).runtimeStrategy(RuntimeStrategy.valueOf((String)model.getRuntimeStrategy())).setLimitSerializationClasses(model.getLimitSerializationClasses());
        List marshallingStrategies = model.getMarshallingStrategies();
        updated.getBuilder().setMarshalingStrategies(this.processToObjectModel(marshallingStrategies));
        List eventListeners = model.getEventListeners();
        updated.getBuilder().setEventListeners(this.processToObjectModel(eventListeners));
        List globals = model.getGlobals();
        updated.getBuilder().setGlobals(this.processToNamedObjectModel(globals));
        List workItemHandlers = model.getWorkItemHandlers();
        updated.getBuilder().setWorkItemHandlers(this.processToNamedObjectModel(workItemHandlers));
        List taskEventListeners = model.getTaskEventListeners();
        updated.getBuilder().setTaskEventListeners(this.processToObjectModel(taskEventListeners));
        List environmentEntries = model.getEnvironmentEntries();
        updated.getBuilder().setEnvironmentEntries(this.processToNamedObjectModel(environmentEntries));
        List configuration = model.getConfiguration();
        updated.getBuilder().setConfiguration(this.processToNamedObjectModel(configuration));
        updated.getBuilder().setRequiredRoles(model.getRequiredRoles());
        updated.getBuilder().setClasses(model.getRemotableClasses());
        return updated;
    }

    private List<ItemObjectModel> processNamedObjectModel(List<NamedObjectModel> data) {
        ArrayList<ItemObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<ItemObjectModel>();
            for (NamedObjectModel orig : data) {
                List<Parameter> parameters = this.collectParameters(orig.getParameters());
                result.add(new ItemObjectModel(orig.getName(), orig.getIdentifier(), orig.getResolver(), parameters));
            }
        }
        return result;
    }

    private List<ItemObjectModel> processObjectModel(List<ObjectModel> data) {
        ArrayList<ItemObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<ItemObjectModel>();
            for (ObjectModel orig : data) {
                List<Parameter> parameters = this.collectParameters(orig.getParameters());
                result.add(new ItemObjectModel(null, orig.getIdentifier(), orig.getResolver(), parameters));
            }
        }
        return result;
    }

    private List<Parameter> collectParameters(List<Object> parameters) {
        ArrayList<Parameter> result = null;
        if (parameters != null && !parameters.isEmpty()) {
            result = new ArrayList<Parameter>();
            for (Object param : parameters) {
                if (!(param instanceof ObjectModel)) continue;
                ObjectModel model = (ObjectModel)param;
                result.add(new Parameter(model.getIdentifier(), model.getParameters().get(0).toString()));
            }
        }
        return result;
    }

    private List<ObjectModel> processToObjectModel(List<ItemObjectModel> data) {
        ArrayList<ObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<ObjectModel>();
            for (ItemObjectModel item : data) {
                ObjectModel ms = new ObjectModel(item.getResolver(), item.getValue(), new Object[0]);
                if (item.getParameters() != null) {
                    for (Parameter param : item.getParameters()) {
                        ObjectModel p = new ObjectModel(item.getResolver(), param.getType(), new Object[]{param.getValue().trim()});
                        ms.addParameter((Object)p);
                    }
                }
                result.add(ms);
            }
        }
        return result;
    }

    private List<NamedObjectModel> processToNamedObjectModel(List<ItemObjectModel> data) {
        ArrayList<NamedObjectModel> result = null;
        if (data != null) {
            result = new ArrayList<NamedObjectModel>();
            for (ItemObjectModel item : data) {
                NamedObjectModel ms = new NamedObjectModel(item.getResolver(), item.getName(), item.getValue(), new Object[0]);
                if (item.getParameters() != null) {
                    for (Parameter param : item.getParameters()) {
                        ObjectModel p = new ObjectModel(item.getResolver(), param.getType(), new Object[]{param.getValue().trim()});
                        ms.addParameter((Object)p);
                    }
                }
                result.add(ms);
            }
        }
        return result;
    }

    public void createIfNotExists(org.uberfire.backend.vfs.Path path) {
        Path converted = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (!this.ioService.exists(converted)) {
            DeploymentDescriptor dd = new DeploymentDescriptorManager("org.jbpm.domain").getDefaultDescriptor();
            if (this.configUpdaterHelper.hasPersistenceFile(path)) {
                this.configUpdaterHelper.addJPAMarshallingStrategy(dd, path);
            }
            String xmlDescriptor = dd.toXml();
            this.ioService.write(converted, xmlDescriptor, new OpenOption[0]);
        }
    }

    public boolean accepts(org.uberfire.backend.vfs.Path path) {
        return path.getFileName().equals("kie-deployment-descriptor.xml");
    }

    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path path) {
        try {
            InputStream input = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)path), new OpenOption[0]);
            DeploymentDescriptorModel ddModel = this.marshal(DeploymentDescriptorIO.fromXml(input));
            return this.validate(path, ddModel);
        }
        catch (Exception e) {
            return Arrays.asList(this.newMessage(path, e.getMessage(), Level.ERROR, I18N_KEY_UNEXPECTED_ERROR, e.getMessage()));
        }
    }
}

