/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.workitem;

import java.util.ArrayList;
import org.guvnor.structure.organizationalunit.RepoRemovedFromOrganizationalUnitEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.jbpm.process.workitem.repository.service.RepoData;
import org.jbpm.workbench.wi.backend.server.workitem.RepositoryStorageVFSImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@RunWith(value=MockitoJUnitRunner.class)
public class RepositoryStorageVFSImplTest {
    @Mock
    private IOService ioService;
    @Mock
    private FileSystem fileSystem;
    @Mock
    private RepositoryRemovedEvent repositoryRemovedEvent;
    @Mock
    private RepoRemovedFromOrganizationalUnitEvent spaceRepositoryRemovedEvent;
    @Mock
    private Repository repo;
    private RepoData service;
    private RepositoryStorageVFSImpl storage;

    @Before
    public void setup() {
        this.storage = new RepositoryStorageVFSImpl(this.ioService, this.fileSystem);
        this.storage.init();
        this.service = new RepoData();
        this.service.setName("test");
        this.service.setModule("module");
        this.service.getInstalledOn().add("myspace/myproject");
        ArrayList<RepoData> currentServices = new ArrayList<RepoData>();
        currentServices.add(this.service);
        this.storage.synchronizeServices(currentServices);
    }

    @Test
    public void testOnProjectRemoved() {
        Assert.assertEquals((long)1L, (long)this.service.getInstalledOn().size());
        Mockito.when((Object)this.repo.getUri()).thenReturn((Object)"default://myspace/myproject");
        Mockito.when((Object)this.repositoryRemovedEvent.getRepository()).thenReturn((Object)this.repo);
        this.storage.onProjectDeleted(this.repositoryRemovedEvent);
        Assert.assertEquals((long)0L, (long)this.service.getInstalledOn().size());
    }

    @Test
    public void testOnSpaceRemoved() {
        Assert.assertEquals((long)1L, (long)this.service.getInstalledOn().size());
        Mockito.when((Object)this.repo.getUri()).thenReturn((Object)"default://myspace/myproject");
        Mockito.when((Object)this.spaceRepositoryRemovedEvent.getRepository()).thenReturn((Object)this.repo);
        this.storage.onSpaceDeleted(this.spaceRepositoryRemovedEvent);
        Assert.assertEquals((long)0L, (long)this.service.getInstalledOn().size());
    }
}

