/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.dd;

import java.net.URI;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jbpm.designer.notification.DesignerWorkitemInstalledEvent;
import org.jbpm.workbench.wi.backend.server.builder.BPMPostBuildHandler;
import org.jbpm.workbench.wi.backend.server.dd.DDConfigUpdater;
import org.jbpm.workbench.wi.backend.server.dd.DDConfigUpdaterHelper;
import org.jbpm.workbench.wi.backend.server.dd.DDEditorServiceImpl;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceAddedEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class DDConfigUpdaterTest {
    private static final String JPA_MARSHALLING_STRATEGY = "org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy";
    @Mock
    private IOService ioService;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private DDEditorServiceImpl ddEditorService;
    @Mock
    private DDConfigUpdaterHelper configUpdaterHelper;
    private DeploymentDescriptorModel model;
    private DDConfigUpdater ddConfigUpdater;

    @Before
    public void setup() {
        this.model = new DeploymentDescriptorModel();
        this.model.setOverview(new Overview());
        this.ddConfigUpdater = new DDConfigUpdater((DDEditorService)this.ddEditorService, this.moduleService, this.configUpdaterHelper);
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)rootPath.toURI()).thenReturn((Object)"default://");
        KieModule module = (KieModule)Mockito.mock(KieModule.class);
        Mockito.when((Object)module.getRootPath()).thenReturn((Object)rootPath);
        Mockito.when((Object)this.configUpdaterHelper.isPersistenceFile((Path)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.configUpdaterHelper.buildJPAMarshallingStrategyValue((KieModule)Matchers.any())).thenReturn((Object)JPA_MARSHALLING_STRATEGY);
        Mockito.when((Object)((KieModule)this.moduleService.resolveModule((Path)Matchers.any()))).thenReturn((Object)module);
        Mockito.when((Object)this.ddEditorService.load((Path)Matchers.any())).thenReturn((Object)this.model);
        ((DDEditorServiceImpl)Mockito.doNothing().when((Object)this.ddEditorService)).createIfNotExists((Path)Matchers.any());
    }

    @Test
    public void testProcessResourceAdd() {
        this.ddConfigUpdater.processResourceAdd(new ResourceAddedEvent((Path)Mockito.mock(Path.class), "test resource", (SessionInfo)Mockito.mock(SessionInfo.class)));
        Assert.assertNotNull((Object)this.model.getMarshallingStrategies());
        Assert.assertEquals((long)1L, (long)this.model.getMarshallingStrategies().size());
        ItemObjectModel objectModel = (ItemObjectModel)this.model.getMarshallingStrategies().get(0);
        Assert.assertNotNull((Object)objectModel);
        Assert.assertEquals((Object)JPA_MARSHALLING_STRATEGY, (Object)objectModel.getValue());
        Assert.assertEquals((Object)"mvel", (Object)objectModel.getResolver());
    }

    @Test
    public void testProcessWorkitemInstall() {
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "mvel", "new com.myhandlers.MyHandler()", "MyWorkItem", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)1L, (long)this.model.getWorkItemHandlers().size());
        ItemObjectModel objectModel = (ItemObjectModel)this.model.getWorkItemHandlers().get(0);
        Assert.assertNotNull((Object)objectModel);
        Assert.assertEquals((Object)"MyWorkItem", (Object)objectModel.getName());
        Assert.assertEquals((Object)"mvel", (Object)objectModel.getResolver());
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)objectModel.getValue());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "mvel", "new com.myhandlers.MyHandler2()", "MyWorkItem", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)1L, (long)this.model.getWorkItemHandlers().size());
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)((ItemObjectModel)this.model.getWorkItemHandlers().get(0)).getValue());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "reflection", "com.myhandlers.MyHandler", "MyWorkItem2", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        ItemObjectModel objectModel2 = (ItemObjectModel)this.model.getWorkItemHandlers().get(1);
        Assert.assertNotNull((Object)objectModel2);
        Assert.assertEquals((Object)"MyWorkItem2", (Object)objectModel2.getName());
        Assert.assertEquals((Object)"reflection", (Object)objectModel2.getResolver());
        Assert.assertEquals((Object)"com.myhandlers.MyHandler", (Object)objectModel2.getValue());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "mvel", "new com.myhandlers.MyHandler3()", "", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "mvel", "", "MyWorkItem3", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "mvel", "", "", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)2L, (long)this.model.getWorkItemHandlers().size());
        this.ddConfigUpdater.processWorkitemInstall(new DesignerWorkitemInstalledEvent((Path)Mockito.mock(Path.class), "reflection", "mvel: new com.myhandlers.MyHandler4()", "MyWorkItem4", ""));
        Assert.assertNotNull((Object)this.model.getWorkItemHandlers());
        Assert.assertEquals((long)3L, (long)this.model.getWorkItemHandlers().size());
        ItemObjectModel objectModel3 = (ItemObjectModel)this.model.getWorkItemHandlers().get(2);
        Assert.assertNotNull((Object)objectModel3);
        Assert.assertEquals((Object)"MyWorkItem4", (Object)objectModel3.getName());
        Assert.assertEquals((Object)"mvel", (Object)objectModel3.getResolver());
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler4()", (Object)objectModel3.getValue());
    }

    @Test
    public void testIsValidWorkitem() {
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem(null, null));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem("", ""));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem("new com.myhandlers.MyHandler()", ""));
        Assert.assertFalse((boolean)this.ddConfigUpdater.isValidWorkitem("", "MyHandler"));
        Assert.assertTrue((boolean)this.ddConfigUpdater.isValidWorkitem("MyHandler", "new com.myhandlers.MyHandler()"));
    }

    @Test
    public void testParseWorkitemValue() {
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("  new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("new com.myhandlers.MyHandler()   "));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("mvel: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("reflection: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("MVEL: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("REFLECTION: new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("  MveL:     new com.myhandlers.MyHandler()"));
        Assert.assertEquals((Object)"new com.myhandlers.MyHandler()", (Object)this.ddConfigUpdater.parseWorkitemValue("   ReFlEcTIoN:new com.myhandlers.MyHandler()   "));
    }

    @Test
    public void testGetWorkitemResolver() {
        Assert.assertEquals((Object)"mvel", (Object)this.ddConfigUpdater.getWorkitemResolver("new com.myhandlers.MyHandler()", "mvel"));
        Assert.assertEquals((Object)"mvel", (Object)this.ddConfigUpdater.getWorkitemResolver("mvel:new com.myhandlers.MyHandler()", "reflection"));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("reflection:new com.myhandlers.MyHandler()", "mvel"));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("reflection:new com.myhandlers.MyHandler()", ""));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("new com.myhandlers.MyHandler()", ""));
        Assert.assertEquals((Object)"reflection", (Object)this.ddConfigUpdater.getWorkitemResolver("new com.myhandlers.MyHandler()", null));
    }

    @Test
    public void bpmPostBuildHandler_addsRuntimeStrategyFromDeploymentDescriptor() {
        String strategyFromDeploymentDescriptor = "PerProcessInstance";
        DeploymentDescriptorModel ddModel = new DeploymentDescriptorModel();
        ddModel.setPersistenceUnitName("test");
        ddModel.setAuditPersistenceUnitName("test");
        ddModel.setRuntimeStrategy("PerProcessInstance");
        Mockito.when((Object)this.ioService.get((URI)Matchers.any())).thenReturn(null);
        Mockito.when((Object)this.ddEditorService.load((Path)Matchers.any())).thenReturn((Object)ddModel);
        BPMPostBuildHandler handler = new BPMPostBuildHandler();
        handler.setDeploymentDescriptorService((DDEditorService)this.ddEditorService);
        handler.setIoService(this.ioService);
        BuildResults results = new BuildResults();
        results.addParameter("RootPath", "default://test-project");
        handler.process(results);
        ((DDEditorServiceImpl)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).createIfNotExists((Path)Matchers.any());
        String strategy = results.getParameter("RuntimeStrategy");
        Assert.assertEquals((Object)"PerProcessInstance", (Object)strategy);
    }

    @Test
    public void bpmPostBuildHandlerCreatesDefaultDescriptor_whenDeploymentDescriptorDoesNotExist() {
        BPMPostBuildHandler handler = new BPMPostBuildHandler();
        handler.setDeploymentDescriptorService((DDEditorService)this.ddEditorService);
        handler.setIoService(this.ioService);
        BuildResults results = (BuildResults)Mockito.spy((Object)new BuildResults());
        results.addParameter("RootPath", "default://test-project");
        handler.process(results);
        ((DDEditorServiceImpl)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).createIfNotExists((Path)Matchers.any());
        ((DDEditorServiceImpl)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.times((int)1))).load((Path)Matchers.anyObject());
        ((BuildResults)Mockito.verify((Object)results, (VerificationMode)Mockito.times((int)1))).addParameter((String)Matchers.eq((Object)"RuntimeStrategy"), (String)Matchers.any());
    }

    @Test
    public void bpmPostBuildHandlerDoesNothing_whenBuildResultHasNoBuildPath() {
        BPMPostBuildHandler handler = new BPMPostBuildHandler();
        handler.setDeploymentDescriptorService((DDEditorService)this.ddEditorService);
        handler.setIoService(this.ioService);
        BuildResults resultToProcess = (BuildResults)Mockito.spy((Object)new BuildResults());
        handler.process(resultToProcess);
        ((DDEditorServiceImpl)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.never())).createIfNotExists((Path)Matchers.any());
        ((DDEditorServiceImpl)Mockito.verify((Object)this.ddEditorService, (VerificationMode)Mockito.never())).load((Path)Matchers.anyObject());
        ((BuildResults)Mockito.verify((Object)resultToProcess, (VerificationMode)Mockito.never())).addParameter((String)Matchers.eq((Object)"RuntimeStrategy"), Matchers.anyString());
    }
}

