/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.backend.server.casemgmt.service;

import java.util.concurrent.ExecutorService;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningCompletedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningFailedEvent;
import org.jbpm.workbench.wi.casemgmt.events.CaseProvisioningStartedEvent;
import org.jbpm.workbench.wi.casemgmt.service.CaseProvisioningSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.apache.commons.io.FilenameUtils;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.concurrent.Managed;

@Dependent
public class CaseProvisioningExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseProvisioningExecutor.class);
    private ExecutorService executorService;
    private CaseProvisioningSettings settings;
    private Event<CaseProvisioningStartedEvent> startedEvent;
    private Event<CaseProvisioningCompletedEvent> completedEvent;
    private Event<CaseProvisioningFailedEvent> failedEvent;

    public CaseProvisioningExecutor() {
    }

    @Inject
    public CaseProvisioningExecutor(CaseProvisioningSettings settings, Event<CaseProvisioningStartedEvent> startedEvent, Event<CaseProvisioningCompletedEvent> completedEvent, Event<CaseProvisioningFailedEvent> failedEvent, @Managed ExecutorService executorService) {
        this.settings = settings;
        this.startedEvent = startedEvent;
        this.completedEvent = completedEvent;
        this.failedEvent = failedEvent;
        this.executorService = executorService;
    }

    public void execute(PipelineExecutor executor, Pipeline pipeline, Input input) {
        this.executorService.execute((Runnable)((Object)new ProvisionRunnable(() -> {
            this.startedEvent.fire((Object)new CaseProvisioningStartedEvent());
            executor.execute(input, pipeline, b -> {
                String context = "/" + FilenameUtils.getBaseName((String)b.getId());
                this.completedEvent.fire((Object)new CaseProvisioningCompletedEvent(context));
                LOGGER.info("jBPM Case Management Showcase app provisioning completed.");
            }, new PipelineEventListener[0]);
        })));
    }

    protected int getManagementInterfaceStatus(String host, String managementPort, String password, String username) {
        int n;
        block8: {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(host, Integer.valueOf(managementPort).intValue()), (Credentials)new UsernamePasswordCredentials(username, password));
            CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
            try {
                HttpGet httpget = new HttpGet("http://" + host + ":" + managementPort + "/management");
                n = httpClient.execute((HttpUriRequest)httpget).getStatusLine().getStatusCode();
                if (httpClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LOGGER.error("Exception while trying to connect to Wildfly Management interface", (Throwable)ex);
                    return -1;
                }
            }
            httpClient.close();
        }
        return n;
    }

    private class ProvisionRunnable
    implements DescriptiveRunnable {
        private ProvisioningCommand provisioning;

        public ProvisionRunnable(ProvisioningCommand provisioning) {
            this.provisioning = provisioning;
        }

        public String getDescription() {
            return "jBPM Case Management Showcase app provisioning";
        }

        public void run() {
            try {
                LOGGER.info("Executing jBPM Case Management Showcase app provisioning...");
                this.provisionApp();
            }
            catch (Exception ex) {
                CaseProvisioningExecutor.this.failedEvent.fire((Object)new CaseProvisioningFailedEvent());
                LOGGER.error("Failed to provision jBPM Case Management Showcase app: " + ex.getMessage(), (Throwable)ex);
            }
        }

        public void provisionApp() throws Exception {
            long waitLimit = 300000L;
            long sleep = 5000L;
            for (long elapsed = 0L; elapsed < waitLimit; elapsed += sleep) {
                int responseCode = CaseProvisioningExecutor.this.getManagementInterfaceStatus(CaseProvisioningExecutor.this.settings.getHost(), CaseProvisioningExecutor.this.settings.getManagementPort(), CaseProvisioningExecutor.this.settings.getPassword(), CaseProvisioningExecutor.this.settings.getUsername());
                LOGGER.debug("HTTP Response code from Management interface: {}", (Object)responseCode);
                if (responseCode == 200) {
                    this.provisioning.execute();
                    return;
                }
                Thread.sleep(sleep);
            }
            LOGGER.info("Timeout while trying to connect with Wildfly Management interface");
        }
    }

    private static interface ProvisioningCommand {
        public void execute();
    }
}

