/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentDescriptorViewImpl;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.model.Parameter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DeploymentDescriptorViewTest {
    @Spy
    private DeploymentDescriptorViewImpl view;
    @GwtMock
    private TextBox textBox;
    @GwtMock
    private ListBox listBox;
    @GwtMock
    private CheckBox checkBox;
    private DeploymentDescriptorModel deploymentDescriptorModel;
    private int textBoxUsages = 0;
    private int listBoxUsages = 0;
    private int checkBoxUsages = 0;
    private static Random random = new Random();
    private static final String jarLocRegexStr = "([\\d\\.]{3})\\S*";
    private static final Pattern jarLocRegex = Pattern.compile("([\\d\\.]{3})\\S*");

    @Before
    public void setup() {
        this.deploymentDescriptorModel = new DeploymentDescriptorModel();
        this.deploymentDescriptorModel.setAuditPersistenceUnitName("audit-peristence");
        ++this.textBoxUsages;
        this.deploymentDescriptorModel.setPersistenceUnitName("save-thingy");
        ++this.textBoxUsages;
        this.deploymentDescriptorModel.setPersistenceMode(PersistenceMode.JPA.toString());
        ++this.listBoxUsages;
        this.deploymentDescriptorModel.setAuditMode(AuditMode.JMS.toString());
        ++this.listBoxUsages;
        this.deploymentDescriptorModel.setRuntimeStrategy(RuntimeStrategy.PER_PROCESS_INSTANCE.toString());
        ++this.listBoxUsages;
        this.deploymentDescriptorModel.setLimitSerializationClasses(Boolean.valueOf(true));
        ++this.checkBoxUsages;
        this.deploymentDescriptorModel.setRemotableClasses(Collections.singletonList("class1"));
        this.deploymentDescriptorModel.setConfiguration(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
        this.deploymentDescriptorModel.setEnvironmentEntries(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
        this.deploymentDescriptorModel.setEventListeners(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
        this.deploymentDescriptorModel.setGlobals(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
        this.deploymentDescriptorModel.setMarshallingStrategies(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
        this.deploymentDescriptorModel.setRequiredRoles(Collections.singletonList("roles"));
        this.deploymentDescriptorModel.setTaskEventListeners(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
        this.deploymentDescriptorModel.setWorkItemHandlers(Collections.singletonList(new ItemObjectModel("config", "value", "resolver", DeploymentDescriptorViewTest.getParameters())));
    }

    private static List<Parameter> getParameters() {
        return Collections.singletonList(new Parameter(UUID.randomUUID().toString(), Integer.toString(random.nextInt(100000))));
    }

    @Test
    public void setContent() {
        this.view.setContent(this.deploymentDescriptorModel);
        ((TextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)this.textBoxUsages))).setText((String)Matchers.any(String.class));
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)this.listBoxUsages))).getItemCount();
        ((CheckBox)Mockito.verify((Object)this.checkBox, (VerificationMode)Mockito.times((int)this.checkBoxUsages))).setValue(Boolean.valueOf(Matchers.anyBoolean()));
        String[] listNames = new String[]{"RemotableClasses", "Configuration", "EnvironmentEntries", "EventListeners", "Globals", "MarshallingStrategies", "RequiredRoles", "TaskEventListeners", "WorkItemHandlers"};
        List[][] listListArr = new List[][]{{this.deploymentDescriptorModel.getConfiguration(), this.view.configurationDataProvider.getList()}, {this.deploymentDescriptorModel.getEnvironmentEntries(), this.view.environmentEntriesDataProvider.getList()}, {this.deploymentDescriptorModel.getEventListeners(), this.view.eventListenersDataProvider.getList()}, {this.deploymentDescriptorModel.getGlobals(), this.view.globalsDataProvider.getList()}, {this.deploymentDescriptorModel.getMarshallingStrategies(), this.view.marshalStrategyDataProvider.getList()}, {this.deploymentDescriptorModel.getRemotableClasses(), this.view.remoteableClassesDataProvider.getList()}, {this.deploymentDescriptorModel.getRequiredRoles(), this.view.requiredRolesDataProvider.getList()}, {this.deploymentDescriptorModel.getTaskEventListeners(), this.view.taskEventListenersDataProvider.getList()}, {this.deploymentDescriptorModel.getWorkItemHandlers(), this.view.workItemHandlersDataProvider.getList()}};
        for (int i = 0; i < listListArr.length; ++i) {
            Assert.assertEquals((String)(listNames[i] + " size"), (long)listListArr[i][0].size(), (long)listListArr[i][1].size());
            Assert.assertEquals((String)(listNames[i] + " value"), listListArr[i][0].get(0), listListArr[i][1].get(0));
        }
    }

    @Test
    public void updateContent() {
        this.view.configurationDataProvider.setList(this.deploymentDescriptorModel.getConfiguration());
        this.view.environmentEntriesDataProvider.setList(this.deploymentDescriptorModel.getEnvironmentEntries());
        this.view.eventListenersDataProvider.setList(this.deploymentDescriptorModel.getEventListeners());
        this.view.globalsDataProvider.setList(this.deploymentDescriptorModel.getGlobals());
        this.view.marshalStrategyDataProvider.setList(this.deploymentDescriptorModel.getMarshallingStrategies());
        this.view.remoteableClassesDataProvider.setList(this.deploymentDescriptorModel.getRemotableClasses());
        this.view.requiredRolesDataProvider.setList(this.deploymentDescriptorModel.getRequiredRoles());
        this.view.taskEventListenersDataProvider.setList(this.deploymentDescriptorModel.getTaskEventListeners());
        this.view.workItemHandlersDataProvider.setList(this.deploymentDescriptorModel.getWorkItemHandlers());
        DeploymentDescriptorModel newModel = new DeploymentDescriptorModel();
        this.view.updateContent(newModel);
        ((TextBox)Mockito.verify((Object)this.textBox, (VerificationMode)Mockito.times((int)this.textBoxUsages))).getText();
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)this.listBoxUsages))).getSelectedIndex();
        ((CheckBox)Mockito.verify((Object)this.checkBox, (VerificationMode)Mockito.times((int)this.checkBoxUsages))).getValue();
        Assert.assertFalse((boolean)newModel.getConfiguration().isEmpty());
        Assert.assertFalse((boolean)newModel.getEnvironmentEntries().isEmpty());
        Assert.assertFalse((boolean)newModel.getEventListeners().isEmpty());
        Assert.assertFalse((boolean)newModel.getGlobals().isEmpty());
        Assert.assertFalse((boolean)newModel.getMarshallingStrategies().isEmpty());
        Assert.assertFalse((boolean)newModel.getRemotableClasses().isEmpty());
        Assert.assertFalse((boolean)newModel.getRequiredRoles().isEmpty());
        Assert.assertFalse((boolean)newModel.getTaskEventListeners().isEmpty());
        Assert.assertFalse((boolean)newModel.getWorkItemHandlers().isEmpty());
    }

    @Test
    public void changeDefaultLimitSerializationClassesValueToTrueIn7x() throws Exception {
        Properties props = new Properties();
        String testPropsFileName = "test.properties";
        InputStream testPropsStream = this.getClass().getResourceAsStream("/" + testPropsFileName);
        Assert.assertNotNull((String)("Unable to find or open " + testPropsFileName), (Object)testPropsFileName);
        props.load(testPropsStream);
        String projectVersionStr = (String)props.get("project.version");
        Matcher matcher = jarLocRegex.matcher(projectVersionStr);
        Assert.assertTrue((String)"Fix regular expression: ([\\d\\.]{3})\\S*", (boolean)matcher.matches());
        double jarVersion = Double.parseDouble(matcher.group(1));
        DeploymentDescriptorViewImpl viewImpl = new DeploymentDescriptorViewImpl();
        this.deploymentDescriptorModel.setLimitSerializationClasses(null);
        viewImpl.setContent(this.deploymentDescriptorModel);
        boolean limitSerializationClasses = DeploymentDescriptorViewImpl.getLimitSerializationClassesCheckBoxValue((DeploymentDescriptorModel)this.deploymentDescriptorModel);
        Assert.assertTrue((String)"The default value of 'limitSerializationClasses is FALSE in 6.x and TRUE in 7.x", (jarVersion < 7.0 && !limitSerializationClasses || jarVersion >= 7.0 && limitSerializationClasses ? 1 : 0) != 0);
    }

    @Test
    public void runtimeStrategiesSetting() throws Exception {
        String itemName = "item1_name";
        String itemValue = "item1_value";
        this.view.addPersistenceMode(itemName, itemValue);
        this.view.addAuditMode(itemName, itemValue);
        this.view.addRuntimeStrategy(itemName, itemValue);
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)3))).addItem(itemName, itemValue);
    }
}

