/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.wi.casemgmt.service.CaseProjectService;
import org.jbpm.workbench.wi.client.handlers.NewCaseProjectHandler;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.library.client.screens.project.AddProjectPopUpPresenter;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mocks.MockInstanceImpl;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewCaseProjectHandlerTest {
    @Mock
    CaseProjectService caseProjectService;
    Caller<CaseProjectService> caseProjectServiceCaller;
    @Spy
    Event<NotificationEvent> notification = new EventSourceMock();
    @Spy
    Instance<AddProjectPopUpPresenter> addProjectPopUpPresenterProvider = new MockInstanceImpl((Object[])new AddProjectPopUpPresenter[0]);
    @InjectMocks
    NewCaseProjectHandler newCaseProjectHandler;

    @Before
    public void setup() {
        this.caseProjectServiceCaller = new CallerMock((Object)this.caseProjectService);
        this.newCaseProjectHandler.setCaseProjectService(this.caseProjectServiceCaller);
        this.newCaseProjectHandler.setNotification(this.notification);
        ((Event)Mockito.doNothing().when(this.notification)).fire(Matchers.any());
    }

    @Test
    public void testNewCaseProject() {
        WorkspaceProject project = (WorkspaceProject)Mockito.mock(WorkspaceProject.class);
        ParameterizedCommand creationSuccessCallback = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        AddProjectPopUpPresenter addProjectPopUpPresenterMock = (AddProjectPopUpPresenter)Mockito.mock(AddProjectPopUpPresenter.class);
        Mockito.when((Object)this.addProjectPopUpPresenterProvider.get()).thenReturn((Object)addProjectPopUpPresenterMock);
        Mockito.when((Object)addProjectPopUpPresenterMock.getProjectCreationSuccessCallback()).thenReturn((Object)creationSuccessCallback);
        ((AddProjectPopUpPresenter)Mockito.doAnswer(invocation -> {
            ((ParameterizedCommand)invocation.getArguments()[0]).execute((Object)project);
            return null;
        }).when((Object)addProjectPopUpPresenterMock)).setSuccessCallback((ParameterizedCommand)Matchers.any());
        Callback successCallback = (Callback)Mockito.mock(Callback.class);
        this.newCaseProjectHandler.setCreationSuccessCallback(successCallback);
        this.newCaseProjectHandler.init();
        ((AddProjectPopUpPresenter)Mockito.verify((Object)addProjectPopUpPresenterMock)).setSuccessCallback((ParameterizedCommand)Matchers.any());
        ((AddProjectPopUpPresenter)Mockito.verify((Object)addProjectPopUpPresenterMock)).show();
        ((CaseProjectService)Mockito.verify((Object)this.caseProjectService)).configureNewCaseProject(project);
        ((Callback)Mockito.verify((Object)successCallback)).callback((Object)project);
        ((ParameterizedCommand)Mockito.verify((Object)creationSuccessCallback)).execute((Object)project);
        ((Event)Mockito.verify(this.notification)).fire(Matchers.any());
        ((Instance)Mockito.verify(this.addProjectPopUpPresenterProvider)).destroy((Object)addProjectPopUpPresenterMock);
    }
}

