/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Form;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.base.form.AbstractForm;
import org.gwtbootstrap3.client.ui.constants.FormType;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskUploadFormView;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.FileUpload;
import org.uberfire.ext.widgets.common.client.common.FormStyleLayout;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;

public class ServiceTaskUploadFormViewImpl
extends BaseModal
implements ServiceTaskUploadFormView {
    private static final String FORM_ELEMENT_SERVICE_TASK_ULOAD = "fileServiceTaskUploadElement";
    private FormStyleLayout form = new FormStyleLayout();
    private ServiceTaskUploadFormView.Presenter presenter;
    protected FileUpload uploader;

    public ServiceTaskUploadFormViewImpl() {
        this.setTitle(Constants.INSTANCE.ServiceTaskUpload());
        this.setBody((Widget)this.doUploadForm());
        ModalFooter footer = new ModalFooter();
        Button cancelButton = new Button(Constants.INSTANCE.Cancel());
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ServiceTaskUploadFormViewImpl.this.hide();
            }
        });
        footer.add((Widget)cancelButton);
        this.add((Widget)footer);
    }

    private Form doUploadForm() {
        this.form.setAction(this.getWebContext() + "/jbpm/servicetasks");
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.form.setType(FormType.HORIZONTAL);
        this.form.addSubmitCompleteHandler(new AbstractForm.SubmitCompleteHandler(){

            public void onSubmitComplete(AbstractForm.SubmitCompleteEvent event) {
                ServiceTaskUploadFormViewImpl.this.presenter.handleSubmitComplete(event);
            }
        });
        this.uploader = new FileUpload(() -> {
            if (this.presenter.isFileNameValid()) {
                this.form.submit();
            }
        });
        this.uploader.setName(FORM_ELEMENT_SERVICE_TASK_ULOAD);
        this.form.addAttribute("File", (IsWidget)this.uploader);
        return this.form;
    }

    private String getWebContext() {
        String context = GWT.getModuleBaseURL().replace(GWT.getModuleName() + "/", "");
        if (context.endsWith("/")) {
            context = context.substring(0, context.length() - 1);
        }
        return context;
    }

    public void init(ServiceTaskUploadFormView.Presenter presenter) {
        this.presenter = presenter;
        this.addHideHandler(evt -> this.presenter.onCloseCommand().execute());
    }

    @Override
    public void showUploadingBusy() {
        BusyPopup.showMessage((String)Constants.INSTANCE.Uploading());
    }

    @Override
    public void hideUploadingBusy() {
        BusyPopup.close();
    }

    @Override
    public void showSelectFileUploadWarning() {
        this.showErrorMessage(Constants.INSTANCE.SelectFileUpload());
    }

    @Override
    public void showUnsupportedFileTypeWarning() {
        this.showErrorMessage(Constants.INSTANCE.UnsupportedFileType());
    }

    @Override
    public void showInvalidJarNoPomWarning() {
        this.showErrorMessage(Constants.INSTANCE.InvalidJarNotPom());
    }

    @Override
    public void showInvalidPomWarning() {
        this.showErrorMessage(Constants.INSTANCE.InvalidPom());
    }

    @Override
    public void showUploadFailedError() {
        this.showErrorMessage(Constants.INSTANCE.UploadFailed() + Constants.INSTANCE.InternalUploadError());
    }

    @Override
    public String getFileName() {
        return this.uploader.getFilename();
    }

    @Override
    public String getSuccessInstallMessage() {
        return Constants.INSTANCE.AddTaskSuccess();
    }

    private void showErrorMessage(String message) {
        ErrorPopup.showMessage((String)message);
    }
}

