/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.jbpm.workbench.wi.client.workitem.ServiceTaskUploadFormPresenter;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.jbpm.workbench.wi.workitems.model.ServiceTasksConfiguration;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;

@Dependent
@WorkbenchScreen(identifier="ServiceTasksRepositoryPreferences")
public class ServiceTasksRepositoryListPresenter {
    public static final String SCREEN_ID = "ServiceTasksRepositoryPreferences";
    private Caller<ServiceTaskService> serviceTaskService;
    private Constants constants = Constants.INSTANCE;
    @Inject
    protected ServiceTasksRepositoryListView view;
    @Inject
    protected SyncBeanManager iocManager;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.ServiceTaskList();
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.retrieveConfig();
        this.refreshData();
    }

    @WorkbenchPartView
    public ServiceTasksRepositoryListView getView() {
        return this.view;
    }

    protected void refreshData() {
        ((ServiceTaskService)this.serviceTaskService.call(serviceTasks -> this.view.setServiceTaskList((List<ServiceTaskSummary>)serviceTasks))).getServiceTasks();
    }

    protected void retrieveConfig() {
        ((ServiceTaskService)this.serviceTaskService.call(configuration -> this.view.setConfiguration((ServiceTasksConfiguration)configuration))).getConfiguration();
    }

    protected void saveConfiguration(ServiceTasksConfiguration configuration) {
        ((ServiceTaskService)this.serviceTaskService.call()).saveConfiguration(configuration);
    }

    public void enableService(String id) {
        ((ServiceTaskService)this.serviceTaskService.call()).enableServiceTask(id);
    }

    public void disableService(String id) {
        ((ServiceTaskService)this.serviceTaskService.call()).disableServiceTask(id);
    }

    public void openUploadDialog() {
        ServiceTaskUploadFormPresenter uploadFormPresenter = (ServiceTaskUploadFormPresenter)this.iocManager.lookupBean(ServiceTaskUploadFormPresenter.class, new Annotation[0]).newInstance();
        uploadFormPresenter.showView(() -> this.refreshData());
    }

    @Inject
    public void setServiceTaskService(Caller<ServiceTaskService> serviceTaskService) {
        this.serviceTaskService = serviceTaskService;
    }

    public static interface ServiceTasksRepositoryListView
    extends UberElement<ServiceTasksRepositoryListPresenter> {
        public void setServiceTaskList(List<ServiceTaskSummary> var1);

        public void setConfiguration(ServiceTasksConfiguration var1);
    }
}

