/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jbpm.workbench.wi.client.workitem.ServiceTasksRepositoryListPresenter;
import org.jbpm.workbench.wi.workitems.model.ServiceTaskSummary;
import org.jbpm.workbench.wi.workitems.service.ServiceTaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.popups.alert.AlertPopupView;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class ServiceTasksRepositoryListPresenterTest {
    private static final String TEST_ST_NAME = "test1";
    private static final String TEST_ST_ID = "1";
    private CallerMock<ServiceTaskService> serviceTaskServiceCallerMock;
    @Mock
    private ServiceTaskService serviceTaskService;
    @Mock
    private EventSourceMock<NotificationEvent> notificationEvent = new EventSourceMock();
    @Mock
    private ConfirmPopup confirmPopup;
    @Mock
    private ServiceTasksRepositoryListPresenter.ServiceTasksRepositoryListView view;
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private AlertPopupView cannotRemovePopup;
    private ServiceTasksRepositoryListPresenter presenter;
    List<ServiceTaskSummary> serviceTaskSummaries = new ArrayList<ServiceTaskSummary>();

    @Before
    public void init() {
        this.serviceTaskSummaries.add(this.initServiceTaskSummary(TEST_ST_NAME, TEST_ST_ID));
        this.serviceTaskSummaries.add(this.initServiceTaskSummary("test2", "2"));
        this.serviceTaskSummaries.add(this.initServiceTaskSummary("test3", "3"));
        this.serviceTaskServiceCallerMock = new CallerMock((Object)this.serviceTaskService);
        this.presenter = (ServiceTasksRepositoryListPresenter)Mockito.spy((Object)new ServiceTasksRepositoryListPresenter(this.notificationEvent, this.view, this.serviceTaskServiceCallerMock, this.iocManager));
        this.presenter.setConfirmPopup(this.confirmPopup);
        this.presenter.setCannotRemovePopup(this.cannotRemovePopup);
        Mockito.when((Object)this.serviceTaskService.getServiceTasks()).thenReturn(this.serviceTaskSummaries);
    }

    private ServiceTaskSummary initServiceTaskSummary(String name, String id) {
        ServiceTaskSummary summary = new ServiceTaskSummary();
        summary.setId(id);
        summary.setName(name);
        return summary;
    }

    @Test
    public void openRemoveServiceTaskConfirmPopupTestWhenCanNotRemove() {
        HashSet<String> installOn = new HashSet<String>();
        installOn.add("branch1");
        installOn.add("branch2");
        ServiceTaskSummary st = this.initServiceTaskSummary(TEST_ST_NAME, TEST_ST_ID);
        st.setInstalledOn(installOn);
        this.presenter.openRemoveServiceTaskConfirmPopup(st);
        ((AlertPopupView)Mockito.verify((Object)this.cannotRemovePopup)).alert((String)Matchers.any(), (String)Matchers.any());
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.never())).removeServiceTask((ServiceTaskSummary)Matchers.any());
        Assert.assertEquals((long)3L, (long)this.serviceTaskSummaries.size());
    }

    @Test
    public void openRemoveServiceTaskConfirmPopupTestWhenCanRemove() {
        ((ServiceTaskService)Mockito.doAnswer(answer -> {
            this.serviceTaskSummaries.remove(0);
            return null;
        }).when((Object)this.serviceTaskService)).removeServiceTask((ServiceTaskSummary)Matchers.any());
        this.verifyConfirmPopup();
        Assert.assertEquals((long)2L, (long)this.serviceTaskSummaries.size());
        Assert.assertFalse((boolean)this.serviceTaskSummaries.stream().filter(s -> s.getId().equals(TEST_ST_ID)).findFirst().isPresent());
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService)).getServiceTasks();
        ((ServiceTasksRepositoryListPresenter.ServiceTasksRepositoryListView)Mockito.verify((Object)this.view)).setServiceTaskList((List)Matchers.eq(this.serviceTaskSummaries));
    }

    @Test
    public void openRemoveServiceTaskConfirmPopupWhenCanRemoveWithNotification() {
        Mockito.when((Object)this.serviceTaskService.removeServiceTask((ServiceTaskSummary)Matchers.any())).thenReturn((Object)TEST_ST_NAME);
        this.verifyConfirmPopup();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire((Object)new NotificationEvent(this.presenter.getRemoveTaskSuccess(TEST_ST_NAME)));
    }

    private void verifyConfirmPopup() {
        HashSet installOn = new HashSet();
        ServiceTaskSummary st = this.initServiceTaskSummary(TEST_ST_NAME, TEST_ST_ID);
        st.setInstalledOn(installOn);
        st.setEnabled(Boolean.valueOf(false));
        this.presenter.openRemoveServiceTaskConfirmPopup(st);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((ConfirmPopup)Mockito.verify((Object)this.confirmPopup)).show((String)Matchers.any(), (String)Matchers.any(), (String)Matchers.any(), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((ServiceTaskService)Mockito.verify((Object)this.serviceTaskService, (VerificationMode)Mockito.times((int)1))).removeServiceTask(st);
    }
}

