/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.workitem.project;

import com.google.gwt.event.dom.client.ClickEvent;
import elemental2.dom.HTMLElement;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.wi.client.i18n.Constants;
import org.jbpm.workbench.wi.client.workitem.project.ProjectServiceTaskItemPresenter;

@Templated(value="#root")
public class ProjectServiceTaskItemView
implements ProjectServiceTaskItemPresenter.View {
    @Inject
    @Named(value="span")
    @DataField(value="icon")
    private HTMLElement icon;
    @Inject
    @Named(value="span")
    @DataField(value="name")
    private HTMLElement name;
    @Inject
    @Named(value="span")
    @DataField(value="additionalInfo")
    private HTMLElement additionalInfo;
    @Inject
    @Named(value="button")
    @DataField(value="action-service-task")
    private HTMLElement actionButton;
    private ProjectServiceTaskItemPresenter presenter;
    private String serviceTaskId;
    private Boolean installed;
    private List<String> parameters;
    private String referenceLink;
    private Constants constants = Constants.INSTANCE;

    @EventHandler(value={"action-service-task"})
    public void onAction(ClickEvent event) {
        if (this.installed.booleanValue()) {
            this.presenter.uninstallServiceTask(this.serviceTaskId, () -> {
                this.makeInstallButton();
                this.installed = false;
            });
        } else {
            this.presenter.installServiceTask(this.serviceTaskId, this.parameters, this.referenceLink, () -> {
                this.makeUninstallButton();
                this.installed = true;
            });
        }
    }

    public void init(ProjectServiceTaskItemPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setIcon(String icon) {
        this.icon.classList.add(icon.split(" "));
    }

    @Override
    public void setName(String name) {
        this.name.textContent = name;
    }

    @Override
    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo.textContent = additionalInfo;
    }

    @Override
    public void setServiceTaskId(String serviceTaskId) {
        this.serviceTaskId = serviceTaskId;
    }

    @Override
    public void setServiceTaskParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setServiceTaskReferenceLink(String link) {
        this.referenceLink = link;
    }

    @Override
    public void setInstalled(Boolean installed) {
        this.installed = installed;
        if (installed.booleanValue()) {
            this.makeUninstallButton();
        } else {
            this.makeInstallButton();
        }
    }

    protected void makeInstallButton() {
        this.actionButton.classList.add(new String[]{"btn-primary"});
        this.actionButton.classList.remove(new String[]{"btn-danger"});
        this.actionButton.textContent = this.constants.InstallServiceTask();
    }

    protected void makeUninstallButton() {
        this.actionButton.classList.remove(new String[]{"btn-primary"});
        this.actionButton.classList.add(new String[]{"btn-danger"});
        this.actionButton.textContent = this.constants.UninstallServiceTask();
    }
}

