/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.items;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentsSectionPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ObjectItemPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ObjectPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ParametersModal;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.Resolver;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.marshallingstrategies.DeploymentsMarshallingStrategiesPresenter;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.model.Parameter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.select.KieEnumSelectElement;
import org.kie.workbench.common.widgets.client.widget.ListItemPresenter;
import org.kie.workbench.common.widgets.client.widget.ListPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ObjectItemPresenterTest {
    @Mock
    private ObjectItemPresenter.View view;
    @Mock
    private ParametersModal parametersModal;
    @Mock
    private KieEnumSelectElement<Resolver> resolversSelect;
    private ObjectItemPresenter objectItemPresenter;

    @Before
    public void before() {
        this.objectItemPresenter = (ObjectItemPresenter)Mockito.spy((Object)new ObjectItemPresenter(this.view, this.parametersModal));
    }

    @Test
    public void testSetup() {
        ItemObjectModel model = (ItemObjectModel)Mockito.spy((Object)new ItemObjectModel(null, "Value", "reflection", (List)ImmutableList.of((Object)new Parameter("Foo", "Bar"))));
        this.objectItemPresenter.setup(model, (Section)Mockito.mock(DeploymentsSectionPresenter.class));
        ((ItemObjectModel)Mockito.verify((Object)model, (VerificationMode)Mockito.never())).setParameters((List)Matchers.any());
        ((ObjectItemPresenter.View)Mockito.verify((Object)this.view)).setupResolverSelect((ItemObjectModel)Matchers.any(), (Section)Matchers.any());
        ((ObjectItemPresenter.View)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.objectItemPresenter));
        ((ObjectItemPresenter.View)Mockito.verify((Object)this.view)).setValue((String)Matchers.eq((Object)"Value"));
        ((ObjectItemPresenter.View)Mockito.verify((Object)this.view)).setParametersCount(Matchers.eq((int)1));
        ((ParametersModal)Mockito.verify((Object)this.parametersModal)).setup((List)Matchers.any(), (ObjectPresenter)Matchers.any());
    }

    @Test
    public void testRemove() {
        DeploymentsSectionPresenter parentPresenter = (DeploymentsSectionPresenter)Mockito.mock(DeploymentsSectionPresenter.class);
        DeploymentsMarshallingStrategiesPresenter.MarshallingStrategiesListPresenter listPresenter = (DeploymentsMarshallingStrategiesPresenter.MarshallingStrategiesListPresenter)Mockito.mock(DeploymentsMarshallingStrategiesPresenter.MarshallingStrategiesListPresenter.class);
        this.objectItemPresenter.parentPresenter = parentPresenter;
        this.objectItemPresenter.setListPresenter((ListPresenter)listPresenter);
        this.objectItemPresenter.remove();
        ((DeploymentsMarshallingStrategiesPresenter.MarshallingStrategiesListPresenter)Mockito.verify((Object)listPresenter)).remove((ListItemPresenter)Matchers.eq((Object)this.objectItemPresenter));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)parentPresenter)).fireChangeEvent();
    }

    @Test
    public void testSignalParameterAddedOrRemoved() {
        DeploymentsSectionPresenter parentPresenter = (DeploymentsSectionPresenter)Mockito.mock(DeploymentsSectionPresenter.class);
        this.objectItemPresenter.parentPresenter = parentPresenter;
        this.objectItemPresenter.model = new ItemObjectModel(null, "Value", "reflection", (List)ImmutableList.of((Object)new Parameter("Foo", "Bar")));
        this.objectItemPresenter.signalParameterAddedOrRemoved();
        ((ObjectItemPresenter.View)Mockito.verify((Object)this.view)).setParametersCount(Matchers.eq((int)1));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)parentPresenter)).fireChangeEvent();
    }
}

