/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor;

import elemental2.dom.HTMLElement;
import elemental2.promise.Promise;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.sections.DeploymentsSections;
import org.jbpm.workbench.wi.dd.model.DeploymentDescriptorModel;
import org.jbpm.workbench.wi.dd.service.DDEditorService;
import org.kie.workbench.common.screens.library.client.settings.SettingsSectionChange;
import org.kie.workbench.common.screens.library.client.settings.util.sections.MenuItem;
import org.kie.workbench.common.screens.library.client.settings.util.sections.Section;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionManager;
import org.kie.workbench.common.screens.library.client.settings.util.sections.SectionView;
import org.kie.workbench.common.screens.projecteditor.model.ProjectScreenModel;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class DeploymentsSectionPresenter
extends Section<ProjectScreenModel> {
    private final View view;
    private final WorkspaceProjectContext projectContext;
    private final Caller<DDEditorService> ddEditorService;
    private final ManagedInstance<ObservablePath> observablePaths;
    private final Event<NotificationEvent> notificationEvent;
    private final SectionManager<DeploymentDescriptorModel> sectionManager;
    private final DeploymentsSections deploymentsSections;
    private ObservablePath pathToDeploymentsXml;
    ObservablePath.OnConcurrentUpdateEvent concurrentDeploymentsXmlUpdateInfo;
    DeploymentDescriptorModel model;

    @Inject
    public DeploymentsSectionPresenter(View view, Promises promises, MenuItem<ProjectScreenModel> menuItem, WorkspaceProjectContext projectContext, Caller<DDEditorService> ddEditorService, ManagedInstance<ObservablePath> observablePaths, Event<SettingsSectionChange<ProjectScreenModel>> settingsSectionChangeEvent, Event<NotificationEvent> notificationEvent, SectionManager<DeploymentDescriptorModel> sectionManager, DeploymentsSections deploymentsSections) {
        super(settingsSectionChangeEvent, menuItem, promises);
        this.view = view;
        this.projectContext = projectContext;
        this.ddEditorService = ddEditorService;
        this.observablePaths = observablePaths;
        this.notificationEvent = notificationEvent;
        this.sectionManager = sectionManager;
        this.deploymentsSections = deploymentsSections;
    }

    @PostConstruct
    public void init() {
        this.sectionManager.init(this.deploymentsSections.getList(), this.view.getMenuItemsContainer(), this.view.getContentContainer());
    }

    public Promise<Void> setup(ProjectScreenModel ignore) {
        return this.setup();
    }

    Promise<Void> setup() {
        this.view.init((Object)this);
        String deploymentsXmlUri = ((WorkspaceProject)this.projectContext.getActiveWorkspaceProject().get()).getRootPath().toURI() + "src/main/resources/META-INF/kie-deployment-descriptor.xml";
        this.pathToDeploymentsXml = ((ObservablePath)this.observablePaths.get()).wrap(PathFactory.newPath((String)"kie-deployment-descriptor.xml", (String)deploymentsXmlUri));
        this.concurrentDeploymentsXmlUpdateInfo = null;
        this.pathToDeploymentsXml.onConcurrentUpdate(info -> {
            this.concurrentDeploymentsXmlUpdateInfo = info;
        });
        return this.createIfNotExists().then(i -> this.loadDeploymentDescriptor()).then(model -> {
            this.model = model;
            return this.promises.all(this.deploymentsSections.getList(), section -> section.setup(model));
        }).then(i -> {
            this.sectionManager.resetAllDirtyIndicators();
            return this.sectionManager.goToCurrentSection();
        });
    }

    Promise<DeploymentDescriptorModel> loadDeploymentDescriptor() {
        return this.promises.promisify(this.ddEditorService, s -> s.load((Path)this.pathToDeploymentsXml));
    }

    Promise<Void> createIfNotExists() {
        return this.promises.promisify(this.ddEditorService, s -> s.createIfNotExists((Path)this.pathToDeploymentsXml));
    }

    public Promise<Void> save(String comment, Supplier<Promise<Void>> chain) {
        if (this.concurrentDeploymentsXmlUpdateInfo != null) {
            this.notificationEvent.fire((Object)new NotificationEvent(this.view.getConcurrentUpdateMessage(), NotificationEvent.NotificationType.WARNING));
            return this.setup();
        }
        return this.save(comment).then(i -> {
            this.sectionManager.resetAllDirtyIndicators();
            return this.promises.resolve();
        });
    }

    Promise<Void> save(String comment) {
        return this.promises.promisify(this.ddEditorService, s -> s.save((Path)this.pathToDeploymentsXml, (Object)this.model, this.model.getOverview().getMetadata(), comment));
    }

    public void onSectionChanged(@Observes SettingsSectionChange<DeploymentDescriptorModel> settingsSectionChange) {
        if (!this.sectionManager.manages(settingsSectionChange.getSection())) {
            return;
        }
        this.sectionManager.updateDirtyIndicator(settingsSectionChange.getSection());
        this.fireChangeEvent();
    }

    public int currentHashCode() {
        return this.model.hashCode();
    }

    public SectionView<?> getView() {
        return this.view;
    }

    public static interface View
    extends SectionView<DeploymentsSectionPresenter> {
        public String getConcurrentUpdateMessage();

        public HTMLElement getMenuItemsContainer();

        public HTMLElement getContentContainer();
    }
}

