/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.wi.client.editors.deployment.descriptor.items;

import com.google.common.collect.ImmutableList;
import elemental2.dom.Element;
import java.util.List;
import java.util.function.Consumer;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.DeploymentsSectionPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.NamedObjectItemPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ObjectPresenter;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.items.ParametersModal;
import org.jbpm.workbench.wi.client.editors.deployment.descriptor.model.Resolver;
import org.jbpm.workbench.wi.dd.model.ItemObjectModel;
import org.jbpm.workbench.wi.dd.model.Parameter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.library.client.settings.util.KieEnumSelectElement;
import org.kie.workbench.common.screens.library.client.settings.util.ListItemPresenter;
import org.kie.workbench.common.screens.library.client.settings.util.ListPresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NamedObjectItemPresenterTest {
    @Mock
    private NamedObjectItemPresenter.View view;
    @Mock
    private ParametersModal parametersModal;
    @Mock
    private KieEnumSelectElement<Resolver> resolversSelect;
    private NamedObjectItemPresenter namedObjectItemPresenter;

    @Before
    public void before() {
        this.namedObjectItemPresenter = (NamedObjectItemPresenter)Mockito.spy((Object)new NamedObjectItemPresenter(this.view, this.parametersModal, this.resolversSelect));
    }

    @Test
    public void testSetup() {
        ItemObjectModel model = (ItemObjectModel)Mockito.spy((Object)new ItemObjectModel("Name", "Value", "mvel", (List)ImmutableList.of((Object)new Parameter("Foo", "Bar"))));
        this.namedObjectItemPresenter.setup(model, (DeploymentsSectionPresenter)Mockito.mock(DeploymentsSectionPresenter.class));
        ((ItemObjectModel)Mockito.verify((Object)model, (VerificationMode)Mockito.never())).setParameters((List)Matchers.any());
        ((NamedObjectItemPresenter.View)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.namedObjectItemPresenter));
        ((NamedObjectItemPresenter.View)Mockito.verify((Object)this.view)).setValue((String)Matchers.eq((Object)"Value"));
        ((NamedObjectItemPresenter.View)Mockito.verify((Object)this.view)).setName((String)Matchers.eq((Object)"Name"));
        ((NamedObjectItemPresenter.View)Mockito.verify((Object)this.view)).setParametersCount(Matchers.eq((int)1));
        ((ParametersModal)Mockito.verify((Object)this.parametersModal)).setup((List)Matchers.any(), (ObjectPresenter)Matchers.any());
        ((KieEnumSelectElement)Mockito.verify(this.resolversSelect)).setup((Element)Matchers.any(), (Enum[])Matchers.any(), (Enum)Matchers.eq((Object)Resolver.MVEL), (Consumer)Matchers.any());
    }

    @Test
    public void testRemove() {
        DeploymentsSectionPresenter parentPresenter = (DeploymentsSectionPresenter)Mockito.mock(DeploymentsSectionPresenter.class);
        DeploymentsSectionPresenter.MarshallingStrategiesListPresenter listPresenter = (DeploymentsSectionPresenter.MarshallingStrategiesListPresenter)Mockito.mock(DeploymentsSectionPresenter.MarshallingStrategiesListPresenter.class);
        this.namedObjectItemPresenter.parentPresenter = parentPresenter;
        this.namedObjectItemPresenter.setListPresenter((ListPresenter)listPresenter);
        this.namedObjectItemPresenter.remove();
        ((DeploymentsSectionPresenter.MarshallingStrategiesListPresenter)Mockito.verify((Object)listPresenter)).remove((ListItemPresenter)Matchers.eq((Object)this.namedObjectItemPresenter));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)parentPresenter)).fireChangeEvent();
    }

    @Test
    public void testSignalParameterAddedOrRemoved() {
        DeploymentsSectionPresenter parentPresenter;
        this.namedObjectItemPresenter.parentPresenter = parentPresenter = (DeploymentsSectionPresenter)Mockito.mock(DeploymentsSectionPresenter.class);
        this.namedObjectItemPresenter.model = new ItemObjectModel("Name", "Value", "mvel", (List)ImmutableList.of((Object)new Parameter("Foo", "Bar")));
        this.namedObjectItemPresenter.signalParameterAddedOrRemoved();
        ((NamedObjectItemPresenter.View)Mockito.verify((Object)this.view)).setParametersCount(Matchers.eq((int)1));
        ((DeploymentsSectionPresenter)Mockito.verify((Object)parentPresenter)).fireChangeEvent();
    }
}

