/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.jbpm.workbench.ks.utils.KieServerUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class KieServerIntegration {
    private static final Logger logger = LoggerFactory.getLogger(KieServerIntegration.class);
    private KieServices kieServices;
    private ConcurrentMap<String, KieServicesClient> serverTemplatesClients = new ConcurrentHashMap<String, KieServicesClient>();
    private ConcurrentMap<String, KieServicesClient> adminClients = new ConcurrentHashMap<String, KieServicesClient>();
    private ConcurrentMap<String, ServerInstanceKey> serverInstancesById = new ConcurrentHashMap<String, ServerInstanceKey>();
    @Inject
    private SpecManagementService specManagementService;
    @Inject
    private Event<ServerInstanceRegistered> serverInstanceRegisteredEvent;

    @PostConstruct
    public void createAvailableClients() {
        this.kieServices = KieServices.Factory.get();
        Collection serverTemplates = this.specManagementService.listServerTemplates();
        logger.debug("Found {} server templates, creating clients for them...", (Object)serverTemplates.size());
        serverTemplates.forEach(serverTemplate -> this.buildClientsForServer((ServerTemplate)serverTemplate));
    }

    public KieServicesClient getServerClient(String serverTemplateId) {
        return (KieServicesClient)this.serverTemplatesClients.get(serverTemplateId);
    }

    public KieServicesClient getServerClient(String serverTemplateId, String containerId) {
        return (KieServicesClient)this.serverTemplatesClients.get(serverTemplateId + "|" + containerId);
    }

    public KieServicesClient getAdminServerClient(String serverTemplateId) {
        return (KieServicesClient)this.adminClients.get(serverTemplateId);
    }

    public KieServicesClient getAdminServerClientCheckEndpoints(String serverTemplateId) {
        KieServicesClient adminClient = (KieServicesClient)this.adminClients.get(serverTemplateId);
        if (adminClient != null) {
            LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)adminClient).getLoadBalancer();
            loadBalancer.checkFailedEndpoints();
        }
        return adminClient;
    }

    protected void indexServerInstances(ServerTemplate serverTemplate) {
        for (ServerInstanceKey serverInstanceKey : serverTemplate.getServerInstanceKeys()) {
            this.serverInstancesById.put(serverInstanceKey.getServerInstanceId(), serverInstanceKey);
        }
    }

    protected void removeServerInstancesFromIndex(String serverTemplateId) {
        Iterator iterator = this.serverInstancesById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((ServerInstanceKey)entry.getValue()).getServerTemplateId().equals(serverTemplateId)) continue;
            iterator.remove();
        }
    }

    public void onServerTemplateDeleted(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        this.buildClientsForServer(serverTemplateUpdated.getServerTemplate());
    }

    public void onServerTemplateDeleted(@Observes ServerTemplateDeleted serverTemplateDeleted) {
        Iterator iterator = this.serverTemplatesClients.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).startsWith(serverTemplateDeleted.getServerTemplateId())) continue;
            logger.debug("KieServerClient removed and closed for server template {}", entry.getKey());
            iterator.remove();
        }
        this.adminClients.remove(serverTemplateDeleted.getServerTemplateId());
        this.removeServerInstancesFromIndex(serverTemplateDeleted.getServerTemplateId());
    }

    public void onServerInstanceDisconnected(@Observes ServerInstanceDisconnected serverInstanceDisconnected) {
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)this.serverInstancesById.get(serverInstanceDisconnected.getServerInstanceId());
        if (serverInstanceKey != null) {
            for (Map.Entry entry : this.serverTemplatesClients.entrySet()) {
                if (!((String)entry.getKey()).startsWith(serverInstanceKey.getServerTemplateId())) continue;
                KieServicesClient client = (KieServicesClient)entry.getValue();
                if (client != null) {
                    LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)client).getLoadBalancer();
                    loadBalancer.markAsFailed(serverInstanceKey.getUrl());
                    logger.debug("Server instance {} for server template {} removed from client thus won't be used for operations", (Object)serverInstanceKey.getUrl(), (Object)serverInstanceKey.getServerTemplateId());
                }
                logger.debug("KieServerClient load balancer updated for server template {}", entry.getKey());
            }
            this.serverInstancesById.remove(serverInstanceKey.getServerInstanceId());
            KieServicesClient adminClient = (KieServicesClient)this.adminClients.get(serverInstanceKey.getServerTemplateId());
            if (adminClient != null) {
                LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)adminClient).getLoadBalancer();
                loadBalancer.markAsFailed(serverInstanceKey.getUrl());
                logger.debug("Server instance {} for server template {} removed from client thus won't be used for operations", (Object)serverInstanceKey.getUrl(), (Object)serverInstanceKey.getServerTemplateId());
            }
        }
    }

    public void onServerInstanceConnected(@Observes ServerInstanceConnected serverInstanceConnected) {
        ServerInstance serverInstance = serverInstanceConnected.getServerInstance();
        for (Map.Entry entry : this.serverTemplatesClients.entrySet()) {
            if (!((String)entry.getKey()).startsWith(serverInstance.getServerTemplateId())) continue;
            KieServicesClient client = (KieServicesClient)entry.getValue();
            this.updateOrBuildClient(client, serverInstance);
            logger.debug("KieServerClient load balancer updated for server template {}", entry.getKey());
        }
        KieServicesClient adminClient = (KieServicesClient)this.adminClients.get(serverInstance.getServerTemplateId());
        this.updateOrBuildClient(adminClient, serverInstance);
        this.serverInstanceRegisteredEvent.fire((Object)new ServerInstanceRegistered(serverInstanceConnected.getServerInstance()));
    }

    protected void updateOrBuildClient(KieServicesClient client, ServerInstance serverInstance) {
        if (client != null) {
            LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)client).getLoadBalancer();
            loadBalancer.activate(serverInstance.getUrl());
            logger.debug("Server instance {} for server template {} activated on client thus will be used for operations", (Object)serverInstance.getUrl(), (Object)serverInstance.getServerTemplateId());
        } else {
            logger.debug("No kie server client yet created, attempting to create one for server template {}", (Object)serverInstance.getServerTemplateId());
            ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverInstance.getServerTemplateId());
            this.buildClientsForServer(serverTemplate);
        }
    }

    protected void buildClientsForServer(ServerTemplate serverTemplate) {
        KieServicesClient adminKieServicesClient;
        KieServicesClient kieServicesClient = this.createClientForTemplate(serverTemplate, null, KieServerUtils.getCredentialsProvider());
        if (kieServicesClient != null) {
            this.serverTemplatesClients.put(serverTemplate.getId(), kieServicesClient);
        }
        if (serverTemplate.getContainersSpec() != null) {
            for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
                try {
                    String key = serverTemplate.getId() + "|" + containerSpec.getId();
                    if (this.serverTemplatesClients.containsKey(key)) {
                        logger.debug("KieServerClient for {} is already created", (Object)key);
                        continue;
                    }
                    KieContainer kieContainer = this.kieServices.newKieContainer((ReleaseId)containerSpec.getReleasedId());
                    KieServicesClient kieServicesClientForContainer = this.createClientForTemplate(serverTemplate, kieContainer.getClassLoader(), KieServerUtils.getCredentialsProvider());
                    if (kieServicesClient == null) continue;
                    this.serverTemplatesClients.put(key, kieServicesClientForContainer);
                }
                catch (Exception e) {
                    logger.warn("Failed ot create kie server client for container {} due to {}", (Object)containerSpec.getId(), (Object)e.getMessage());
                }
            }
        }
        if ((adminKieServicesClient = this.createClientForTemplate(serverTemplate, null, KieServerUtils.getAdminCredentialsProvider())) != null) {
            this.adminClients.put(serverTemplate.getId(), adminKieServicesClient);
        }
    }

    protected KieServicesClient createClientForTemplate(ServerTemplate serverTemplate, ClassLoader classLoader, CredentialsProvider credentialsProvider) {
        if (serverTemplate.getServerInstanceKeys() == null || serverTemplate.getServerInstanceKeys().isEmpty()) {
            return null;
        }
        try {
            StringBuilder endpoints = new StringBuilder();
            for (ServerInstanceKey serverInstanceKey : serverTemplate.getServerInstanceKeys()) {
                endpoints.append(serverInstanceKey.getUrl() + "|");
            }
            endpoints.deleteCharAt(endpoints.length() - 1);
            logger.debug("Creating client that will use following list of endpoints {}", (Object)endpoints);
            ArrayList<String> mappedCapabilities = new ArrayList<String>();
            if (serverTemplate.getCapabilities().contains(Capability.PROCESS.name())) {
                mappedCapabilities.add("BPM");
                mappedCapabilities.add("BPM-UI");
                mappedCapabilities.add("CaseMgmt");
            }
            if (serverTemplate.getCapabilities().contains(Capability.RULE.name())) {
                mappedCapabilities.add("BRM");
            }
            if (serverTemplate.getCapabilities().contains(Capability.PLANNING.name())) {
                mappedCapabilities.add("BRP");
            }
            KieServicesClient kieServicesClient = KieServerUtils.createKieServicesClient((String)endpoints.toString(), (ClassLoader)classLoader, (CredentialsProvider)credentialsProvider, (String[])mappedCapabilities.toArray(new String[mappedCapabilities.size()]));
            logger.debug("KieServerClient created successfully for server template {}", (Object)serverTemplate);
            this.indexServerInstances(serverTemplate);
            return kieServicesClient;
        }
        catch (Exception e) {
            logger.error("Unable to create kie server client for server template {} due to {}", new Object[]{serverTemplate, e.getMessage(), e});
            return null;
        }
    }
}

