/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.jbpm.workbench.ks.utils.KieServerUtils;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.balancer.LoadBalancer;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.impl.client.KieServicesClientProvider;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class KieServerIntegration {
    private static final Logger logger = LoggerFactory.getLogger(KieServerIntegration.class);
    protected static final String SERVER_TEMPLATE_KEY = "_SERVER_TEMPLATE_MAIN_CLIENT_";
    private KieServices kieServices;
    private ConcurrentMap<String, Map<String, KieServicesClient>> serverTemplatesClients = new ConcurrentHashMap<String, Map<String, KieServicesClient>>();
    private ConcurrentMap<String, KieServicesClient> adminClients = new ConcurrentHashMap<String, KieServicesClient>();
    private ConcurrentMap<String, ServerInstanceKey> serverInstancesById = new ConcurrentHashMap<String, ServerInstanceKey>();
    private List<KieServicesClientProvider> clientProviders = new ArrayList<KieServicesClientProvider>();
    private List<KieServicesClientProvider> allClientProviders = new ArrayList<KieServicesClientProvider>();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    @Inject
    private SpecManagementService specManagementService;
    @Inject
    private Event<ServerInstanceRegistered> serverInstanceRegisteredEvent;

    @PostConstruct
    public void createAvailableClients() {
        this.executorService.submit(() -> {
            ServiceLoader<KieServicesClientProvider> loader = ServiceLoader.load(KieServicesClientProvider.class);
            loader.forEach(provider -> {
                if (!provider.supports("http")) {
                    this.clientProviders.add((KieServicesClientProvider)provider);
                }
                this.allClientProviders.add((KieServicesClientProvider)provider);
            });
            this.clientProviders.sort((one, two) -> one.getPriority().compareTo(two.getPriority()));
            this.kieServices = KieServices.Factory.get();
            ServerTemplateList serverTemplates = this.specManagementService.listServerTemplates();
            logger.debug("Found {} server templates, creating clients for them...", (Object)serverTemplates.getServerTemplates().length);
            for (ServerTemplate serverTemplate : serverTemplates.getServerTemplates()) {
                this.buildClientsForServer(serverTemplate);
            }
        });
    }

    @PreDestroy
    public void stop() {
        this.executorService.shutdownNow();
    }

    protected void setKieServices(KieServices kieServices) {
        this.kieServices = kieServices;
    }

    public KieServicesClient getServerClient(String serverTemplateId) {
        return (KieServicesClient)this.serverTemplatesClients.getOrDefault(serverTemplateId, Collections.emptyMap()).get(SERVER_TEMPLATE_KEY);
    }

    public KieServicesClient getServerClient(String serverTemplateId, String containerId) {
        KieServicesClient client = (KieServicesClient)this.serverTemplatesClients.getOrDefault(serverTemplateId, Collections.emptyMap()).get(containerId);
        if (client == null) {
            logger.warn("Container {} not found in server template {}, returning global kie server client", (Object)containerId, (Object)serverTemplateId);
            client = this.getServerClient(serverTemplateId);
        }
        return client;
    }

    public KieServicesClient getAdminServerClient(String serverTemplateId, String serverInstanceId) {
        try {
            ServerInstanceKey instance = this.specManagementService.getServerTemplate(serverTemplateId).getServerInstanceKeys().stream().filter(si -> si.getServerInstanceId().equals(serverInstanceId)).findFirst().get();
            String url = instance.getUrl();
            KieServicesClient client = this.clientProviders.stream().filter(provider -> provider.supports(url)).findFirst().get().get(url);
            logger.debug("Using client {}", (Object)client);
            return client;
        }
        catch (Exception e) {
            return (KieServicesClient)this.adminClients.get(serverTemplateId);
        }
    }

    public KieServicesClient getAdminServerClientCheckEndpoints(String serverTemplateId) {
        KieServicesClient adminClient = (KieServicesClient)this.adminClients.get(serverTemplateId);
        if (adminClient != null) {
            LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)adminClient).getLoadBalancer();
            loadBalancer.checkFailedEndpoints();
        }
        return adminClient;
    }

    protected void indexServerInstances(ServerTemplate serverTemplate) {
        serverTemplate.getServerInstanceKeys().forEach(serverInstanceKey -> this.serverInstancesById.put(serverInstanceKey.getServerInstanceId(), (ServerInstanceKey)serverInstanceKey));
    }

    protected void removeServerInstancesFromIndex(String serverTemplateId) {
        Iterator iterator = this.serverInstancesById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((ServerInstanceKey)entry.getValue()).getServerTemplateId().equals(serverTemplateId)) continue;
            iterator.remove();
        }
    }

    public void onServerTemplateUpdated(@Observes ServerTemplateUpdated serverTemplateUpdated) {
        this.buildClientsForServer(serverTemplateUpdated.getServerTemplate());
    }

    public void onServerTemplateDeleted(@Observes ServerTemplateDeleted serverTemplateDeleted) {
        Map clients = (Map)this.serverTemplatesClients.remove(serverTemplateDeleted.getServerTemplateId());
        if (clients != null) {
            logger.debug("KieServerClient removed and closed for server template {}", (Object)serverTemplateDeleted.getServerTemplateId());
        }
        this.adminClients.remove(serverTemplateDeleted.getServerTemplateId());
        this.removeServerInstancesFromIndex(serverTemplateDeleted.getServerTemplateId());
    }

    public void onServerInstanceDisconnected(@Observes ServerInstanceDisconnected serverInstanceDisconnected) {
        ServerInstanceKey serverInstanceKey = (ServerInstanceKey)this.serverInstancesById.get(serverInstanceDisconnected.getServerInstanceId());
        if (serverInstanceKey != null) {
            this.serverTemplatesClients.computeIfPresent(serverInstanceKey.getServerTemplateId(), (serverTemplateId, clients) -> {
                clients.forEach((key, client) -> {
                    LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)client).getLoadBalancer();
                    loadBalancer.markAsFailed(serverInstanceKey.getUrl());
                    logger.debug("Server instance '{}' for server template {} removed from client thus won't be used for operations", (Object)serverInstanceKey.getUrl(), (Object)serverInstanceKey.getServerTemplateId());
                    logger.debug("KieServerClient load balancer updated for server template {}", (Object)(serverTemplateId.equals(SERVER_TEMPLATE_KEY) ? serverInstanceKey.getServerTemplateId() : serverTemplateId));
                });
                return clients;
            });
            this.serverInstancesById.remove(serverInstanceKey.getServerInstanceId());
            KieServicesClient adminClient = (KieServicesClient)this.adminClients.get(serverInstanceKey.getServerTemplateId());
            if (adminClient != null) {
                LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)adminClient).getLoadBalancer();
                loadBalancer.markAsFailed(serverInstanceKey.getUrl());
                logger.debug("Server instance {} for server template {} removed from client thus won't be used for operations", (Object)serverInstanceKey.getUrl(), (Object)serverInstanceKey.getServerTemplateId());
            }
        }
    }

    public void onServerInstanceConnected(@Observes ServerInstanceConnected serverInstanceConnected) {
        ServerInstance serverInstance = serverInstanceConnected.getServerInstance();
        this.serverTemplatesClients.computeIfPresent(serverInstance.getServerTemplateId(), (serverTemplateId, clients) -> {
            clients.forEach((key, client) -> {
                this.updateOrBuildClient((KieServicesClient)client, serverInstance);
                logger.debug("KieServerClient load balancer updated for server template {}", (Object)(serverTemplateId.equals(SERVER_TEMPLATE_KEY) ? serverInstance.getServerTemplateId() : serverTemplateId));
            });
            return clients;
        });
        this.serverInstancesById.put(serverInstance.getServerInstanceId(), (ServerInstanceKey)serverInstance);
        KieServicesClient adminClient = (KieServicesClient)this.adminClients.get(serverInstance.getServerTemplateId());
        this.updateOrBuildClient(adminClient, serverInstance);
        this.serverInstanceRegisteredEvent.fire((Object)new ServerInstanceRegistered(serverInstanceConnected.getServerInstance()));
    }

    public List<Object> broadcastToKieServers(String serverTemplateId, Function<KieServicesClient, Object> operation) {
        ArrayList<Object> results = new ArrayList<Object>();
        ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverTemplateId);
        if (serverTemplate.getServerInstanceKeys() == null || serverTemplate.getServerInstanceKeys().isEmpty()) {
            return results;
        }
        for (ServerInstanceKey instanceUrl : serverTemplate.getServerInstanceKeys()) {
            try {
                KieServicesClient client = this.getClient(instanceUrl.getUrl());
                Object result = operation.apply(client);
                results.add(result);
                logger.debug("KIE Server at {} returned result {} for broadcast operation {}", new Object[]{instanceUrl, result, operation});
            }
            catch (Exception e) {
                logger.debug("Unable to send breadcast to {} due to {}", new Object[]{instanceUrl, e.getMessage(), e});
            }
        }
        return results;
    }

    protected KieServicesClient getClient(String url) {
        KieServicesClient client = this.allClientProviders.stream().filter(provider -> provider.supports(url)).findFirst().get().get(url);
        logger.debug("Using client {}", (Object)client);
        return client;
    }

    protected void updateOrBuildClient(KieServicesClient client, ServerInstance serverInstance) {
        if (client != null) {
            LoadBalancer loadBalancer = ((AbstractKieServicesClientImpl)client).getLoadBalancer();
            loadBalancer.activate(serverInstance.getUrl());
            logger.debug("Server instance {} for server template {} activated on client thus will be used for operations", (Object)serverInstance.getUrl(), (Object)serverInstance.getServerTemplateId());
        } else {
            logger.debug("No kie server client yet created, attempting to create one for server template {}", (Object)serverInstance.getServerTemplateId());
            ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverInstance.getServerTemplateId());
            this.buildClientsForServer(serverTemplate);
        }
    }

    protected void buildClientsForServer(ServerTemplate serverTemplate) {
        KieServicesClient adminKieServicesClient;
        KieServicesClient kieServicesClient = this.createClientForTemplate(serverTemplate, null, KieServerUtils.getCredentialsProvider());
        if (kieServicesClient != null) {
            this.serverTemplatesClients.computeIfAbsent(serverTemplate.getId(), k -> new ConcurrentHashMap());
            ((Map)this.serverTemplatesClients.get(serverTemplate.getId())).put(SERVER_TEMPLATE_KEY, kieServicesClient);
        }
        if (serverTemplate.getContainersSpec() != null) {
            for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
                try {
                    if (((Map)this.serverTemplatesClients.get(serverTemplate.getId())).containsKey(containerSpec.getId())) {
                        logger.debug("KieServerClient for {} is already created", (Object)containerSpec.getId());
                        continue;
                    }
                    KieContainer kieContainer = this.kieServices.newKieContainer((ReleaseId)containerSpec.getReleasedId());
                    KieServicesClient kieServicesClientForContainer = this.createClientForTemplate(serverTemplate, kieContainer.getClassLoader(), KieServerUtils.getCredentialsProvider());
                    if (kieServicesClient == null) continue;
                    ((Map)this.serverTemplatesClients.get(serverTemplate.getId())).put(containerSpec.getId(), kieServicesClientForContainer);
                }
                catch (Exception e) {
                    logger.warn("Failed ot create kie server client for container {} due to {}", (Object)containerSpec.getId(), (Object)e.getMessage());
                }
            }
        }
        if ((adminKieServicesClient = this.createClientForTemplate(serverTemplate, null, KieServerUtils.getAdminCredentialsProvider())) != null) {
            this.adminClients.put(serverTemplate.getId(), adminKieServicesClient);
        }
    }

    protected KieServicesClient createClientForTemplate(ServerTemplate serverTemplate, ClassLoader classLoader, CredentialsProvider credentialsProvider) {
        if (serverTemplate.getServerInstanceKeys() == null || serverTemplate.getServerInstanceKeys().isEmpty()) {
            return null;
        }
        try {
            StringBuilder endpoints = new StringBuilder();
            for (ServerInstanceKey serverInstanceKey : serverTemplate.getServerInstanceKeys()) {
                endpoints.append(serverInstanceKey.getUrl() + "|");
            }
            endpoints.deleteCharAt(endpoints.length() - 1);
            logger.debug("Creating client that will use following list of endpoints {}", (Object)endpoints);
            ArrayList<String> mappedCapabilities = new ArrayList<String>();
            if (serverTemplate.getCapabilities().contains(Capability.PROCESS.name())) {
                mappedCapabilities.add("BPM");
                mappedCapabilities.add("BPM-UI");
                mappedCapabilities.add("CaseMgmt");
            }
            if (serverTemplate.getCapabilities().contains(Capability.RULE.name())) {
                mappedCapabilities.add("BRM");
            }
            if (serverTemplate.getCapabilities().contains(Capability.PLANNING.name())) {
                mappedCapabilities.add("BRP");
            }
            KieServicesClient kieServicesClient = KieServerUtils.createKieServicesClient((String)endpoints.toString(), (ClassLoader)classLoader, (CredentialsProvider)credentialsProvider, (String[])mappedCapabilities.toArray(new String[mappedCapabilities.size()]));
            logger.debug("KieServerClient created successfully for server template {}", (Object)serverTemplate.getId());
            this.indexServerInstances(serverTemplate);
            return kieServicesClient;
        }
        catch (Exception e) {
            logger.error("Unable to create kie server client for server template {} due to {}", new Object[]{serverTemplate, e.getMessage(), e});
            return null;
        }
    }

    protected Map<String, Map<String, KieServicesClient>> getServerTemplatesClients() {
        return this.serverTemplatesClients;
    }

    protected Map<String, ServerInstanceKey> getServerInstancesById() {
        return this.serverInstancesById;
    }

    protected void setKieServicesClientProviders(List<KieServicesClientProvider> providers) {
        this.allClientProviders = providers;
    }
}

