/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.jbpm.workbench.ks.events.KieServerDataSetRegistered;
import org.jbpm.workbench.ks.integration.KieServerDataSetManager;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.jbpm.workbench.ks.integration.event.ServerInstanceRegistered;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.common.rest.KieServerHttpRequestException;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class KieServerDataSetManagerTest {
    private final List<Object> receivedEvents = new ArrayList<Object>();
    private DataSetDefRegistry dataSetDefRegistry;
    private KieServerIntegration kieServerIntegration;
    private Event<KieServerDataSetRegistered> event;
    private KieServicesClient kieClient;
    private QueryServicesClient queryClient;
    private KieServerDataSetManager kieServerDataSetManager;
    @Mock
    private SpecManagementService specManagementService;

    @Before
    public void setup() {
        this.dataSetDefRegistry = (DataSetDefRegistry)Mockito.mock(DataSetDefRegistry.class);
        this.kieServerIntegration = (KieServerIntegration)Mockito.mock(KieServerIntegration.class);
        this.event = new EventSourceMock<KieServerDataSetRegistered>(){

            public void fire(KieServerDataSetRegistered event) {
                KieServerDataSetManagerTest.this.receivedEvents.add(event);
            }
        };
        this.kieClient = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        this.queryClient = (QueryServicesClient)Mockito.mock(QueryServicesClient.class);
        Mockito.when((Object)this.kieClient.getServicesClient((Class)Matchers.any())).thenReturn((Object)this.queryClient);
        Mockito.when((Object)this.kieServerIntegration.getAdminServerClient(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.kieClient);
        ExecutorService executorService = Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory());
        this.kieServerDataSetManager = new KieServerDataSetManager(this.dataSetDefRegistry, this.kieServerIntegration, this.event, executorService, this.specManagementService);
    }

    @Test
    public void testRegisterQueriesWithoutRetry() throws Exception {
        QueryDefinition query = QueryDefinition.builder().name("test").expression("expression").source("jbpm").target("CUSTOM").build();
        HashSet<QueryDefinition> definitions = new HashSet<QueryDefinition>();
        definitions.add(query);
        this.kieServerDataSetManager.registerQueriesWithRetry("template", "instance", definitions);
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClient(Matchers.anyString(), Matchers.anyString());
        ((QueryServicesClient)Mockito.verify((Object)this.queryClient, (VerificationMode)Mockito.times((int)1))).replaceQuery((QueryDefinition)Matchers.any());
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
    }

    @Test
    public void testRegisterQueriesWithRetryDueToKieServicesException() throws Exception {
        this.registerQueriesWithRetryException((Exception)new KieServicesException("KieServer still starting"));
    }

    @Test
    public void testRegisterQueriesWithRetryDueToKieRemoteHttpRequestException() throws Exception {
        this.registerQueriesWithRetryException((Exception)new KieServerHttpRequestException("KieServer endpoint down"));
    }

    private void registerQueriesWithRetryException(Exception exception) throws Exception {
        QueryDefinition query = QueryDefinition.builder().name("test").expression("expression").source("jbpm").target("CUSTOM").build();
        HashSet<QueryDefinition> definitions = new HashSet<QueryDefinition>();
        definitions.add(query);
        KieServicesClient kieClientRecreated = (KieServicesClient)Mockito.mock(KieServicesClient.class);
        QueryServicesClient queryClientRecreated = (QueryServicesClient)Mockito.mock(QueryServicesClient.class);
        Mockito.when((Object)kieClientRecreated.getServicesClient((Class)Matchers.any())).thenReturn((Object)queryClientRecreated);
        Mockito.when((Object)this.kieServerIntegration.getAdminServerClientCheckEndpoints(Matchers.anyString())).thenReturn((Object)kieClientRecreated);
        ((QueryServicesClient)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.queryClient)).replaceQuery((QueryDefinition)Matchers.any());
        this.kieServerDataSetManager.registerQueriesWithRetry("template", "instance", definitions);
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClient(Matchers.anyString(), Matchers.anyString());
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClientCheckEndpoints(Matchers.anyString());
        ((QueryServicesClient)Mockito.verify((Object)this.queryClient, (VerificationMode)Mockito.times((int)1))).replaceQuery((QueryDefinition)Matchers.any());
        ((QueryServicesClient)Mockito.verify((Object)queryClientRecreated, (VerificationMode)Mockito.times((int)1))).replaceQuery((QueryDefinition)Matchers.any());
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
    }

    @Test
    public void testRegisterKieServerWithoutProcessCapability() {
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setServerInstanceId("instanceId");
        serverInstance.setServerTemplateId("templateId");
        Mockito.when((Object)this.specManagementService.getServerTemplate(serverInstance.getServerTemplateId())).thenReturn((Object)new ServerTemplate());
        this.kieServerDataSetManager.registerInKieServer(new ServerInstanceRegistered(serverInstance));
        Assert.assertEquals((long)1L, (long)this.receivedEvents.size());
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry, (VerificationMode)Mockito.never())).getDataSetDefs(false);
    }

    @Test
    public void testRegisterKieServerWithProcessCapability() {
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setServerInstanceId("instanceId");
        serverInstance.setServerTemplateId("templateId");
        Mockito.when((Object)this.specManagementService.getServerTemplate(serverInstance.getServerTemplateId())).thenReturn((Object)new ServerTemplate(serverInstance.getServerTemplateId(), null, Collections.singletonList(Capability.PROCESS.name()), Collections.emptyMap(), Collections.emptyList()));
        this.kieServerDataSetManager.registerInKieServer(new ServerInstanceRegistered(serverInstance));
        Assert.assertEquals((long)0L, (long)this.receivedEvents.size());
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).getDataSetDefs(false);
    }

    @Test
    public void testRegisterQueriesOnServerWithoutBPMCapability() throws Exception {
        Mockito.when((Object)this.kieClient.getServicesClient((Class)Matchers.any())).thenThrow(KieServicesException.class);
        QueryDefinition query = QueryDefinition.builder().name("test").expression("expression").source("jbpm").target("CUSTOM").build();
        HashSet<QueryDefinition> definitions = new HashSet<QueryDefinition>();
        definitions.add(query);
        this.kieServerDataSetManager.registerQueriesWithRetry("template", "instance", definitions);
        ((KieServerIntegration)Mockito.verify((Object)this.kieServerIntegration, (VerificationMode)Mockito.times((int)1))).getAdminServerClient(Matchers.anyString(), Matchers.anyString());
        ((QueryServicesClient)Mockito.verify((Object)this.queryClient, (VerificationMode)Mockito.never())).replaceQuery((QueryDefinition)Matchers.any());
        Assert.assertEquals((long)0L, (long)this.receivedEvents.size());
    }
}

