/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateColumnFilterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateColumnFilterFactory.class);
    private static final DateTimeFormatter OUTPUT_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy[-MM][-dd][ HH][:mm][:ss]").parseDefaulting(ChronoField.YEAR_OF_ERA, 0L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter().withLocale(Locale.getDefault()).withZone(ZoneId.from(ZoneOffset.UTC));

    private DateColumnFilterFactory() {
    }

    public static ColumnFilter createFilter(ColumnGroup cg, List<Comparable> names) {
        DateIntervalType intervalSize = DateIntervalType.getByName((String)cg.getIntervalSize());
        ColumnFilter defaultFilter = FilterFactory.equalsTo((String)cg.getSourceId(), names);
        Collections.sort(names);
        if (names != null && !names.isEmpty() && intervalSize != null) {
            String v1 = names.get(0).toString();
            String v2 = names.get(names.size() - 1).toString();
            LocalDateTime i = LocalDateTime.parse(v1, OUTPUT_FORMATTER);
            LocalDateTime ii = LocalDateTime.parse(v2, OUTPUT_FORMATTER);
            if (v1.equals(v2) || intervalSize != DateIntervalType.SECOND) {
                ii = DateColumnFilterFactory.advanceUnit(intervalSize, ii);
            }
            try {
                return FilterFactory.between((String)cg.getSourceId(), (Comparable)((Object)OUTPUT_FORMATTER.format(i)), (Comparable)((Object)OUTPUT_FORMATTER.format(ii)));
            }
            catch (Exception e) {
                LOGGER.info("Not able to parse dates for names {} and interval {}.", names, (Object)intervalSize);
                LOGGER.debug("Error parsing dates while building request to Kie Server.", (Throwable)e);
            }
        }
        return defaultFilter;
    }

    private static LocalDateTime advanceUnit(DateIntervalType intervalSize, LocalDateTime ii) {
        switch (intervalSize) {
            case DAY: 
            case WEEK: 
            case DAY_OF_WEEK: {
                return ii.plus(1L, ChronoUnit.DAYS);
            }
            case HOUR: {
                return ii.plus(1L, ChronoUnit.HOURS);
            }
            case MINUTE: {
                return ii.plus(1L, ChronoUnit.MINUTES);
            }
            case SECOND: {
                return ii.plus(1L, ChronoUnit.SECONDS);
            }
            case MONTH: 
            case QUARTER: {
                return ii.plus(1L, ChronoUnit.MONTHS);
            }
            case YEAR: {
                return ii.plus(1L, ChronoUnit.YEARS);
            }
        }
        return ii;
    }
}

