/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ks.integration;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.definition.QueryDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@ApplicationScoped
@Startup
public class KieServerQueryDefinitionLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieServerQueryDefinitionLoader.class);
    static final String JBPM_WB_QUERY_MODE = "jbpm.wb.querymode";
    @Inject
    Event<QueryDefinitionLoaded> event;

    @PostConstruct
    public void init() {
        this.init(System.getenv());
    }

    void init(Map<String, String> properties) {
        this.loadDefaultQueryDefinitions(QueryMode.convert(properties.getOrDefault(JBPM_WB_QUERY_MODE, QueryMode.DEFAULT.toString())));
    }

    protected void loadDefaultQueryDefinitions(QueryMode queryMode) {
        QueryDefinition[] queries;
        HashMap<String, String> applyStrict = new HashMap<String, String>();
        if (QueryMode.STRICT.equals((Object)queryMode)) {
            LOGGER.info("Query Mode Strict enabled!");
            for (QueryDefinition q : queries = this.loadQueryDefinitions("/default-query-definitions-strict.json")) {
                applyStrict.put(q.getName(), q.getTarget());
            }
        } else {
            LOGGER.info("Query Mode Default enabled!");
        }
        for (QueryDefinition q : queries = this.loadQueryDefinitions("/default-query-definitions.json")) {
            if (applyStrict.containsKey(q.getName())) {
                q.setTarget((String)applyStrict.get(q.getName()));
            }
            LOGGER.info("Loaded query definition: {}", (Object)q);
            this.event.fire((Object)new QueryDefinitionLoaded(q));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected QueryDefinition[] loadQueryDefinitions(String resourceName) {
        try (InputStream qdStream = this.getClass().getResourceAsStream(resourceName);){
            if (qdStream == null) {
                LOGGER.info("Default query definitions file " + resourceName + " not found");
                QueryDefinition[] queryDefinitionArray = new QueryDefinition[]{};
                return queryDefinitionArray;
            }
            String qdString = IOUtils.toString((InputStream)qdStream, (Charset)Charset.forName("UTF-8"));
            QueryDefinition[] queries = (QueryDefinition[])MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader()).unmarshall(qdString, QueryDefinition[].class);
            LOGGER.info("Found {} query definitions", (Object)(queries == null ? 0 : queries.length));
            if (queries == null) {
                QueryDefinition[] queryDefinitionArray = new QueryDefinition[]{};
                return queryDefinitionArray;
            }
            QueryDefinition[] queryDefinitionArray = queries;
            return queryDefinitionArray;
        }
        catch (MarshallingException e) {
            LOGGER.error("Error when unmarshalling query definitions from stream.", (Throwable)e);
            return new QueryDefinition[0];
        }
        catch (Exception e) {
            LOGGER.error("Error when loading default query definitions from " + resourceName, (Throwable)e);
        }
        return new QueryDefinition[0];
    }

    static enum QueryMode {
        DEFAULT,
        STRICT;


        static QueryMode convert(String mode) {
            try {
                return QueryMode.valueOf(mode.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                LOGGER.warn("Invalid Argument provided. DEFAULT query mode will be used.");
                return DEFAULT;
            }
        }
    }
}

