/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListViewImpl;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceListViewTest {
    @Mock
    protected ExtendedPagedTable currentListGrid;
    @Mock
    protected GridPreferencesStore gridPreferencesStore;
    @Mock
    protected DataSetEditorManager dataSetEditorManager;
    @Mock
    protected MultiGridPreferencesStore multiGridPreferencesStore;
    @Mock
    protected FilterPagedTable filterPagedTable;
    @Mock
    protected ProcessInstanceListPresenter presenter;
    @InjectMocks
    private ProcessInstanceListViewImpl view;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.presenter.getDataProvider()).thenReturn(Mockito.mock(AsyncDataProvider.class));
        Mockito.when((Object)this.filterPagedTable.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStore);
    }

    @Test
    public void testDataStoreNameIsSet() {
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(new ArrayList());
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when((Object)this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testInitDefaultFilters() {
        this.view.initDefaultFilters(new GridGlobalPreferences("testGrid", new ArrayList(), new ArrayList()), null);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).addTab((PagedTable)((ExtendedPagedTable)Mockito.any()), Mockito.anyString(), (Command)Mockito.any());
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).saveNewTabSettings(Mockito.anyString(), (HashMap)Mockito.any());
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(true);
        ((ProcessInstanceListPresenter)Mockito.verify((Object)this.presenter)).setAddingDefaultFilters(false);
    }

    @Test
    public void setDefaultFilterTitleAndDescriptionTest() {
        this.view.resetDefaultFilterTitleAndDescription();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).getMultiGridPreferencesStore();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.times((int)3))).saveTabSettings(Mockito.anyString(), (HashMap)Mockito.any(HashMap.class));
    }

    @Test
    public void testSelectColumnAddition() {
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(new ArrayList());
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        ArrayList<ProcessInstanceSummary> displayedInstances = new ArrayList<ProcessInstanceSummary>();
        displayedInstances.add(new ProcessInstanceSummary());
        displayedInstances.add(new ProcessInstanceSummary());
        Mockito.when((Object)this.presenter.getDisplayedProcessInstances()).thenReturn(displayedInstances);
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                ColumnMeta checkColumnMeta = (ColumnMeta)columns.get(0);
                Assert.assertTrue((boolean)(checkColumnMeta.getColumn().getCell() instanceof CheckboxCell));
                Assert.assertTrue((boolean)(checkColumnMeta.getHeader().getValue() instanceof Boolean));
                return null;
            }
        }).when((Object)this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void testColumnNumber() {
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(new ArrayList());
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 11 ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)this.currentListGrid)).addColumns(Mockito.anyList());
        this.view.initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)this.currentListGrid)).addColumns(Mockito.anyList());
    }
}

