/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.variables.history;

import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Comparator;
import org.gwtbootstrap3.client.ui.FormControlStatic;
import org.gwtbootstrap3.client.ui.Pagination;
import org.gwtbootstrap3.client.ui.gwt.DataGrid;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jbpm.workbench.pr.client.editors.variables.history.VariableHistoryPopup;
import org.jbpm.workbench.pr.model.ProcessVariableSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={Text.class})
public class VariableHistoryPopupTest {
    public static int COLUMN_NEW_VALUE_POSITION = 0;
    public static int COLUMN_OLD_VALUE_POSITION = 1;
    @Mock
    private Pagination paginationMock;
    @Mock
    private FormControlStatic variableNameTextBoxMock;
    private VariableHistoryPopup variableHistoryPopup;
    DataGrid<ProcessVariableSummary> testDataGrid;

    @Before
    public void setupMocks() {
        this.testDataGrid = new DataGrid();
        this.variableHistoryPopup = new VariableHistoryPopup(this.testDataGrid, this.paginationMock, this.variableNameTextBoxMock);
    }

    @Test
    public void variableNewValueComparatorTest() {
        ProcessVariableSummary processVariableSummary1 = new ProcessVariableSummary();
        ProcessVariableSummary processVariableSummary2 = new ProcessVariableSummary();
        ProcessVariableSummary processVariableSummary3 = new ProcessVariableSummary();
        processVariableSummary1.setNewValue("A");
        processVariableSummary2.setNewValue("B");
        processVariableSummary3.setNewValue("A");
        Comparator varNewValueComparator = this.variableHistoryPopup.getSortHandler().getComparator(this.testDataGrid.getColumn(COLUMN_NEW_VALUE_POSITION));
        Assert.assertEquals((long)-1L, (long)varNewValueComparator.compare(processVariableSummary1, processVariableSummary2));
        Assert.assertEquals((long)1L, (long)varNewValueComparator.compare(processVariableSummary2, processVariableSummary1));
        Assert.assertEquals((long)0L, (long)varNewValueComparator.compare(processVariableSummary1, processVariableSummary3));
        processVariableSummary1.setNewValue(null);
        processVariableSummary2.setNewValue("B");
        Assert.assertEquals((long)-1L, (long)varNewValueComparator.compare(processVariableSummary1, processVariableSummary2));
        Assert.assertEquals((long)1L, (long)varNewValueComparator.compare(processVariableSummary2, processVariableSummary1));
        processVariableSummary3.setNewValue(null);
        Assert.assertEquals((long)0L, (long)varNewValueComparator.compare(processVariableSummary1, processVariableSummary3));
        Assert.assertEquals((Object)"", (Object)this.testDataGrid.getColumn(COLUMN_NEW_VALUE_POSITION).getValue((Object)processVariableSummary3));
        Assert.assertEquals((Object)"B", (Object)this.testDataGrid.getColumn(COLUMN_NEW_VALUE_POSITION).getValue((Object)processVariableSummary2));
    }

    @Test
    public void variableOldValueComparatorTest() {
        ProcessVariableSummary processVariableSummary1 = new ProcessVariableSummary();
        ProcessVariableSummary processVariableSummary2 = new ProcessVariableSummary();
        ProcessVariableSummary processVariableSummary3 = new ProcessVariableSummary();
        processVariableSummary1.setOldValue("A");
        processVariableSummary2.setOldValue("B");
        processVariableSummary3.setOldValue("A");
        Comparator varOldValueComparator = this.variableHistoryPopup.getSortHandler().getComparator(this.testDataGrid.getColumn(COLUMN_OLD_VALUE_POSITION));
        Assert.assertEquals((long)-1L, (long)varOldValueComparator.compare(processVariableSummary1, processVariableSummary2));
        Assert.assertEquals((long)1L, (long)varOldValueComparator.compare(processVariableSummary2, processVariableSummary1));
        Assert.assertEquals((long)0L, (long)varOldValueComparator.compare(processVariableSummary1, processVariableSummary3));
        processVariableSummary1.setOldValue(null);
        processVariableSummary2.setOldValue("B");
        Assert.assertEquals((long)-1L, (long)varOldValueComparator.compare(processVariableSummary1, processVariableSummary2));
        Assert.assertEquals((long)1L, (long)varOldValueComparator.compare(processVariableSummary2, processVariableSummary1));
        processVariableSummary3.setOldValue(null);
        Assert.assertEquals((long)0L, (long)varOldValueComparator.compare(processVariableSummary1, processVariableSummary3));
        Assert.assertEquals((Object)"", (Object)this.testDataGrid.getColumn(COLUMN_OLD_VALUE_POSITION).getValue((Object)processVariableSummary3));
        Assert.assertEquals((Object)"B", (Object)this.testDataGrid.getColumn(COLUMN_OLD_VALUE_POSITION).getValue((Object)processVariableSummary2));
    }
}

