/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceSummaryActionCell;
import org.jbpm.workbench.pr.client.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
public class ProcessInstanceListViewImpl
extends AbstractMultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter>
implements ProcessInstanceListPresenter.ProcessInstanceListView {
    private static final String TAB_ACTIVE = "DS_ProcessInstancesWithVariablesIncludedGrid_0";
    private static final String TAB_COMPLETED = "DS_ProcessInstancesWithVariablesIncludedGrid_1";
    private static final String TAB_ABORTED = "DS_ProcessInstancesWithVariablesIncludedGrid_2";
    private List<ProcessInstanceSummary> selectedProcessInstances = new ArrayList<ProcessInstanceSummary>();
    private final Constants constants = Constants.INSTANCE;
    @Inject
    protected DataSetEditorManager dataSetEditorManager;
    private Column actionsColumn;
    private AnchorListItem bulkAbortNavLink;
    private AnchorListItem bulkSignalNavLink;

    private void controlBulkOperations() {
        if (this.selectedProcessInstances != null && this.selectedProcessInstances.size() > 0) {
            this.bulkAbortNavLink.setEnabled(true);
            this.bulkSignalNavLink.setEnabled(true);
        } else {
            this.bulkAbortNavLink.setEnabled(false);
            this.bulkSignalNavLink.setEnabled(false);
        }
    }

    public void init(final ProcessInstanceListPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("Select");
        bannedColumns.add("processInstanceId");
        bannedColumns.add("processName");
        bannedColumns.add("processInstanceDescription");
        bannedColumns.add("Actions");
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("Select");
        initColumns.add("processInstanceId");
        initColumns.add("processName");
        initColumns.add("processInstanceDescription");
        initColumns.add("processVersion");
        initColumns.add("lastModificationDate");
        initColumns.add("Actions");
        final Button button = new Button();
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = ProcessInstanceListViewImpl.this.getValidKeyForAdditionalListGrid("DS_ProcessInstancesWithVariablesIncludedGrid_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = ProcessInstanceListViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        ProcessInstanceListViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                ProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                                ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = ProcessInstanceListViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                ProcessInstanceListViewImpl.this.dataSetEditorManager.showTableSettingsEditor(ProcessInstanceListViewImpl.this.filterPagedTable, ProcessInstanceListViewImpl.this.constants.New_Process_InstanceList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractMultiGridPresenter)presenter, new GridGlobalPreferences("DS_ProcessInstancesWithVariablesIncludedGrid", initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Process_Instances_Found());
        extendedPagedTable.getRightActionsToolbar().clear();
        this.initExtraButtons((ExtendedPagedTable<ProcessInstanceSummary>)extendedPagedTable);
        this.initBulkActions((ExtendedPagedTable<ProcessInstanceSummary>)extendedPagedTable);
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (ProcessInstanceListViewImpl.this.selectedRow == -1) {
                    extendedPagedTable.setRowStyles(ProcessInstanceListViewImpl.this.selectedStyles);
                    ProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != ProcessInstanceListViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(ProcessInstanceListViewImpl.this.selectedStyles);
                    ProcessInstanceListViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                ProcessInstanceListViewImpl.this.selectedItem = (GenericSummary)ProcessInstanceListViewImpl.this.selectionModel.getLastSelectedObject();
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).selectProcessInstance((ProcessInstanceSummary)ProcessInstanceListViewImpl.this.selectedItem, close);
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<ProcessInstanceSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<ProcessInstanceSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<ProcessInstanceSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType())) {
                    InputElement input;
                    if (extendedPagedTable.getColumnIndex(ProcessInstanceListViewImpl.this.actionsColumn) == event.getColumn()) {
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                    Element target = (Element)nativeEvent.getEventTarget().cast();
                    if ("input".equals(target.getTagName().toLowerCase()) && "checkbox".equals((input = (InputElement)target.cast()).getType().toLowerCase())) {
                        if (!ProcessInstanceListViewImpl.this.selectedProcessInstances.contains(event.getValue())) {
                            ProcessInstanceListViewImpl.this.selectedProcessInstances.add(event.getValue());
                            input.setChecked(true);
                        } else {
                            ProcessInstanceListViewImpl.this.selectedProcessInstances.remove(event.getValue());
                            input.setChecked(false);
                        }
                        ProcessInstanceListViewImpl.this.getListGrid().redraw();
                        ProcessInstanceListViewImpl.this.controlBulkOperations();
                        return DefaultSelectionEventManager.SelectAction.IGNORE;
                    }
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        ColumnMeta<ProcessInstanceSummary> checkColumnMeta = this.initChecksColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta<ProcessInstanceSummary>> columnMetas = new ArrayList<ColumnMeta<ProcessInstanceSummary>>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceId", process -> String.valueOf(process.getProcessInstanceId())), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", process -> process.getProcessName()), this.constants.Name()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", process -> process.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("user_identity", process -> process.getInitiator()), this.constants.Initiator()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processVersion", process -> process.getProcessVersion()), this.constants.Version()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", process -> {
            switch (process.getState()) {
                case 1: {
                    return this.constants.Active();
                }
                case 3: {
                    return this.constants.Aborted();
                }
                case 2: {
                    return this.constants.Completed();
                }
                case 0: {
                    return this.constants.Pending();
                }
                case 4: {
                    return this.constants.Suspended();
                }
            }
            return this.constants.Unknown();
        }), this.constants.State()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("start_date", process -> DateUtils.getDateTimeStr((Date)process.getStartTime())), this.constants.Start_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", process -> DateUtils.getDateTimeStr((Date)process.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", process -> process.getCorrelationKey()), this.constants.Correlation_Key()));
        columnMetas.add(new ColumnMeta(this.initActionsColumn(), this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<ProcessInstanceSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 37.0, Style.Unit.PX);
        extendedPagedTable.storeColumnToPreferences();
    }

    private boolean isColumnAdded(List<ColumnMeta<ProcessInstanceSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<ProcessInstanceSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initGenericColumn(final String key) {
        Column<ProcessInstanceSummary, String> genericColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getDomainDataValue(key);
            }
        };
        genericColumn.setSortable(true);
        genericColumn.setDataStoreName(key);
        return genericColumn;
    }

    public void initExtraButtons(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
    }

    private void initBulkActions(final ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        this.bulkAbortNavLink = new AnchorListItem(this.constants.Bulk_Abort());
        this.bulkSignalNavLink = new AnchorListItem(this.constants.Bulk_Signal());
        ButtonGroup bulkActions = new ButtonGroup(){
            {
                this.add((Widget)new Button(ProcessInstanceListViewImpl.this.constants.Bulk_Actions()){
                    {
                        this.setDataToggle(Toggle.DROPDOWN);
                        this.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
                    }
                });
                this.add((Widget)new DropDownMenu(){
                    {
                        this.addStyleName("dropdown-menu-right");
                        this.getElement().getStyle().setMarginRight(5.0, Style.Unit.PX);
                        this.add((Widget)ProcessInstanceListViewImpl.this.bulkAbortNavLink);
                        this.add((Widget)ProcessInstanceListViewImpl.this.bulkSignalNavLink);
                    }
                });
            }
        };
        this.bulkAbortNavLink.setIcon(IconType.BAN);
        this.bulkAbortNavLink.setIconFixedWidth(true);
        this.bulkAbortNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (Window.confirm((String)ProcessInstanceListViewImpl.this.constants.Abort_Process_Instances())) {
                    ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkAbort(ProcessInstanceListViewImpl.this.selectedProcessInstances);
                    ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                    extendedPagedTable.redraw();
                }
            }
        });
        this.bulkSignalNavLink.setIcon(IconType.BELL);
        this.bulkSignalNavLink.setIconFixedWidth(true);
        this.bulkSignalNavLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).bulkSignal(ProcessInstanceListViewImpl.this.selectedProcessInstances);
                ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                extendedPagedTable.redraw();
            }
        });
        extendedPagedTable.getRightActionsToolbar().add((Widget)bulkActions);
        this.controlBulkOperations();
    }

    private Column initActionsColumn() {
        LinkedList<ProcessInstanceSummaryActionCell> cells = new LinkedList<ProcessInstanceSummaryActionCell>();
        cells.add(new ProcessInstanceSummaryActionCell(this.constants.Signal(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).signalProcessInstance(processInstance);
            }
        }));
        cells.add(new ProcessInstanceSummaryActionCell(this.constants.Abort(), new ActionCell.Delegate<ProcessInstanceSummary>(){

            public void execute(ProcessInstanceSummary processInstance) {
                if (Window.confirm((String)ProcessInstanceListViewImpl.this.constants.Abort_Process_Instance())) {
                    ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).abortProcessInstance(processInstance.getDeploymentId(), processInstance.getProcessInstanceId());
                }
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<ProcessInstanceSummary, ProcessInstanceSummary> actionsColumn = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)cell){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName("Actions");
        return actionsColumn;
    }

    private ColumnMeta<ProcessInstanceSummary> initChecksColumn() {
        CheckboxCell checkboxCell = new CheckboxCell(true, false);
        Column<ProcessInstanceSummary, Boolean> checkColumn = new Column<ProcessInstanceSummary, Boolean>((Cell)checkboxCell){

            public Boolean getValue(ProcessInstanceSummary object) {
                return ProcessInstanceListViewImpl.this.selectedProcessInstances.contains(object);
            }
        };
        Header<Boolean> selectPageHeader = new Header<Boolean>((Cell)checkboxCell){

            public Boolean getValue() {
                List<ProcessInstanceSummary> displayedInstances = ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).getDisplayedProcessInstances();
                return displayedInstances.size() > 0 && ProcessInstanceListViewImpl.this.selectedProcessInstances.size() == ((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).getDisplayedProcessInstances().size();
            }
        };
        selectPageHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                ProcessInstanceListViewImpl.this.selectedProcessInstances.clear();
                if (value.booleanValue()) {
                    ProcessInstanceListViewImpl.this.selectedProcessInstances.addAll(((ProcessInstanceListPresenter)ProcessInstanceListViewImpl.this.presenter).getDisplayedProcessInstances());
                }
                ProcessInstanceListViewImpl.this.getListGrid().redraw();
                ProcessInstanceListViewImpl.this.controlBulkOperations();
            }
        });
        checkColumn.setSortable(false);
        checkColumn.setDataStoreName("Select");
        ColumnMeta checkColMeta = new ColumnMeta((Column)checkColumn, "");
        checkColMeta.setHeader((Header)selectPageHeader);
        return checkColMeta;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((ProcessInstanceListPresenter)this.presenter).setAddingDefaultFilters(true);
        this.initGenericTabFilter(preferences, TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive(), 1);
        this.initGenericTabFilter(preferences, TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted(), 2);
        this.initGenericTabFilter(preferences, TAB_ABORTED, this.constants.Aborted(), this.constants.FilterAborted(), 3);
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries(TAB_ACTIVE);
    }

    private void initGenericTabFilter(GridGlobalPreferences preferences, final String key, String tabName, String tabDesc, Integer state) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmProcessInstances");
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", (Comparable)state)});
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("start_date", SortOrder.DESCENDING);
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        tableSettings.setUUID("jbpmProcessInstances");
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((ProcessInstanceListPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                ProcessInstanceListViewImpl.this.currentListGrid = extendedPagedTable;
                ProcessInstanceListViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    @Override
    public FilterSettings getVariablesTableSettings(String processName) {
        String tableSettingsJSON = "{\n    \"type\": \"TABLE\",\n    \"filter\": {\n        \"enabled\": \"true\",\n        \"selfapply\": \"true\",\n        \"notification\": \"true\",\n        \"listening\": \"true\"\n    },\n    \"table\": {\n        \"sort\": {\n            \"enabled\": \"true\",\n            \"columnId\": \"processInstanceId\",\n            \"order\": \"ASCENDING\"\n        }\n    },\n    \"dataSetLookup\": {\n        \"dataSetUuid\": \"jbpmProcessInstancesWithVariables\",\n        \"rowCount\": \"-1\",\n        \"rowOffset\": \"0\",\n";
        if (processName != null) {
            tableSettingsJSON = tableSettingsJSON + "        \"filterOps\":[{\"columnId\":\"processId\", \"functionType\":\"EQUALS_TO\", \"terms\":[\"" + processName + "\"]}],";
        }
        tableSettingsJSON = tableSettingsJSON + "        \"groupOps\": [\n            {\n                \"groupFunctions\": [\n                    {\n                        \"sourceId\": \"processInstanceId\",\n                        \"columnId\": \"processInstanceId\"\n                    },\n                    {\n                        \"sourceId\": \"processId\",\n                        \"columnId\": \"processId\"\n                    },\n                    {\n                        \"sourceId\": \"id\",\n                        \"columnId\": \"id\"\n                    },\n                    {\n                        \"sourceId\": \"variableId\",\n                        \"columnId\": \"variableId\"\n                    },\n                    {\n                        \"sourceId\": \"value\",\n                        \"columnId\": \"value\"\n                    }\n                ],\n                \"join\": \"false\"\n            }\n        ]\n    },\n    \"columns\": [\n        {\n            \"id\": \"processInstanceId\",\n            \"name\": \"processInstanceId\"\n        },\n        {\n            \"id\": \"processId\",\n            \"name\": \"processName\"\n        },\n        {\n            \"id\": \"id\",\n            \"name\": \"variableID\"\n        },\n        {\n            \"id\": \"variableId\",\n            \"name\": \"variableName\"\n        },\n        {\n            \"id\": \"value\",\n            \"name\": \"variableValue\"\n        }\n    ],\n    \"tableName\": \"Filtered\",\n    \"tableDescription\": \"Filtered Desc\",\n    \"tableEditEnabled\": \"false\"\n}";
        return this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmProcessInstances");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("start_date", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        FilterSettings filterSettings = builder.buildSettings();
        filterSettings.setUUID("jbpmProcessInstances");
        return filterSettings;
    }

    public void resetDefaultFilterTitleAndDescription() {
        this.saveTabSettings(TAB_ACTIVE, this.constants.Active(), this.constants.FilterActive());
        this.saveTabSettings(TAB_COMPLETED, this.constants.Completed(), this.constants.FilterCompleted());
        this.saveTabSettings(TAB_ABORTED, this.constants.Aborted(), this.constants.FilterAborted());
    }
}

