/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.definition.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.events.SearchEvent;
import org.jbpm.workbench.common.client.list.AbstractScreenListPresenter;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.model.PortableQueryFilter;
import org.jbpm.workbench.forms.client.display.providers.StartProcessFormDisplayProviderImpl;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.PopupFormDisplayerView;
import org.jbpm.workbench.forms.display.api.ProcessDisplayerConfig;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessDefSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessDefinitionKey;
import org.jbpm.workbench.pr.model.ProcessSummary;
import org.jbpm.workbench.pr.service.ProcessRuntimeDataService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Process Definition List")
public class ProcessDefinitionListPresenter
extends AbstractScreenListPresenter<ProcessSummary> {
    @Inject
    PopupFormDisplayerView formDisplayPopUp;
    @Inject
    StartProcessFormDisplayProviderImpl startProcessDisplayProvider;
    @Inject
    private ProcessDefinitionListView view;
    @Inject
    private Caller<ProcessRuntimeDataService> processRuntimeDataService;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;
    @Inject
    private Event<ProcessDefSelectionEvent> processDefSelected;
    private Constants constants = Constants.INSTANCE;
    private String placeIdentifier;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Process_Definitions();
    }

    @WorkbenchPartView
    public UberView<ProcessDefinitionListPresenter> getView() {
        return this.view;
    }

    public void openGenericForm(String processDefId, String deploymentId, String processDefName) {
        ProcessDisplayerConfig config = new ProcessDisplayerConfig(new ProcessDefinitionKey(this.getSelectedServerTemplate(), deploymentId, processDefId, processDefName), processDefName);
        this.formDisplayPopUp.setTitle(processDefName);
        this.startProcessDisplayProvider.setup(config, (FormDisplayerView)this.formDisplayPopUp);
    }

    protected ListView getListView() {
        return this.view;
    }

    public void getData(final Range visibleRange) {
        ColumnSortList columnSortList = this.view.getListGrid().getColumnSortList();
        if (this.currentFilter == null) {
            this.currentFilter = new PortableQueryFilter(visibleRange.getStart(), visibleRange.getLength(), false, "", columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "", columnSortList.size() == 0 || columnSortList.get(0).isAscending());
        }
        if (this.currentFilter.getParams() == null || this.currentFilter.getParams().isEmpty() || this.currentFilter.getParams().get("textSearch") == null || this.currentFilter.getParams().get("textSearch").equals("")) {
            this.currentFilter.setOffset(Integer.valueOf(visibleRange.getStart()));
            this.currentFilter.setCount(Integer.valueOf(visibleRange.getLength()));
        } else {
            this.currentFilter.setOffset(Integer.valueOf(0));
            this.currentFilter.setCount(Integer.valueOf(this.view.getListGrid().getPageSize()));
        }
        this.currentFilter.setOrderBy(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
        this.currentFilter.setIsAscending(Boolean.valueOf(columnSortList.size() == 0 || columnSortList.get(0).isAscending()));
        ((ProcessRuntimeDataService)this.processRuntimeDataService.call((RemoteCallback)new RemoteCallback<List<ProcessSummary>>(){

            public void callback(List<ProcessSummary> processDefsSums) {
                boolean lastPageExactCount = processDefsSums.size() < visibleRange.getLength();
                ProcessDefinitionListPresenter.this.updateDataOnCallback(processDefsSums, visibleRange.getStart(), visibleRange.getStart() + processDefsSums.size(), lastPageExactCount);
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                ProcessDefinitionListPresenter.this.view.hideBusyIndicator();
                return true;
            }
        })).getProcessesByFilter(this.getSelectedServerTemplate(), this.textSearchStr, Integer.valueOf(visibleRange.getStart() / visibleRange.getLength()), Integer.valueOf(visibleRange.getLength()), this.currentFilter.getOrderBy(), this.currentFilter.isAscending());
    }

    @WorkbenchMenu
    public Menus buildMenu() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    protected void selectProcessDefinition(ProcessSummary processSummary, Boolean close) {
        PlaceStatus instanceDetailsStatus = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Process Instance Details Multi"));
        if (instanceDetailsStatus == PlaceStatus.OPEN) {
            this.placeManager.closePlace("Process Instance Details Multi");
        }
        this.placeIdentifier = "Advanced Process Details Multi";
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest(this.placeIdentifier));
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo(this.placeIdentifier);
            this.fireProcessDefSelectionEvent(processSummary);
        } else if (status == PlaceStatus.OPEN && !close.booleanValue()) {
            this.fireProcessDefSelectionEvent(processSummary);
        } else if (status == PlaceStatus.OPEN && close.booleanValue()) {
            this.placeManager.closePlace(this.placeIdentifier);
        }
    }

    private void fireProcessDefSelectionEvent(ProcessSummary processSummary) {
        this.processDefSelected.fire((Object)new ProcessDefSelectionEvent(processSummary.getProcessDefId(), processSummary.getDeploymentId(), this.getSelectedServerTemplate(), processSummary.getProcessDefName(), processSummary.isDynamic()));
    }

    public void refreshNewProcessInstance(@Observes NewProcessInstanceEvent newProcessInstance) {
        this.placeIdentifier = "Advanced Process Details Multi";
        PlaceStatus definitionDetailsStatus = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest(this.placeIdentifier));
        if (definitionDetailsStatus == PlaceStatus.OPEN) {
            this.placeManager.closePlace(this.placeIdentifier);
        }
        this.placeManager.goTo("Process Instance Details Multi");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(newProcessInstance.getDeploymentId(), newProcessInstance.getNewProcessInstanceId(), newProcessInstance.getNewProcessDefId(), newProcessInstance.getProcessDefName(), newProcessInstance.getNewProcessInstanceStatus(), newProcessInstance.getServerTemplateId()));
    }

    protected void onSearchEvent(@Observes SearchEvent searchEvent) {
        this.textSearchStr = searchEvent.getFilter();
        this.refreshGrid();
    }

    @Inject
    public void setProcessRuntimeDataService(Caller<ProcessRuntimeDataService> processRuntimeDataService) {
        this.processRuntimeDataService = processRuntimeDataService;
    }

    public static interface ProcessDefinitionListView
    extends ListView<ProcessSummary, ProcessDefinitionListPresenter> {
    }
}

