/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.dataset.AbstractDataSetReadyCallback;
import org.jbpm.workbench.common.client.list.AbstractMultiGridPresenter;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListView;
import org.jbpm.workbench.common.client.list.MultiGridView;
import org.jbpm.workbench.common.client.menu.RestoreDefaultFiltersMenuBuilder;
import org.jbpm.workbench.common.client.util.DataSetUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.forms.client.display.process.QuickNewProcessInstancePopup;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.events.NewProcessInstanceEvent;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesUpdateEvent;
import org.jbpm.workbench.pr.events.ProcessInstancesWithDetailsRequestEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.jbpm.workbench.pr.service.ProcessService;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="DataSet Process Instance List With Variables")
public class ProcessInstanceListPresenter
extends AbstractMultiGridPresenter<ProcessInstanceSummary, ProcessInstanceListView> {
    public static final String SCREEN_ID = "DataSet Process Instance List With Variables";
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Inject
    private FilterSettingsJSONMarshaller tableSettingsJSONMarshaller;
    @Inject
    private ErrorPopupPresenter errorPopup;
    @Inject
    private QuickNewProcessInstancePopup newProcessInstancePopup;
    protected final List<ProcessInstanceSummary> myProcessInstancesFromDataSet = new ArrayList<ProcessInstanceSummary>();
    private Caller<ProcessService> processService;
    @Inject
    private Event<ProcessInstanceSelectionEvent> processInstanceSelected;

    public void getData(Range visibleRange) {
        try {
            if (!this.isAddingDefaultFilters()) {
                FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
                currentTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
                currentTableSettings.setTablePageSize(((ProcessInstanceListView)this.view).getListGrid().getPageSize());
                ColumnSortList columnSortList = ((ProcessInstanceListView)this.view).getListGrid().getColumnSortList();
                if (columnSortList != null && columnSortList.size() > 0) {
                    this.dataSetQueryHelper.setLastOrderedColumn(columnSortList.size() > 0 ? columnSortList.get(0).getColumn().getDataStoreName() : "");
                    this.dataSetQueryHelper.setLastSortOrder(columnSortList.size() > 0 && columnSortList.get(0).isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
                } else {
                    this.dataSetQueryHelper.setLastOrderedColumn("start_date");
                    this.dataSetQueryHelper.setLastSortOrder(SortOrder.ASCENDING);
                }
                List<ColumnFilter> filters = this.getColumnFilters(this.textSearchStr);
                if (!filters.isEmpty()) {
                    if (currentTableSettings.getDataSetLookup().getFirstFilterOp() != null) {
                        currentTableSettings.getDataSetLookup().getFirstFilterOp().addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                    } else {
                        DataSetFilter filter = new DataSetFilter();
                        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.OR(filters)});
                        currentTableSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
                    }
                }
                this.dataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
                this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
                this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(visibleRange.getStart()), this.createDataSetProcessInstanceCallback(visibleRange.getStart(), currentTableSettings));
            }
        }
        catch (Exception e) {
            this.errorPopup.showMessage(Constants.INSTANCE.UnexpectedError(e.getMessage()));
            ((ProcessInstanceListView)this.view).hideBusyIndicator();
        }
    }

    protected List<ColumnFilter> getColumnFilters(String searchString) {
        ArrayList<ColumnFilter> filters = new ArrayList<ColumnFilter>();
        if (searchString != null && searchString.trim().length() > 0) {
            try {
                Long instanceId = Long.valueOf(searchString.trim());
                filters.add(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)instanceId));
            }
            catch (NumberFormatException ex) {
                filters.add(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)searchString)));
                filters.add(FilterFactory.likeTo((String)"processName", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"processInstanceDescription", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
                filters.add(FilterFactory.likeTo((String)"user_identity", (String)("%" + searchString.toLowerCase() + "%"), (boolean)false));
            }
        }
        return filters;
    }

    protected DataSetReadyCallback createDataSetDomainSpecificCallback(final int startRange, FilterSettings tableSettings, final boolean lastPage) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                HashSet<String> columns = new HashSet<String>();
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    Long processInstanceId = DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)i);
                    String variableName = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"variableId", (int)i);
                    String variableValue = DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"value", (int)i);
                    for (ProcessInstanceSummary pis : ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet) {
                        if (!pis.getProcessInstanceId().equals(processInstanceId)) continue;
                        pis.addDomainData(variableName, variableValue);
                        columns.add(variableName);
                    }
                }
                ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).addDomainSpecifColumns((ExtendedPagedTable<ProcessInstanceSummary>)((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).getListGrid(), columns);
                ProcessInstanceListPresenter.this.updateDataOnCallback(ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet, startRange, startRange + ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.size(), lastPage);
            }
        };
    }

    protected DataSetReadyCallback createDataSetProcessInstanceCallback(final int startRange, final FilterSettings tableSettings) {
        return new AbstractDataSetReadyCallback(this.errorPopup, (ListView)this.view, tableSettings.getUUID()){

            public void callback(DataSet dataSet) {
                if (dataSet != null && ProcessInstanceListPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(tableSettings.getKey())) {
                    ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.clear();
                    for (int i = 0; i < dataSet.getRowCount(); ++i) {
                        ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.add(ProcessInstanceListPresenter.this.createProcessInstanceSummaryFromDataSet(dataSet, i));
                    }
                    boolean lastPage = false;
                    if (dataSet.getRowCount() < ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).getListGrid().getPageSize()) {
                        lastPage = true;
                    }
                    String filterValue = ProcessInstanceListPresenter.this.isFilteredByProcessId(tableSettings.getDataSetLookup().getOperationList());
                    if (!"base".equals(tableSettings.getKey()) && filterValue != null) {
                        ProcessInstanceListPresenter.this.getDomainSpecifDataForProcessInstances(startRange, filterValue, lastPage);
                    } else {
                        ProcessInstanceListPresenter.this.updateDataOnCallback(ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet, startRange, startRange + ProcessInstanceListPresenter.this.myProcessInstancesFromDataSet.size(), lastPage);
                    }
                }
                ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).hideBusyIndicator();
            }
        };
    }

    protected String isFilteredByProcessId(List<DataSetOp> ops) {
        for (DataSetOp dataSetOp : ops) {
            if (!dataSetOp.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List filters = ((DataSetFilter)dataSetOp).getColumnFilterList();
            for (ColumnFilter filter : filters) {
                List parameters;
                if (!(filter instanceof CoreFunctionFilter)) continue;
                CoreFunctionFilter coreFilter = (CoreFunctionFilter)filter;
                if (!filter.getColumnId().toUpperCase().equals("processId".toUpperCase()) || ((CoreFunctionFilter)filter).getType() != CoreFunctionType.EQUALS_TO || (parameters = coreFilter.getParameters()).size() <= 0) continue;
                return parameters.get(0).toString();
            }
        }
        return null;
    }

    public void getDomainSpecifDataForProcessInstances(int startRange, String filterValue, boolean lastPage) {
        FilterSettings variablesTableSettings = this.getVariablesTableSettings(filterValue);
        variablesTableSettings.setServerTemplateId(this.getSelectedServerTemplate());
        variablesTableSettings.setTablePageSize(-1);
        this.dataSetQueryHelperDomainSpecific.setDataSetHandler(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setCurrentTableSettings(variablesTableSettings);
        this.dataSetQueryHelperDomainSpecific.setLastOrderedColumn("processInstanceId");
        this.dataSetQueryHelperDomainSpecific.setLastSortOrder(SortOrder.ASCENDING);
        this.dataSetQueryHelperDomainSpecific.lookupDataSet(Integer.valueOf(0), this.createDataSetDomainSpecificCallback(startRange, variablesTableSettings, lastPage));
    }

    protected ProcessInstanceSummary createProcessInstanceSummaryFromDataSet(DataSet dataSet, int i) {
        return new ProcessInstanceSummary(DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"processInstanceId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"externalId", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processName", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processVersion", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"status", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"start_date", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"end_date", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"user_identity", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"processInstanceDescription", (int)i), DataSetUtils.getColumnStringValue((DataSet)dataSet, (String)"correlationKey", (int)i), DataSetUtils.getColumnLongValue((DataSet)dataSet, (String)"parentProcessInstanceId", (int)i), DataSetUtils.getColumnDateValue((DataSet)dataSet, (String)"lastModificationDate", (int)i), DataSetUtils.getColumnIntValue((DataSet)dataSet, (String)"errorCount", (int)i));
    }

    public void newInstanceCreated(@Observes NewProcessInstanceEvent pi) {
        this.refreshGrid();
    }

    public void newInstanceCreated(@Observes ProcessInstancesUpdateEvent pis) {
        this.refreshGrid();
    }

    public void abortProcessInstance(String containerId, long processInstanceId) {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        })).abortProcessInstance(this.getSelectedServerTemplate(), containerId, Long.valueOf(processInstanceId));
    }

    public void abortProcessInstance(List<String> containers, List<Long> processInstanceIds) {
        ((ProcessService)this.processService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                ProcessInstanceListPresenter.this.refreshGrid();
            }
        })).abortProcessInstances(this.getSelectedServerTemplate(), containers, processInstanceIds);
    }

    public void bulkSignal(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        StringBuilder processIdsParam = new StringBuilder();
        StringBuilder deploymentIdsParam = new StringBuilder();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                ((ProcessInstanceListView)this.view).displayNotification(Constants.INSTANCE.Signaling_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            processIdsParam.append(selected.getId() + ",");
            deploymentIdsParam.append(selected.getDeploymentId() + ",");
        }
        if (processIdsParam.length() == 0) {
            return;
        }
        processIdsParam.deleteCharAt(processIdsParam.length() - 1);
        deploymentIdsParam.deleteCharAt(deploymentIdsParam.length() - 1);
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", processIdsParam.toString());
        placeRequestImpl.addParameter("deploymentId", deploymentIdsParam.toString());
        placeRequestImpl.addParameter("serverTemplateId", this.getSelectedServerTemplate());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
        ((ProcessInstanceListView)this.view).displayNotification(Constants.INSTANCE.Signaling_Process_Instance());
    }

    public void bulkAbort(List<ProcessInstanceSummary> processInstances) {
        if (processInstances == null || processInstances.isEmpty()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ArrayList<String> containers = new ArrayList<String>();
        for (ProcessInstanceSummary selected : processInstances) {
            if (selected.getState() != 1) {
                ((ProcessInstanceListView)this.view).displayNotification(Constants.INSTANCE.Aborting_Process_Instance_Not_Allowed(selected.getId()));
                continue;
            }
            ids.add(selected.getProcessInstanceId());
            containers.add(selected.getDeploymentId());
            ((ProcessInstanceListView)this.view).displayNotification(Constants.INSTANCE.Aborting_Process_Instance(selected.getId()));
        }
        if (ids.size() > 0) {
            this.abortProcessInstance(containers, ids);
        }
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Process_Instances();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)Constants.INSTANCE.New_Process_Instance()).respondsWith(new Command(){

            public void execute() {
                String selectedServerTemplate = ProcessInstanceListPresenter.this.getSelectedServerTemplate();
                if (selectedServerTemplate != null && !selectedServerTemplate.isEmpty()) {
                    ProcessInstanceListPresenter.this.newProcessInstancePopup.show(selectedServerTemplate);
                } else {
                    ((ProcessInstanceListView)ProcessInstanceListPresenter.this.view).displayNotification(Constants.INSTANCE.SelectServerTemplate());
                }
            }
        })).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.serverTemplateSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)this.refreshSelectorMenuBuilder).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RestoreDefaultFiltersMenuBuilder((RestoreDefaultFiltersMenuBuilder.SupportsRestoreDefaultFilters)this)).endMenu()).build();
    }

    protected List<ProcessInstanceSummary> getDisplayedProcessInstances() {
        return this.myProcessInstancesFromDataSet;
    }

    public void signalProcessInstance(ProcessInstanceSummary processInstance) {
        DefaultPlaceRequest placeRequestImpl = new DefaultPlaceRequest("Signal Process Popup");
        placeRequestImpl.addParameter("processInstanceId", Long.toString(processInstance.getProcessInstanceId()));
        placeRequestImpl.addParameter("deploymentId", processInstance.getDeploymentId());
        placeRequestImpl.addParameter("serverTemplateId", this.getSelectedServerTemplate());
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void selectProcessInstance(ProcessInstanceSummary summary, Boolean close) {
        PlaceStatus status = this.placeManager.getStatus((PlaceRequest)new DefaultPlaceRequest("Process Instance Details Multi"));
        if (status == PlaceStatus.CLOSE) {
            this.placeManager.goTo("Process Instance Details Multi");
            this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), summary.getState(), this.getSelectedServerTemplate()));
        } else if (status == PlaceStatus.OPEN && !close.booleanValue()) {
            this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(summary.getDeploymentId(), summary.getProcessInstanceId(), summary.getProcessId(), summary.getProcessName(), summary.getState(), this.getSelectedServerTemplate()));
        } else if (status == PlaceStatus.OPEN && close.booleanValue()) {
            this.placeManager.closePlace("Process Instance Details Multi");
        }
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstancesWithDetailsRequestEvent event) {
        this.placeManager.goTo("Process Instance Details Multi");
        this.processInstanceSelected.fire((Object)new ProcessInstanceSelectionEvent(event.getDeploymentId(), event.getProcessInstanceId(), event.getProcessDefId(), event.getProcessDefName(), event.getProcessInstanceStatus(), event.getServerTemplateId()));
    }

    public void formClosed(@Observes BeforeClosePlaceEvent closed) {
        if ("Signal Process Popup".equals(closed.getPlace().getIdentifier())) {
            this.refreshGrid();
        }
    }

    @Inject
    public void setProcessService(Caller<ProcessService> processService) {
        this.processService = processService;
    }

    public void setupAdvancedSearchView() {
        ((ProcessInstanceListView)this.view).addNumericFilter(this.constants.Id(), this.constants.FilterByProcessInstanceId(), v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))));
        ((ProcessInstanceListView)this.view).addTextFilter(this.constants.Initiator(), this.constants.FilterByInitiator(), v -> this.addAdvancedSearchFilter(FilterFactory.likeTo((String)"user_identity", (String)v, (boolean)false)), v -> this.removeAdvancedSearchFilter(FilterFactory.likeTo((String)"user_identity", (String)v, (boolean)false)));
        ((ProcessInstanceListView)this.view).addTextFilter(this.constants.Correlation_Key(), this.constants.FilterByCorrelationKey(), v -> this.addAdvancedSearchFilter(FilterFactory.likeTo((String)"correlationKey", (String)v, (boolean)false)), v -> this.removeAdvancedSearchFilter(FilterFactory.likeTo((String)"correlationKey", (String)v, (boolean)false)));
        ((ProcessInstanceListView)this.view).addTextFilter(this.constants.Process_Instance_Description(), this.constants.FilterByDescription(), v -> this.addAdvancedSearchFilter(FilterFactory.likeTo((String)"processInstanceDescription", (String)v, (boolean)false)), v -> this.removeAdvancedSearchFilter(FilterFactory.likeTo((String)"processInstanceDescription", (String)v, (boolean)false)));
        HashMap<String, String> states = new HashMap<String, String>();
        states.put(String.valueOf(1), this.constants.Active());
        states.put(String.valueOf(3), this.constants.Aborted());
        states.put(String.valueOf(2), this.constants.Completed());
        states.put(String.valueOf(0), this.constants.Pending());
        states.put(String.valueOf(4), this.constants.Suspended());
        ((ProcessInstanceListView)this.view).addSelectFilter(this.constants.State(), states, false, v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
        HashMap<String, String> errorOptions = new HashMap<String, String>();
        errorOptions.put(String.valueOf(true), this.constants.HasErrorsYes());
        errorOptions.put(String.valueOf(false), this.constants.HasErrorsNo());
        Function<String, ColumnFilter> errorFilterGenerator = new Function<String, ColumnFilter>(){

            @Override
            public ColumnFilter apply(String hasErrors) {
                return Boolean.valueOf(hasErrors) != false ? FilterFactory.greaterThan((String)"errorCount", (Comparable)Integer.valueOf(0)) : FilterFactory.lowerOrEqualsTo((String)"errorCount", (Comparable)Integer.valueOf(0));
            }
        };
        ((ProcessInstanceListView)this.view).addSelectFilter(this.constants.Errors(), errorOptions, false, v -> this.addAdvancedSearchFilter((ColumnFilter)errorFilterGenerator.apply((String)v)), v -> this.removeAdvancedSearchFilter((ColumnFilter)errorFilterGenerator.apply((String)v)));
        DataSetLookup dataSetLookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("jbpmProcessInstances")).group("processName")).column("processName")).sort("processName", SortOrder.ASCENDING)).buildLookup();
        ((ProcessInstanceListView)this.view).addDataSetSelectFilter(this.constants.Name(), "base", dataSetLookup, "processName", "processName", v -> this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processName", (Comparable)((Object)v))), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processName", (Comparable)((Object)v))));
        ((ProcessInstanceListView)this.view).addDateRangeFilter(this.constants.Start_Date(), v -> this.addAdvancedSearchFilter(FilterFactory.between((String)"start_date", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())), v -> this.removeAdvancedSearchFilter(FilterFactory.between((String)"start_date", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())));
        ((ProcessInstanceListView)this.view).addDateRangeFilter(this.constants.Last_Modification_Date(), v -> this.addAdvancedSearchFilter(FilterFactory.between((String)"lastModificationDate", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())), v -> this.removeAdvancedSearchFilter(FilterFactory.between((String)"lastModificationDate", (Comparable)v.getStartDate(), (Comparable)v.getEndDate())));
    }

    public void setupActiveSearchFilters() {
        Optional processInstanceSearch;
        boolean hasSearchParam = false;
        Optional processDefinitionSearch = this.getSearchParameter("processDefinitionId");
        if (processDefinitionSearch.isPresent()) {
            String processDefinitionId = (String)processDefinitionSearch.get();
            ((ProcessInstanceListView)this.view).addActiveFilter(this.constants.Process_Definition_Id(), processDefinitionId, processDefinitionId, v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)v))));
            this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processId", (Comparable)((Object)processDefinitionId)));
            hasSearchParam = true;
        }
        if ((processInstanceSearch = this.getSearchParameter("processInstanceId")).isPresent()) {
            String processInstanceId = (String)processInstanceSearch.get();
            ((ProcessInstanceListView)this.view).addActiveFilter(this.constants.Id(), processInstanceId, processInstanceId, v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)v))));
            this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"processInstanceId", (Comparable)((Object)processInstanceId)));
            hasSearchParam = true;
        }
        if (!hasSearchParam) {
            this.setupDefaultActiveSearchFilters();
        }
    }

    public void setupDefaultActiveSearchFilters() {
        ((ProcessInstanceListView)this.view).addActiveFilter(this.constants.State(), this.constants.Active(), String.valueOf(1), v -> this.removeAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)v))));
        this.addAdvancedSearchFilter(FilterFactory.equalsTo((String)"status", (Comparable)((Object)String.valueOf(1))));
    }

    public void openJobsView(String pid) {
        this.navigateToPerspective("Requests", "processInstanceId", pid);
    }

    public void openTaskView(String pid) {
        this.navigateToPerspective(this.isUserAuthorizedForPerspective("TaskAdmin") ? "TaskAdmin" : "Tasks", "processInstanceId", pid);
    }

    public Predicate<ProcessInstanceSummary> getSignalActionCondition() {
        return pis -> pis.getState() == 1;
    }

    public Predicate<ProcessInstanceSummary> getAbortActionCondition() {
        return pis -> pis.getState() == 1;
    }

    public Predicate<ProcessInstanceSummary> getViewJobsActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("Requests");
    }

    public Predicate<ProcessInstanceSummary> getViewTasksActionCondition() {
        return pis -> this.isUserAuthorizedForPerspective("TaskAdmin") || this.isUserAuthorizedForPerspective("Tasks");
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmProcessInstances");
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("start_date", SortOrder.DESCENDING);
        builder.tableWidth(1000);
        FilterSettings filterSettings = builder.buildSettings();
        filterSettings.setUUID("jbpmProcessInstances");
        return filterSettings;
    }

    private FilterSettings createStatusSettings(Integer state) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmProcessInstances");
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", (Comparable)state)});
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("start_date", SortOrder.DESCENDING);
        return builder.buildSettings();
    }

    public FilterSettings createSearchTabSettings() {
        return this.createTableSettingsPrototype();
    }

    public FilterSettings createActiveTabSettings() {
        return this.createStatusSettings(1);
    }

    public FilterSettings createCompletedTabSettings() {
        return this.createStatusSettings(2);
    }

    public FilterSettings createAbortedTabSettings() {
        return this.createStatusSettings(3);
    }

    public FilterSettings getVariablesTableSettings(String processName) {
        String tableSettingsJSON = "{\n    \"type\": \"TABLE\",\n    \"filter\": {\n        \"enabled\": \"true\",\n        \"selfapply\": \"true\",\n        \"notification\": \"true\",\n        \"listening\": \"true\"\n    },\n    \"table\": {\n        \"sort\": {\n            \"enabled\": \"true\",\n            \"columnId\": \"processInstanceId\",\n            \"order\": \"ASCENDING\"\n        }\n    },\n    \"dataSetLookup\": {\n        \"dataSetUuid\": \"jbpmProcessInstancesWithVariables\",\n        \"rowCount\": \"-1\",\n        \"rowOffset\": \"0\",\n";
        if (processName != null) {
            tableSettingsJSON = tableSettingsJSON + "        \"filterOps\":[{\"columnId\":\"processId\", \"functionType\":\"EQUALS_TO\", \"terms\":[\"" + processName + "\"]}],";
        }
        tableSettingsJSON = tableSettingsJSON + "        \"groupOps\": [\n            {\n                \"groupFunctions\": [\n                    {\n                        \"sourceId\": \"processInstanceId\",\n                        \"columnId\": \"processInstanceId\"\n                    },\n                    {\n                        \"sourceId\": \"processId\",\n                        \"columnId\": \"processId\"\n                    },\n                    {\n                        \"sourceId\": \"id\",\n                        \"columnId\": \"id\"\n                    },\n                    {\n                        \"sourceId\": \"variableId\",\n                        \"columnId\": \"variableId\"\n                    },\n                    {\n                        \"sourceId\": \"value\",\n                        \"columnId\": \"value\"\n                    }\n                ],\n                \"join\": \"false\"\n            }\n        ]\n    },\n    \"columns\": [\n        {\n            \"id\": \"processInstanceId\",\n            \"name\": \"processInstanceId\"\n        },\n        {\n            \"id\": \"processId\",\n            \"name\": \"processName\"\n        },\n        {\n            \"id\": \"id\",\n            \"name\": \"variableID\"\n        },\n        {\n            \"id\": \"variableId\",\n            \"name\": \"variableName\"\n        },\n        {\n            \"id\": \"value\",\n            \"name\": \"variableValue\"\n        }\n    ],\n    \"tableName\": \"Filtered\",\n    \"tableDescription\": \"Filtered Desc\",\n    \"tableEditEnabled\": \"false\"\n}";
        return this.tableSettingsJSONMarshaller.fromJsonString(tableSettingsJSON);
    }

    public static interface ProcessInstanceListView
    extends MultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter> {
        public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> var1, Set<String> var2);
    }
}

