/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
@Templated(value="ProcessInstanceSummaryErrorPopoverCell.html", stylesheet="ProcessInstanceSummaryErrorPopoverCell.css")
public class ProcessInstanceSummaryErrorPopoverCell
extends AbstractCell<ProcessInstanceSummary>
implements IsElement {
    private static final Constants I18N = Constants.INSTANCE;
    private static final String VIEW_ERROR_LINK_NAME = "viewErrAnchor";
    private static final String PROCESS_INSTANCE_ATTRIBUTE = "data-jbpm-processInstanceId";
    private static final String ERROR_PRESENT_STYLE = "error-present";
    @Inject
    private PlaceManager placeManager;
    @Inject
    @DataField(value="popover")
    private Popover popover;
    @Inject
    @DataField(value="popoverContent")
    private Span popoverContent;
    @Inject
    @DataField(value="contentErrCount")
    private Span contentErrCount;
    @Inject
    @DataField(value="viewErrAnchor")
    private Anchor viewErrAnchor;

    public ProcessInstanceSummaryErrorPopoverCell() {
        super(new String[0]);
    }

    public void render(Cell.Context context, ProcessInstanceSummary value, SafeHtmlBuilder sb) {
        Integer errCount = value != null && value.getErrorCount() != null ? value.getErrorCount() : 0;
        HTMLElement popoverAnchor = this.popover.getElement();
        popoverAnchor.setTextContent(Integer.toString(errCount));
        if (errCount > 0) {
            this.viewErrAnchor.setTitle(I18N.ErrorCountViewLink());
            this.viewErrAnchor.setTextContent(I18N.ErrorCountViewLink());
            this.viewErrAnchor.setAttribute(PROCESS_INSTANCE_ATTRIBUTE, Long.toString(value.getProcessInstanceId()));
            this.contentErrCount.setTextContent(I18N.ErrorCountNumber(errCount));
            popoverAnchor.setAttribute("data-toggle", "popover");
            popoverAnchor.getClassList().add(ERROR_PRESENT_STYLE);
            Scheduler.get().scheduleDeferred(() -> this.initPopovers(VIEW_ERROR_LINK_NAME, PROCESS_INSTANCE_ATTRIBUTE));
        } else {
            popoverAnchor.removeAttribute("data-toggle");
            popoverAnchor.getClassList().remove(ERROR_PRESENT_STYLE);
        }
        sb.appendHtmlConstant(popoverAnchor.getOuterHTML());
    }

    public void openErrorView(String pid) {
        DefaultPlaceRequest request = new DefaultPlaceRequest("ExecutionErrors");
        if (pid != null) {
            request.addParameter("processInstanceId", pid);
        }
        this.placeManager.goTo((PlaceRequest)request);
    }

    public String getPopoverContent() {
        return this.popoverContent.getInnerHTML();
    }

    private native void initPopovers(String var1, String var2);
}

