/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.list;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.client.util.GenericErrorSummaryCountCell;
import org.jbpm.workbench.common.client.util.SLAComplianceCell;
import org.jbpm.workbench.pr.client.editors.instance.list.ProcessInstanceListPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.model.ProcessInstanceSummary;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
@Templated(value="/org/jbpm/workbench/common/client/list/AbstractMultiGridView.html", stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class ProcessInstanceListViewImpl
extends AbstractMultiGridView<ProcessInstanceSummary, ProcessInstanceListPresenter>
implements ProcessInstanceListPresenter.ProcessInstanceListView {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private ConfirmPopup confirmPopup;
    @Inject
    private ManagedInstance<GenericErrorSummaryCountCell> popoverCellInstance;

    public List<String> getInitColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "processVersion", "lastModificationDate", "errorCount", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("Select", "processInstanceId", "processName", "processInstanceDescription", "Actions");
    }

    public void initSelectionModel(ListTable<ProcessInstanceSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Process_Instances_Found());
        extendedPagedTable.setSelectionCallback(pis -> ((ProcessInstanceListPresenter)this.presenter).selectProcessInstance((ProcessInstanceSummary)pis));
        this.initBulkActions((ExtendedPagedTable)extendedPagedTable);
    }

    public List<AnchorListItem> getBulkActionsItems(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        ArrayList<AnchorListItem> bulkActionsItems = new ArrayList<AnchorListItem>();
        bulkActionsItems.add(this.getBulkAbort(extendedPagedTable));
        bulkActionsItems.add(this.getBulkSignal(extendedPagedTable));
        return bulkActionsItems;
    }

    public void initColumns(ListTable<ProcessInstanceSummary> extendedPagedTable) {
        ColumnMeta checkColumnMeta = this.initChecksColumn(extendedPagedTable);
        ColumnMeta actionsColumnMeta = this.initActionsColumn();
        Column<ProcessInstanceSummary, ProcessInstanceSummary> errorCountColumn = this.initErrorCountColumn();
        Column<ProcessInstanceSummary, Integer> slaComplianceColumn = this.initSlaComplianceColumn();
        extendedPagedTable.addSelectionIgnoreColumn(checkColumnMeta.getColumn());
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        extendedPagedTable.addSelectionIgnoreColumn(errorCountColumn);
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(checkColumnMeta);
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceId", process -> String.valueOf(process.getProcessInstanceId())), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", process -> process.getProcessName()), this.constants.Name()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", process -> process.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("user_identity", process -> process.getInitiator()), this.constants.Initiator()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processVersion", process -> process.getProcessVersion()), this.constants.Version()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", process -> {
            switch (process.getState()) {
                case 1: {
                    return this.constants.Active();
                }
                case 3: {
                    return this.constants.Aborted();
                }
                case 2: {
                    return this.constants.Completed();
                }
                case 0: {
                    return this.constants.Pending();
                }
                case 4: {
                    return this.constants.Suspended();
                }
            }
            return this.constants.Unknown();
        }), this.constants.State()));
        Column startColumn = this.createTextColumn("start_date", process -> DateUtils.getDateTimeStr((Date)process.getStartTime()));
        startColumn.setDefaultSortAscending(false);
        columnMetas.add(new ColumnMeta(startColumn, this.constants.Start_Date()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("lastModificationDate", process -> DateUtils.getDateTimeStr((Date)process.getLastModificationDate())), this.constants.Last_Modification_Date()));
        columnMetas.add(new ColumnMeta(slaComplianceColumn, this.constants.SlaCompliance()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("sla_due_date", process -> DateUtils.getDateTimeStr((Date)process.getSlaDueDate())), this.constants.SlaDueDate()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("correlationKey", process -> process.getCorrelationKey()), this.constants.Correlation_Key()));
        columnMetas.add(new ColumnMeta(errorCountColumn, this.constants.Errors()));
        columnMetas.add(actionsColumnMeta);
        List columnPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columnPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.setColumnWidth(checkColumnMeta.getColumn(), 38.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(errorCountColumn, 65.0, Style.Unit.PX);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 175.0, Style.Unit.PX);
        extendedPagedTable.getColumnSortList().push(startColumn);
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private Column initGenericColumn(final String key) {
        Column<ProcessInstanceSummary, String> genericColumn = new Column<ProcessInstanceSummary, String>((Cell)new TextCell()){

            public String getValue(ProcessInstanceSummary object) {
                return object.getDomainDataValue(key);
            }
        };
        genericColumn.setSortable(true);
        genericColumn.setDataStoreName(key);
        return genericColumn;
    }

    protected AnchorListItem getBulkAbort(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        AnchorListItem bulkAbortNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkAbortNavLink.setText(this.constants.Bulk_Abort());
        bulkAbortNavLink.setIcon(IconType.BAN);
        bulkAbortNavLink.setIconFixedWidth(true);
        bulkAbortNavLink.addClickHandler(event -> this.confirmPopup.show(this.constants.Abort_Confirmation(), this.constants.Abort(), this.constants.Abort_Process_Instances(), this.getAbortCommand(extendedPagedTable)));
        return bulkAbortNavLink;
    }

    protected AnchorListItem getBulkSignal(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        AnchorListItem bulkSignalNavLink = (AnchorListItem)GWT.create(AnchorListItem.class);
        bulkSignalNavLink.setText(this.constants.Bulk_Signal());
        bulkSignalNavLink.setIcon(IconType.BELL);
        bulkSignalNavLink.setIconFixedWidth(true);
        bulkSignalNavLink.addClickHandler(event -> this.getSignalCommand(extendedPagedTable).execute());
        return bulkSignalNavLink;
    }

    protected Command getSignalCommand(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        return () -> {
            ((ProcessInstanceListPresenter)this.presenter).bulkSignal(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
        };
    }

    protected Command getAbortCommand(ExtendedPagedTable<ProcessInstanceSummary> extendedPagedTable) {
        return () -> {
            ((ProcessInstanceListPresenter)this.presenter).bulkAbort(extendedPagedTable.getSelectedItems());
            extendedPagedTable.deselectAllItems();
        };
    }

    private Column<ProcessInstanceSummary, ProcessInstanceSummary> initErrorCountColumn() {
        Column<ProcessInstanceSummary, ProcessInstanceSummary> column = new Column<ProcessInstanceSummary, ProcessInstanceSummary>((Cell)((GenericErrorSummaryCountCell)this.popoverCellInstance.get()).init(this.presenter)){

            public ProcessInstanceSummary getValue(ProcessInstanceSummary process) {
                return process;
            }
        };
        column.setSortable(true);
        column.setDataStoreName("errorCount");
        return column;
    }

    private Column<ProcessInstanceSummary, Integer> initSlaComplianceColumn() {
        ArrayList<String> slaDescriptions = new ArrayList<String>();
        slaDescriptions.add(this.constants.Unknown());
        slaDescriptions.add(this.constants.SlaNA());
        slaDescriptions.add(this.constants.SlaPending());
        slaDescriptions.add(this.constants.SlaMet());
        slaDescriptions.add(this.constants.SlaAborted());
        slaDescriptions.add(this.constants.SlaViolated());
        Column<ProcessInstanceSummary, Integer> column = new Column<ProcessInstanceSummary, Integer>((Cell)new SLAComplianceCell(slaDescriptions)){

            public Integer getValue(ProcessInstanceSummary process) {
                return process.getSlaCompliance();
            }
        };
        column.setSortable(true);
        column.setDataStoreName("slaCompliance");
        return column;
    }

    protected List<ConditionalAction<ProcessInstanceSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Signal(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).signalProcessInstance((ProcessInstanceSummary)processInstance), ((ProcessInstanceListPresenter)this.presenter).getSignalActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.Abort(), processInstance -> this.confirmPopup.show(this.constants.Abort_Confirmation(), this.constants.Abort(), this.constants.Abort_Process_Instance(), () -> ((ProcessInstanceListPresenter)this.presenter).abortProcessInstance(processInstance.getDeploymentId(), processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getAbortActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.ViewJobs(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).openJobsView(Long.toString(processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getViewJobsActionCondition(), Boolean.valueOf(true)), new ConditionalAction(this.constants.ViewTasks(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).openTaskView(Long.toString(processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getViewTasksActionCondition(), Boolean.valueOf(true)), new ConditionalAction(this.constants.ViewErrors(), processInstance -> ((ProcessInstanceListPresenter)this.presenter).openErrorView(Long.toString(processInstance.getProcessInstanceId())), ((ProcessInstanceListPresenter)this.presenter).getViewErrorsActionCondition(), Boolean.valueOf(true)));
    }
}

