/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogFilterSettingsManager;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogPresenter;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

@RunWith(value=GwtMockitoTestRunner.class)
public class ProcessInstanceLogPresenterTest {
    @Mock
    ProcessInstanceLogPresenter.ProcessInstanceLogView view;
    @Mock
    protected ErrorPopupPresenter errorPopup;
    @Mock
    protected DataSetQueryHelper dataSetQueryHelper;
    @Mock
    protected ProcessInstanceLogFilterSettingsManager filterSettingsManager;
    @Mock
    FilterSettings currentFilterSettings;
    @Mock
    private DataSet dataSet;
    @InjectMocks
    ProcessInstanceLogPresenter presenter;
    private String processName = "processName";
    private String testTask = "testTask";
    private String datasetUID = "jbpmProcessInstanceLogs";
    private Date logDate = new Date();
    private String prettyTime = "";
    private String techTime;

    @Before
    public void setup() {
        this.techTime = DateUtils.getDateTimeStr((Date)this.logDate);
        this.defineDatasetAnswer(0, 1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_START, false);
        this.defineDatasetAnswer(1, 2L, this.logDate, this.testTask, ProcessInstanceLogPresenter.NODE_HUMAN_TASK, false);
        this.defineDatasetAnswer(2, 3L, this.logDate, "", ProcessInstanceLogPresenter.NODE_END, true);
        this.defineDatasetAnswer(3, 4L, this.logDate, "", "Split", false);
        Mockito.when((Object)this.dataSet.getRowCount()).thenReturn((Object)4);
        Mockito.when((Object)this.dataSet.getUUID()).thenReturn((Object)this.datasetUID);
        this.presenter.setDataSetQueryHelper(this.dataSetQueryHelper);
        this.presenter.setFilterSettingsManager(this.filterSettingsManager);
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(ProcessInstanceLogPresenterTest.this.dataSet);
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.currentFilterSettings);
        Mockito.when((Object)this.filterSettingsManager.createDefaultFilterSettingsPrototype(Long.valueOf(Mockito.anyLong()))).thenReturn((Object)this.currentFilterSettings);
        Mockito.when((Object)this.currentFilterSettings.getKey()).thenReturn((Object)"key");
        Mockito.when((Object)this.currentFilterSettings.getDataSet()).thenReturn((Object)this.dataSet);
        this.presenter.setProcessName(this.processName);
    }

    @Test
    public void addTechLogLineTest() {
        Optional logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_START, false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", false, true), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_START, true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", true, false), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "testTask", ProcessInstanceLogPresenter.NODE_HUMAN_TASK, false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, false, false), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "testTask", ProcessInstanceLogPresenter.NODE_HUMAN_TASK, true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, true, true), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_END, false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", false, false), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_END, true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", true, false), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", "Split", false), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", false, false), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", "Split", true), LogUtils.LogType.TECHNICAL);
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", true, false), logLine.get());
    }

    @Test
    public void addBusinessLoglineTest() {
        this.presenter.setProcessName(this.processName);
        Optional logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_START, false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasStarted()), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_START, true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "testTask", ProcessInstanceLogPresenter.NODE_HUMAN_TASK, false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasStarted()), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "testTask", ProcessInstanceLogPresenter.NODE_HUMAN_TASK, true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasCompleted()), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_END, false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", ProcessInstanceLogPresenter.NODE_END, true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasCompleted()), logLine.get());
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", "Split", false), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
        logLine = this.presenter.getLogLine(this.createProcessInstanceLogSummary(1L, this.logDate, "", "Split", true), LogUtils.LogType.BUSINESS);
        Assert.assertEquals(Optional.empty(), (Object)logLine);
    }

    @Test
    public void refreshProcessInstanceDataAscTechTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.TECHNICAL);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("log_date");
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)4L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", false, true), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, false, false), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", true, false), ((List)argumentDESC.getValue()).get(2));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", false, false), ((List)argumentDESC.getValue()).get(3));
    }

    @Test
    public void refreshProcessInstanceDataDescTechTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.DESC, LogUtils.LogType.TECHNICAL);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.DESCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("log_date");
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)4L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "StartNode", "", false, true), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "HumanTaskNode", this.testTask, false, false), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "EndNode", "", true, false), ((List)argumentDESC.getValue()).get(2));
        Assert.assertEquals((Object)this.getTechLogCall(this.techTime, "Split", "", false, false), ((List)argumentDESC.getValue()).get(3));
    }

    @Test
    public void refreshProcessInstanceDataAscBusinessTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.BUSINESS);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("log_date");
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)3L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasCompleted()), ((List)argumentDESC.getValue()).get(2));
    }

    @Test
    public void refreshProcessInstanceDataDescBusinessTest() {
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.DESC, LogUtils.LogType.BUSINESS);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.DESCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("log_date");
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)3L, (long)((List)argumentDESC.getValue()).size());
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(0));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Task(), this.testTask, Constants.INSTANCE.WasStarted()), ((List)argumentDESC.getValue()).get(1));
        Assert.assertEquals((Object)this.getBusinessLogCall(this.prettyTime, Constants.INSTANCE.Process(), this.processName, Constants.INSTANCE.WasCompleted()), ((List)argumentDESC.getValue()).get(2));
    }

    private String getBusinessLogCall(String time, String logType, String logName, String completed) {
        return ProcessInstanceLogPresenter.LOG_TEMPLATES.getBusinessLog(time, logType, SafeHtmlUtils.fromString((String)logName), completed).asString();
    }

    private String getTechLogCall(String time, String logType, String logName, boolean completed, boolean human) {
        return ProcessInstanceLogPresenter.LOG_TEMPLATES.getTechLog(time, logType, SafeHtmlUtils.fromString((String)logName), completed ? " " + Constants.INSTANCE.Completed() : "", human ? Constants.INSTANCE.Human() : Constants.INSTANCE.System()).asString();
    }

    public void defineDatasetAnswer(int position, Long id, Date date, String nodeName, String nodeType, boolean completed) {
        Mockito.when((Object)this.dataSet.getValueAt(position, "nodeInstanceId")).thenReturn((Object)id);
        Mockito.when((Object)this.dataSet.getValueAt(position, "log_date")).thenReturn((Object)date);
        Mockito.when((Object)this.dataSet.getValueAt(position, "nodeName")).thenReturn((Object)nodeName);
        Mockito.when((Object)this.dataSet.getValueAt(position, "nodeType")).thenReturn((Object)nodeType);
        Mockito.when((Object)this.dataSet.getValueAt(position, "type")).thenReturn((Object)(completed ? 1 : 0));
    }

    private ProcessInstanceLogSummary createProcessInstanceLogSummary(Long id, Date date, String nodeName, String nodeType, boolean completed) {
        return ProcessInstanceLogSummary.builder().id(id).date(date).name(nodeName).nodeType(nodeType).completed(completed).build();
    }

    @Test
    public void datasetLookupNotFoundTest() {
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).notFound();
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.TECHNICAL);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopup)).showMessage((String)Mockito.eq((Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetNotFound(this.datasetUID)));
    }

    @Test
    public void datasetLookupErrorTest() {
        final String errorMessage = "error message";
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).onError(new ClientRuntimeError(errorMessage));
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Mockito.anyInt()), (DataSetReadyCallback)Mockito.any(DataSetReadyCallback.class));
        this.presenter.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.TECHNICAL);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopup)).showMessage((String)Mockito.eq((Object)org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetError(this.datasetUID, errorMessage)));
    }

    @Test
    public void onProcessInstaceSelectionTest() {
        Long processInstanceId = 1L;
        String processDefId = "processDefId";
        String deploymentId = "deploymentId";
        Integer processInstanceStatus = 0;
        String serverTemplateId = "serverTemplateId";
        this.presenter.onProcessInstanceSelectionEvent(new ProcessInstanceSelectionEvent(deploymentId, processInstanceId, processDefId, this.processName, processInstanceStatus, serverTemplateId));
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setActiveLogOrderButton(LogUtils.LogOrder.ASC);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setActiveLogTypeButton(LogUtils.LogType.BUSINESS);
        ((ProcessInstanceLogFilterSettingsManager)Mockito.verify((Object)this.filterSettingsManager)).createDefaultFilterSettingsPrototype((Long)Mockito.eq((Object)processInstanceId));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.times((int)2))).setCurrentTableSettings(this.filterSettingsManager.createDefaultFilterSettingsPrototype(processInstanceId));
        this.dataSetQueryHelper.setCurrentTableSettings(this.filterSettingsManager.createDefaultFilterSettingsPrototype(processInstanceId));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("log_date");
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((ProcessInstanceLogPresenter.ProcessInstanceLogView)Mockito.verify((Object)this.view)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)3L, (long)((List)argumentDESC.getValue()).size());
    }
}

