/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.client.editors.instance.log;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogFilterSettingsManager;
import org.jbpm.workbench.pr.client.editors.instance.log.ProcessInstanceLogSummaryDataSetMapper;
import org.jbpm.workbench.pr.client.resources.i18n.Constants;
import org.jbpm.workbench.pr.client.util.LogUtils;
import org.jbpm.workbench.pr.events.ProcessInstanceSelectionEvent;
import org.jbpm.workbench.pr.model.ProcessInstanceLogSummary;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

@Dependent
public class ProcessInstanceLogPresenter {
    public static final LogTemplates LOG_TEMPLATES = (LogTemplates)GWT.create(LogTemplates.class);
    public static String NODE_HUMAN_TASK = "HumanTaskNode";
    public static String NODE_START = "StartNode";
    public static String NODE_END = "EndNode";
    private Constants constants = Constants.INSTANCE;
    private String processName;
    private String serverTemplateId;
    @Inject
    private ProcessInstanceLogView view;
    int pageSize = Integer.MAX_VALUE;
    int startRange = 0;
    protected DataSetQueryHelper dataSetQueryHelper;
    protected ProcessInstanceLogFilterSettingsManager filterSettingsManager;
    @Inject
    protected ErrorPopupPresenter errorPopup;

    @Inject
    public void setDataSetQueryHelper(DataSetQueryHelper dataSetQueryHelper) {
        this.dataSetQueryHelper = dataSetQueryHelper;
    }

    @Inject
    public void setFilterSettingsManager(ProcessInstanceLogFilterSettingsManager filterSettingsManager) {
        this.filterSettingsManager = filterSettingsManager;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getWidget() {
        return this.view;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setServerTemplateId(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
    }

    public void refreshProcessInstanceData(LogUtils.LogOrder logOrder, final LogUtils.LogType logType) {
        try {
            final FilterSettings currentTableSettings = this.dataSetQueryHelper.getCurrentTableSettings();
            currentTableSettings.setServerTemplateId(this.serverTemplateId);
            currentTableSettings.setTablePageSize(this.pageSize);
            this.dataSetQueryHelper.setLastOrderedColumn("log_date");
            this.dataSetQueryHelper.setLastSortOrder(logOrder.equals((Object)LogUtils.LogOrder.ASC) ? SortOrder.ASCENDING : SortOrder.DESCENDING);
            this.dataSetQueryHelper.setCurrentTableSettings(currentTableSettings);
            this.dataSetQueryHelper.setDataSetHandler(currentTableSettings);
            this.dataSetQueryHelper.lookupDataSet(Integer.valueOf(this.startRange), new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    if (dataSet != null && ProcessInstanceLogPresenter.this.dataSetQueryHelper.getCurrentTableSettings().getKey().equals(currentTableSettings.getKey())) {
                        ArrayList<ProcessInstanceLogSummary> logs = new ArrayList<ProcessInstanceLogSummary>();
                        for (int i = 0; i < dataSet.getRowCount(); ++i) {
                            logs.add(new ProcessInstanceLogSummaryDataSetMapper().apply(dataSet, i));
                        }
                        List<String> logsLines = logs.stream().map(rls -> ProcessInstanceLogPresenter.this.getLogLine((ProcessInstanceLogSummary)rls, logType)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                        ProcessInstanceLogPresenter.this.view.setLogs(logsLines);
                    }
                }

                public void notFound() {
                    ProcessInstanceLogPresenter.this.errorPopup.showMessage(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetNotFound(currentTableSettings.getDataSet().getUUID()));
                }

                public boolean onError(ClientRuntimeError error) {
                    ProcessInstanceLogPresenter.this.errorPopup.showMessage(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.DataSetError(currentTableSettings.getDataSet().getUUID(), error.getMessage()));
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.errorPopup.showMessage(org.jbpm.workbench.common.client.resources.i18n.Constants.INSTANCE.UnexpectedError(e.getMessage()));
        }
    }

    protected Optional<String> getLogLine(ProcessInstanceLogSummary logSummary, LogUtils.LogType logType) {
        if (LogUtils.LogType.TECHNICAL.equals((Object)logType)) {
            String agent = this.constants.System();
            if (NODE_HUMAN_TASK.equals(logSummary.getNodeType()) && logSummary.isCompleted() || NODE_START.equals(logSummary.getNodeType()) && !logSummary.isCompleted()) {
                agent = this.constants.Human();
            }
            return Optional.of(LOG_TEMPLATES.getTechLog(DateUtils.getDateTimeStr((Date)logSummary.getDate()), logSummary.getNodeType(), SafeHtmlUtils.fromString((String)logSummary.getName()), logSummary.isCompleted() ? " " + this.constants.Completed() : "", agent).asString());
        }
        String prettyTime = DateUtils.getPrettyTime((Date)logSummary.getDate());
        if (NODE_HUMAN_TASK.equals(logSummary.getNodeType())) {
            return Optional.of(LOG_TEMPLATES.getBusinessLog(prettyTime, this.constants.Task(), SafeHtmlUtils.fromString((String)logSummary.getName()), logSummary.isCompleted() ? this.constants.WasCompleted() : this.constants.WasStarted()).asString());
        }
        if (NODE_START.equals(logSummary.getNodeType()) && !logSummary.isCompleted()) {
            return Optional.of(LOG_TEMPLATES.getBusinessLog(prettyTime, this.constants.Process(), SafeHtmlUtils.fromString((String)this.getProcessName()), this.constants.WasStarted()).asString());
        }
        if (NODE_END.equals(logSummary.getNodeType()) && logSummary.isCompleted()) {
            return Optional.of(LOG_TEMPLATES.getBusinessLog(prettyTime, this.constants.Process(), SafeHtmlUtils.fromString((String)this.getProcessName()), this.constants.WasCompleted()).asString());
        }
        return Optional.empty();
    }

    public void onProcessInstanceSelectionEvent(@Observes ProcessInstanceSelectionEvent event) {
        this.setProcessName(event.getProcessDefName());
        this.setServerTemplateId(event.getServerTemplateId());
        this.view.setActiveLogOrderButton(LogUtils.LogOrder.ASC);
        this.view.setActiveLogTypeButton(LogUtils.LogType.BUSINESS);
        this.dataSetQueryHelper.setCurrentTableSettings(this.filterSettingsManager.createDefaultFilterSettingsPrototype(event.getProcessInstanceId()));
        this.refreshProcessInstanceData(LogUtils.LogOrder.ASC, LogUtils.LogType.BUSINESS);
    }

    public static interface LogTemplates
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="{0}: {1} '{2}' {3}")
        public SafeHtml getBusinessLog(String var1, String var2, SafeHtml var3, String var4);

        @SafeHtmlTemplates.Template(value="{0}: {1} ({2}){3} - {4}")
        public SafeHtml getTechLog(String var1, String var2, SafeHtml var3, String var4, String var5);
    }

    public static interface ProcessInstanceLogView
    extends IsWidget {
        public void init(ProcessInstanceLogPresenter var1);

        public void setActiveLogTypeButton(LogUtils.LogType var1);

        public void setActiveLogOrderButton(LogUtils.LogOrder var1);

        public void setLogs(List<String> var1);
    }
}

